import { Head, Link } from "@inertiajs/vue3";
import { I as Icon, L as Layout } from "./Layout-p-cBGERf.js";
import pickBy from "lodash/pickBy.js";
import { P as Pagination } from "./Pagination-DBkwUgAS.js";
import mapValues from "lodash/mapValues.js";
import throttle from "lodash/throttle.js";
import { a as BoardFilter, B as BoardViewMenu } from "./BoardViewMenu-DKT5LdJ5.js";
import moment from "moment";
import { S as SearchInput } from "./SearchInput-DlyU-0R8.js";
import { resolveComponent, mergeProps, withCtx, createTextVNode, toDisplayString, useSSRContext } from "vue";
import { ssrRenderAttrs, ssrRenderComponent, ssrInterpolate, ssrRenderList, ssrRenderAttr } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import "./FlashMessages-DizfipYZ.js";
import "@popperjs/core";
import "axios";
import "uuid";
import "moment-duration-format";
import "laravel-vue-i18n";
const _sfc_main = {
  components: {
    BoardFilter,
    Head,
    Icon,
    Link,
    BoardViewMenu,
    Pagination,
    SearchInput
  },
  layout: Layout,
  props: {
    title: String,
    auth: Object,
    project: Object,
    workspace: Object,
    time_logs: Object,
    total_duration: { required: false },
    filters: Object
  },
  data() {
    return {
      open_filter: false,
      form: {
        search: this.filters.search,
        user: this.filters.user,
        due: this.filters.due,
        label: this.filters.label
      }
    };
  },
  watch: {
    form: {
      deep: true,
      handler: throttle(function() {
        this.$inertia.get(this.route("projects.view.time_logs", this.project.slug || this.project.id), pickBy(this.form), { preserveState: true });
      }, 150)
    }
  },
  computed: {},
  created() {
    this.moment = moment;
  },
  methods: {
    doFilter(form) {
      Object.assign(this.form, form);
    },
    reset() {
      this.form = mapValues(this.form, () => null);
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Head = resolveComponent("Head");
  const _component_board_view_menu = resolveComponent("board-view-menu");
  const _component_board_filter = resolveComponent("board-filter");
  const _component_search_input = resolveComponent("search-input");
  const _component_Link = resolveComponent("Link");
  const _component_pagination = resolveComponent("pagination");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "h-full" }, _attrs))}>`);
  _push(ssrRenderComponent(_component_Head, {
    title: _ctx.$t($props.title)
  }, null, _parent));
  _push(ssrRenderComponent(_component_board_view_menu, {
    project: $props.project,
    onFilterToggle: ($event) => $data.open_filter = !$data.open_filter,
    onFClear: ($event) => $options.reset(),
    filters: $props.filters,
    view: "time_logs"
  }, null, _parent));
  if ($data.open_filter) {
    _push(ssrRenderComponent(_component_board_filter, {
      project: $props.project,
      onBoardFilter: ($event) => $data.open_filter = false,
      filters: $props.filters,
      onDoFilter: $options.doFilter,
      options: "user"
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`<div class="flex task__time_logs flex-col task__table h-[calc(100%-52px)] overflow-hidden overflow-y-auto"><div class="inline-block min-w-full py-4 align-middle md:px-3 lg:px-4"><div class="tiny__time__log__bar flex justify-between">`);
  _push(ssrRenderComponent(_component_search_input, {
    modelValue: $data.form.search,
    "onUpdate:modelValue": ($event) => $data.form.search = $event,
    class: "w-full max-w-md mr-4",
    onReset: $options.reset
  }, null, _parent));
  if ($props.total_duration) {
    _push(`<div class="flex justify-start"><h4 class="text-[#ffffff] text-lg mr-2">${ssrInterpolate(_ctx.$t("Total duration"))}: ${ssrInterpolate(_ctx.moment.utc(_ctx.moment.duration($props.total_duration, "seconds").as("milliseconds")).format("H[h] m[m] s[s]"))}</h4></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div><div class="table__view"><table><tbody><tr class="text-gray-600 text-sm text-left"><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Task"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Member"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Started"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Stopped"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Duration"))}</th><th class="px-6 pt-3 pb-2">${ssrInterpolate(_ctx.$t("Memo"))}</th></tr><!--[-->`);
  ssrRenderList($props.time_logs.data, (log) => {
    _push(`<tr class="hover:bg-gray-100 focus-within:bg-gray-100 leading-5"><td class="border-t">`);
    _push(ssrRenderComponent(_component_Link, {
      href: this.route("projects.board.with.task", { projectUid: $props.project.slug || $props.project.id, taskUid: log.task.slug || log.task.id }),
      class: "px-6 py-3 flex items-center focus:text-indigo-500"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`${ssrInterpolate(log.task.title)}`);
        } else {
          return [
            createTextVNode(toDisplayString(log.task.title), 1)
          ];
        }
      }),
      _: 2
    }, _parent));
    _push(`</td><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500"><div class="block rounded-full h-6 w-6"><img class="h-full w-full border border-white rounded-full"${ssrRenderAttr("src", log.user.photo_path)}${ssrRenderAttr("alt", log.user.name)}></div><div class="ml-1">${ssrInterpolate(log.user.name)}</div></div></td><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500">${ssrInterpolate(_ctx.moment(log.started_at).format("MMM D, YYYY [at] h:mm a"))}</div></td><td class="border-t"><div class="px-6 py-3 flex items-center focus:text-indigo-500">${ssrInterpolate(_ctx.moment(log.stopped_at).format("MMM D, YYYY [at] h:mm a"))}</div></td><td class="border-t w-px"><div class="px-6 py-3 flex items-center focus:text-indigo-500">${ssrInterpolate(_ctx.moment.utc(_ctx.moment.duration(log.duration, "seconds").as("milliseconds")).format("H[h] m[m] s[s]"))}</div></td><td class="border-t w-px"><div class="px-6 py-3 flex items-center focus:text-indigo-500">${ssrInterpolate(log.title)}</div></td></tr>`);
  });
  _push(`<!--]-->`);
  if ($props.time_logs.data.length === 0) {
    _push(`<tr><td class="border-t px-6 py-4" colspan="6">${ssrInterpolate(_ctx.$t("No time log found."))}</td></tr>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</tbody></table><div class="flex w-full px-3 pb-3">`);
  _push(ssrRenderComponent(_component_pagination, {
    class: "mt-1",
    links: $props.time_logs.links
  }, null, _parent));
  _push(`</div></div></div></div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Pages/Projects/Timer.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Timer = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  Timer as default
};
