import { Link, Head } from "@inertiajs/vue3";
import { I as Icon } from "./Layout-p-cBGERf.js";
import { useSSRContext, mergeProps, resolveComponent } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrRenderComponent, ssrInterpolate, ssrRenderClass, ssrRenderList, ssrRenderAttr, ssrIncludeBooleanAttr } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import Datepicker from "@vuepic/vue-datepicker";
/* empty css              */
import moment from "moment";
import "moment-duration-format";
import { QuillEditor } from "@vueup/vue-quill";
import axios from "axios";
const _sfc_main$1 = {
  name: "loader"
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "processing-overlay flex justify-center pt-20" }, _attrs))}><div class="background"></div><div class="loader"><svg width="80px" height="80px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" style="${ssrRenderStyle({ "background": "none" })}"><circle cx="75" cy="50" fill="#ffffff" r="6.39718"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.875s"></animate></circle><circle cx="67.678" cy="67.678" fill="#ffffff" r="4.8"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.75s"></animate></circle><circle cx="50" cy="75" fill="#ffffff" r="4.8"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.625s"></animate></circle><circle cx="32.322" cy="67.678" fill="#ffffff" r="4.8"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.5s"></animate></circle><circle cx="25" cy="50" fill="#ffffff" r="4.8"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.375s"></animate></circle><circle cx="32.322" cy="32.322" fill="#ffffff" r="4.80282"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.25s"></animate></circle><circle cx="50" cy="25" fill="#ffffff" r="6.40282"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="-0.125s"></animate></circle><circle cx="67.678" cy="32.322" fill="#ffffff" r="7.99718"><animate attributeName="r" values="4.8;4.8;8;4.8;4.8" times="0;0.1;0.2;0.3;1" dur="1s" repeatCount="indefinite" begin="0s"></animate></circle></svg></div></div>`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Loader.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const Loader = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main = {
  props: {
    id: {
      required: true
    },
    isPopup: Boolean,
    view: { required: false }
  },
  emits: { closeModal: null },
  data() {
    return {
      manual_time: { start: null, end: null, seconds: 0, title: "" },
      showManualTimeOption: false,
      showAssigneeBox: false,
      editDescription: false,
      showCommentBox: false,
      showLabelBox: false,
      showMoveCard: false,
      is_move: false,
      label_search: "",
      user_search: "",
      showEditLabelBox: false,
      loading: true,
      newCheckList: false,
      labels: null,
      existing_timer: null,
      users: null,
      list_items: null,
      projects: null,
      counter: { seconds: 0, timer: null, duration: 0 },
      activeTimerString: "",
      new_chek_list: {},
      move_object: {},
      new_comment: {},
      label: {},
      task: {},
      allowed_file_types: (() => {
        var _a, _b, _c;
        const types = (_c = (_b = (_a = this == null ? void 0 : this.$page) == null ? void 0 : _a.props) == null ? void 0 : _b.settings) == null ? void 0 : _c.allowed_file_types;
        try {
          const parsed = Array.isArray(types) ? types : JSON.parse(types);
          const cleaned = parsed.map((t) => t.startsWith(".") ? t : "." + t).filter(Boolean);
          return cleaned.length ? cleaned.join(",") : ".jpg,.jpeg,.png,.gif,.webp,.svg";
        } catch {
          return ".jpg,.jpeg,.png,.gif,.webp,.svg";
        }
      })(),
      colors: [
        { "name": "subtle green", "color": "#baf3db" },
        { "name": "subtle yellow", "color": "#f8e6a0" },
        { "name": "subtle orange", "color": "#ffe2bd" },
        { "name": "subtle red", "color": "#ffd2cc" },
        { "name": "subtle purple", "color": "#dfd8fd" },
        { "name": "green", "color": "#4bce97" },
        { "name": "yellow", "color": "#e2b203" },
        { "name": "orange", "color": "#faa53d" },
        { "name": "red", "color": "#f87462" },
        { "name": "purple", "color": "#9f8fef" },
        { "name": "bold green", "color": "#1f845a" },
        { "name": "bold yellow", "color": "#946f00" },
        { "name": "bold orange", "color": "#b65c02" },
        { "name": "bold red", "color": "#ca3521" },
        { "name": "bold purple", "color": "#6e5dc6" },
        { "name": "subtle blue", "color": "#cce0ff" },
        { "name": "subtle sky", "color": "#c1f0f5" },
        { "name": "subtle lime", "color": "#D3F1A7" },
        { "name": "subtle pink", "color": "#fdd0ec" },
        { "name": "subtle black", "color": "#dcdfe4" },
        { "name": "blue", "color": "#579dff" },
        { "name": "sky", "color": "#60c6d2" },
        { "name": "lime", "color": "#94c748" },
        { "name": "pink", "color": "#e774bb" },
        { "name": "black", "color": "#8590a2" },
        { "name": "bold blue", "color": "#0c66e4" },
        { "name": "bold sky", "color": "#1d7f8c" },
        { "name": "bold lime", "color": "#5b7f24" },
        { "name": "bold pink", "color": "#ae4787" },
        { "name": "bold black", "color": "#626f86" }
      ],
      editorOptions: {
        modules: {
          toolbar: {
            container: [
              { "header": [1, 2, 3, 4, 5, 6, false] },
              "bold",
              "italic",
              "underline",
              { "list": "bullet" },
              { "list": "ordered" },
              "align",
              "clean",
              "blockquote",
              "code-block"
              // 'image'
            ]
            // handlers: { 'image': this.imageButtonClickHandler }
          }
          // imageDrop: true,
        }
      }
    };
  },
  components: {
    Icon,
    Loader,
    Link,
    Datepicker,
    QuillEditor,
    Head
  },
  computed: {
    filteredActivities() {
      return this.task.activities.filter((activity) => {
        if (activity.field_changed === "comment" || activity.field_changed === "comment_edit") {
          return activity.comment;
        }
        return [
          "title",
          "slug",
          "list_id",
          "order",
          "due_date",
          "is_done",
          "is_archive",
          "comment_delete",
          "description",
          "cover"
        ].includes(activity.field_changed);
      });
    }
  },
  methods: {
    addTime() {
      const task_date = this.moment(this.task.created_at).utc();
      this.manual_time.seconds = parseInt(this.moment.duration(this.moment(this.manual_time.end).diff(this.moment(this.manual_time.start))).asSeconds());
      if (!this.manual_time.start || !this.manual_time.end) {
        alert("Please input start and end time.");
        return;
      }
      if (this.moment(this.manual_time.end).isBefore(this.manual_time.start)) {
        alert("End time must be after the start time.");
        return;
      } else if (this.manual_time.seconds > 36e3) {
        alert("You can not add more than 10 hours at a time. You can split time with day and hours.");
        return;
      } else if (this.moment(this.manual_time.end).isAfter(this.moment())) {
        alert("End time can not after the current time.");
        return;
      } else if (this.moment(this.manual_time.start).isBefore(task_date)) {
        alert("Start date must be after date the task created.");
        return;
      }
      this.counter.duration = parseInt(this.counter.duration) + this.manual_time.seconds;
      this.showManualTimeOption = false;
      this.manual_time.task_id = this.task.id;
      axios.post(this.route("task.timer.manual"), this.manual_time);
    },
    updateManualStart() {
      this.manual_time.end = this.moment(this.manual_time.start).add(1, "hour").toDate();
    },
    openNewChecklist() {
      this.newCheckList = true;
      const ref = this.$refs.ncl;
      setTimeout(function() {
        ref.focus();
      }, 0);
    },
    async imageButtonClickHandler() {
      const input = document.createElement("input");
      input.setAttribute("type", "file");
      input.click();
      input.onchange = async () => {
        input.files[0];
        this.$refs.editDescription.focus();
      };
    },
    async get_average_rgb(src) {
      return new Promise((resolve, reject) => {
        const img = new Image();
        img.crossOrigin = "anonymous";
        img.src = src;
        img.onload = () => {
          const canvas = document.createElement("canvas");
          canvas.width = img.width;
          canvas.height = img.height;
          const ctx = canvas.getContext("2d");
          ctx.drawImage(img, 0, 0);
          const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
          const data = imageData.data;
          const colorCount = {};
          for (let i = 0; i < data.length; i += 4) {
            const r = data[i];
            const g = data[i + 1];
            const b = data[i + 2];
            const key = `${r},${g},${b}`;
            colorCount[key] = (colorCount[key] || 0) + 1;
          }
          const dominantColor = Object.entries(colorCount).sort((a, b) => b[1] - a[1])[0][0];
          resolve(`rgb(${dominantColor})`);
        };
        img.onerror = reject;
      });
    },
    async makeCover(task2, attachment) {
      task2.cover = attachment;
      await this.saveTask({ cover: attachment.id });
      this.$refs.t__cover.style.backgroundColor = await this.get_average_rgb(task2.cover.path);
    },
    removeCover(task2) {
      this.saveTask({ cover: null });
      task2.cover = null;
    },
    toggleDetails() {
      this.editDescription = true;
    },
    onEditorReady(editor) {
      editor.focus();
    },
    deleteAttachment(id, index) {
      if (this.task.cover && this.task.cover.id === id) {
        this.task.cover = null;
      }
      axios.post(this.route("task.attachment.delete", id), {}).then((response) => {
        if (response.data) {
          this.task.attachments.splice(index, 1);
        }
      });
    },
    async uploadAttachment(e, is_comment) {
      e.preventDefault();
      if (!e.target.files.length) {
        return;
      }
      const file = e.target.files[0];
      if (this.task.is_demo && file.size / 1024 / 1024 > 2) {
        alert("Uploading is limited to 2MB in demo mode. Please choose a file smaller than 2MB.");
        return;
      }
      const obj = await this.uploadFile(file);
      if (obj && obj.error) {
        alert(obj == null ? void 0 : obj.message);
      } else {
        this.task.attachments.push(obj);
        if (is_comment) {
          const name = ["jpeg", "png", "gif", "jpg", "svg", "webp", "bmp"].includes(obj.name.split(".").pop()) ? `<img src="${obj.path}" alt="${obj.name}" />` : `${obj.name}`;
          const link = `<br/><a href="${obj.path}" target="_blank">${name}</a><br/>`;
          this.new_comment.details = this.new_comment.details || "" + link;
        }
      }
    },
    async uploadFile(file) {
      let formData = new FormData();
      formData.append("file", file);
      const resp = await axios.post(this.route("task.attachment.add", this.task.id), formData, {
        headers: {
          "Content-Type": "multipart/form-data"
        }
      });
      return resp.data;
    },
    goToLink(link) {
      window.location.href = link;
    },
    startTimer(start_now) {
      let started = this.counter.timer.started_at ? this.moment.utc(this.counter.timer.started_at) : this.moment();
      let seconds = parseInt(this.moment.duration(this.moment().diff(started)).asSeconds());
      seconds = this.counter.timer.duration + seconds;
      this.counter.ticker = setInterval(() => {
        this.counter.seconds = ++seconds;
        this.activeTimerString = this.moment.utc(moment.duration(this.counter.seconds + parseInt(this.counter.duration), "seconds").as("milliseconds")).format("H[h] m[m] s[s]");
      }, 1e3);
      if (start_now) {
        this.eTimer(this.counter);
      }
    },
    eTimer(counter, stopped) {
      this.$page.props.counter = counter;
      this.$page.props.tracker = { started: true };
      if (stopped) {
        this.$page.props.tracker.started = false;
      }
    },
    startTracker() {
      axios.post(this.route("task.timer.start"), { task_id: this.task.id }).then((response) => {
        if (response.data) {
          this.counter.timer = response.data;
          this.startTimer(true);
        }
      });
    },
    stopTracker() {
      axios.post(this.route("task.timer.stop"), { duration: this.counter.seconds, id: this.counter.timer.id, task_id: this.task.id }).then((response) => {
        if (response.data) {
          this.stopTimer();
          this.counter.duration = response.data;
        }
      });
    },
    stopTimer() {
      clearInterval(this.counter.ticker);
      this.activeTimerString = "";
      this.eTimer(this.counter, true);
    },
    totalTime() {
      if (this.activeTimerString) {
        return this.activeTimerString;
      } else if (this.counter.duration) {
        return this.moment.utc(moment.duration(this.counter.duration, "seconds").as("milliseconds")).format("H[h] m[m] s[s]");
      }
      return "0:00:00";
    },
    calculateTimeSpent(timer) {
      if (timer.stopped_at) {
        const started = this.moment(timer.started_at);
        const stopped = this.moment(timer.stopped_at);
        return this.moment.duration(stopped.diff(started)).format();
      }
      return "";
    },
    async moveTask() {
      const project_id = this.move_object.project_id;
      const taskObject = { previous_list: this.task.list_id, new_list: this.move_object.list_id, from: this.task.order, to: this.move_object.order, task_id: this.task.id };
      if (taskObject.previous_list !== taskObject.new_list) {
        taskObject.is_move = true;
        await this.saveTask({ list_id: taskObject.new_list });
      }
      if (this.task.project_id !== project_id) {
        await this.saveTask({ project_id });
      }
      await this.saveList(project_id, taskObject);
      Object.assign(this.task, { project_id, order: taskObject.to, list_id: taskObject.new_list });
      this.task.project = this.getSelectedProject();
      this.task.list = this.getSelectedList();
      this.showMoveCard = false;
      this.is_move = false;
    },
    saveList(project_id, taskObject) {
      axios.post(this.route("task.update.list", project_id), taskObject).catch((error) => {
        console.log(error);
      });
    },
    getSelectedList() {
      let listItem = this.list_items.filter((l) => {
        return l.id === this.move_object.list_id && l.project_id === this.move_object.project_id;
      });
      if (!listItem.length) {
        listItem = this.list_items.filter((l) => l.project_id === this.move_object.project_id);
        this.move_object.list_id = listItem[0].id;
      }
      return listItem[0];
    },
    getSelectedProjectLists() {
      return this.list_items.filter((l) => l.project_id === this.move_object.project_id);
    },
    getSelectedListPostions() {
      return this.getSelectedList().id === this.task.list_id ? parseInt(this.getSelectedList().tasks_count, 10) : parseInt(this.getSelectedList().tasks_count, 10) + 1;
    },
    getSelectedProject() {
      return this.projects.filter((p) => p.id === this.move_object.project_id)[0];
    },
    displayMoveCard() {
      this.move_object.project_id = this.task.project.id;
      this.move_object.list_id = this.task.list.id;
      this.move_object.order = this.task.order;
      this.showMoveCard = true;
    },
    searchLabel(input) {
      return this.labels.filter((lab) => lab.name.toLowerCase().indexOf(input) > -1);
    },
    searchUser(input) {
      return this.team_members.filter((tm) => tm.user.name.toLowerCase().indexOf(input) > -1);
    },
    deleteLabel(id) {
      axios.post(this.route("labels.delete", id)).catch((error) => {
        console.log(error);
      });
      const findIndex = this.labels.findIndex((l) => l.id === id);
      this.labels.splice(findIndex, 1);
      const tlIndex = this.task.task_labels.findIndex((tl) => tl.label_id === id);
      if (tlIndex > -1) {
        this.task.task_labels.splice(tlIndex, 1);
      }
      this.label = {};
    },
    saveLabel(labelObject) {
      labelObject.project_id = this.task.project_id;
      axios.post(this.route("labels.save"), labelObject).then((response) => {
        if (response.data && !labelObject.id) {
          this.labels.push(response.data);
        } else if (labelObject.id) {
          const findIndex = this.labels.findIndex((l) => l.id === labelObject.id);
          const tlIndex = this.task.task_labels.findIndex((tl) => tl.label_id === labelObject.id);
          this.labels[findIndex] = labelObject;
          if (tlIndex > -1) {
            this.task.task_labels[tlIndex]["label"] = labelObject;
          }
        }
        this.showEditLabelBox = false;
        this.showLabelBox = true;
      }).catch((error) => {
        console.log(error);
      });
      this.label = {};
    },
    addLabelToTask(checked, id) {
      axios.post(this.route("task.labels.add"), { task_id: this.task.id, label_id: id }).then((response) => {
        if (response.data) {
          if (checked) {
            this.task.task_labels.push(response.data);
          } else {
            const findIndex = this.task.task_labels.findIndex((tl) => tl.label_id === id);
            if (findIndex > -1) {
              this.task.task_labels.splice(findIndex, 1);
            }
          }
        }
      }).catch((error) => {
        console.log(error);
      });
    },
    assignUserToTask(checked, id) {
      axios.post(this.route("task.assignees.add"), { task_id: this.task.id, user_id: id }).then((response) => {
        if (response.data) {
          if (checked) {
            this.task.assignees.push(response.data);
            if (response.data.id && response.data.user && response.data.user.id) {
              this.sendNotification("send.mail.task_user_added", response.data.id, response.data.user.id);
            }
          } else {
            const findIndex = this.task.assignees.findIndex((a) => Number(a.user_id) === Number(id));
            if (findIndex > -1) {
              this.task.assignees.splice(findIndex, 1);
            }
          }
        }
      }).catch((error) => {
        console.log(error);
      });
    },
    task_label_ids() {
      return this.task.task_labels.map((item) => item.label_id);
    },
    task_assignees() {
      return this.task.assignees.map((item) => Number(item.user_id));
    },
    saveDetails() {
      if (this.task.description) {
        const desc = this.task.description;
        this.saveTask({ description: desc });
      }
    },
    async deleteTask() {
      await axios.post(this.route("task.delete", this.task.id), {});
      this.goToLink(this.route(this.view === "table" ? "projects.view.table" : "projects.view.board", this.task.project_id));
    },
    saveTask(taskObject) {
      axios.post(this.route("task.update", this.task.id), taskObject).then((response) => {
        if (response.data) {
          this.sendNotification("send.mail.task_update", response.data.id);
        }
      });
    },
    checklistDoneCount(checkList) {
      return checkList.filter((item) => !!item.is_done).length;
    },
    modifyCheck(check_list) {
      check_list.modify = true;
      setTimeout(() => {
        document.getElementById("modify_" + check_list.id).focus();
      }, 10);
    },
    deleteCheckList(id, index, checkLists) {
      axios.post(this.route("check_list.delete", id)).catch((error) => {
        console.log(error);
      });
      checkLists.splice(index, 1);
    },
    deleteComment(id, comments, activity_id) {
      axios.post(this.route("comment.delete", id)).then((response) => {
        if (response.data) {
          comments.unshift(response.data);
          const findIndex = this.task.activities.findIndex((activity) => activity.id === activity_id);
          if (findIndex !== -1) {
            this.task.activities.splice(findIndex, 1);
          }
        }
      }).catch((error) => {
        console.log(error);
      });
    },
    modifyCheckListSubmit(check_list, c_index, checklist) {
      if (!check_list.title) {
        this.deleteCheckList(check_list.id, c_index, checklist);
      } else {
        this.saveCheckList(check_list.id, { title: check_list.title });
      }
      check_list.modify = false;
    },
    inputNewChecklistAction(check_list, e) {
      if (e && e.keyCode === 13 || !e) {
        if (!check_list.title) {
          this.newCheckList = false;
        } else {
          this.saveNewCheckList({ title: check_list.title, task_id: this.task.id }, this.task.checklists);
          this.openNewChecklist();
        }
      }
    },
    saveCheckList(id, checkListObject) {
      axios.post(this.route("check_list.update", id), checkListObject).catch((error) => {
        console.log(error);
      });
    },
    saveComment(id, commentObject) {
      commentObject.updated_at = this.moment().format("YYYY-MM-DD HH:mm:ss");
      axios.post(this.route("comment.update", id), { details: commentObject.details, updated_at: commentObject.updated_at }).catch((error) => {
        console.log(error);
      });
    },
    saveNewCheckList(checkListObject, currentCheckList) {
      this.new_chek_list.title = "";
      axios.post(this.route("check_list.new"), checkListObject).then((response) => {
        if (response.data) {
          currentCheckList.push(response.data);
        }
      }).catch((error) => {
        console.log(error);
      });
    },
    saveNewComment(commentObject, currentComments) {
      this.new_comment.details = "";
      commentObject.created_at = this.moment().format("YYYY-MM-DD HH:mm:ss");
      axios.post(this.route("comments.new"), commentObject).then((response) => {
        if (response.data) {
          this.showCommentBox = false;
          this.sendNotification("send.mail.comment", response.data.comment_id);
          currentComments.unshift(response.data);
        }
      }).catch((error) => {
        console.log(error);
      });
    },
    sendNotification(uri, id, user_id) {
      const data = { id };
      if (!!user_id) {
        data.user_id = user_id;
      }
      axios.post(this.route(uri, data)).catch((error) => {
        console.log(error);
      });
    },
    async getTask(id) {
      var _a, _b;
      try {
        const taskResponse = await axios.get(this.route("json.task.get", id));
        if (taskResponse.data && Object.keys(taskResponse.data).length) {
          this.task = taskResponse.data;
          this.counter.timer = this.task.timer || null;
          if (((_a = this.counter.timer) == null ? void 0 : _a.task_id) === ((_b = this.task) == null ? void 0 : _b.id)) {
            this.startTimer();
          }
          await this.getOtherData();
        } else {
          alert("Something went wrong");
        }
      } catch (error) {
        console.error("Error fetching task:", error);
        alert("Failed to fetch task data");
      } finally {
        this.loading = false;
      }
    },
    saveTitle(e) {
      if (e.keyCode === 13 || e.type === "blur") {
        e.preventDefault();
        e.target.blur();
        if (e.target.innerText) {
          const title = e.target.innerText;
          axios.post(this.route("task.update", this.task.id), { title }).then((response) => {
            if (response.data) {
              this.sendNotification("send.mail.task_update", response.data.id);
            }
          });
        }
      }
    },
    async getOtherData() {
      const dataResponse = await axios.get(this.route("task.other.data", { task_id: this.task.id, project_id: this.task.project_id }));
      const res = dataResponse.data;
      this.labels = res.labels || [];
      this.list_items = res.lists || [];
      this.projects = res.projects || [];
      this.team_members = res.team_members || [];
      this.existing_timer = res.timer || null;
      this.counter.duration = res.duration || 0;
      this.move_object.order = this.task.order;
      setTimeout(async () => {
        if (this.task.cover && this.$refs.t__cover) {
          this.$refs.t__cover.style.backgroundColor = await this.get_average_rgb(this.task.cover.path);
        }
      });
    }
  },
  created() {
    this.moment = moment;
    this.getTask(this.id);
  },
  mounted() {
    let self = this;
    window.addEventListener("keyup", function(ev) {
      if (ev.key === "Escape") {
        if (self.isPopup) {
          self.$emit("closeModal", true);
        } else {
          self.goToLink(self.route(self.view === "table" ? "projects.view.table" : "projects.view.board", task.project.slug || task.project.id));
        }
      }
    });
  },
  name: "task-details"
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  var _a, _b;
  const _component_Head = resolveComponent("Head");
  const _component_icon = resolveComponent("icon");
  const _component_quill_editor = resolveComponent("quill-editor");
  const _component_Datepicker = resolveComponent("Datepicker");
  _push(`<!--[-->`);
  if (!$data.loading) {
    _push(ssrRenderComponent(_component_Head, {
      title: _ctx.$t($data.task.title + " | " + $data.task.project.title)
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`<div class="task__details"><div class="wrapper" id="modal"><div role="alert" class="container">`);
  if ($data.loading) {
    _push(`<div class="content"><div role="status" class="td__loader"><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div><div class="i__r"></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div><div class="i__r"></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div><div class="i__r"></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div><div class="i__r"></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div><div class="i__r"></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div><div class="i__r"></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div></div><div class="__f"><div><div class="i__1"></div><div class="i__2"></div></div></div><span class="sr-only">Loading...</span></div></div>`);
  } else {
    _push(`<div class="content w-full">`);
    if ($data.task.cover) {
      _push(`<div class="t__cover" style="${ssrRenderStyle({ backgroundImage: "url(" + $data.task.cover.path + ")" })}"></div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.task.is_archive) {
      _push(`<div class="archive___task">`);
      _push(ssrRenderComponent(_component_icon, { name: "archive" }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("This task is archived."))}</div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`<div class="close_area"><div class="wrap">`);
    if ($props.isPopup) {
      _push(`<span class="close__b">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "h-6 w-6",
        name: "close"
      }, null, _parent));
      _push(`</span>`);
    } else {
      _push(`<button class="close__b">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "h-6 w-6",
        name: "close"
      }, null, _parent));
      _push(`</button>`);
    }
    _push(`</div></div>`);
    if ($data.showMoveCard) {
      _push(`<div class="${ssrRenderClass([{ "!left-auto right-6 top-23": $data.is_move }, "mv__card"])}"><h4 class="text-center mb-3 font-bold">${ssrInterpolate(_ctx.$t("Move Card"))}</h4><div class="close__b absolute cursor-pointer hover:bg-gray-200 top-3 right-3 p-1.5 rounded">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "close"
      }, null, _parent));
      _push(`</div><span class="title mt-4 mb-1 font-bold">${ssrInterpolate(_ctx.$t("Select a destination"))}</span><div class="td__btn relative flex flex-col rounded bg-gray-100 mb-3 px-3 py-2.5"><span class="mb-1">${ssrInterpolate(_ctx.$t("Project"))}</span><span class="text-[14px] font-bold">${ssrInterpolate($options.getSelectedProject().title)}</span><select class="absolute left-0 top-0 opacity-0 w-full cursor-pointer h-[50px] z-2"><!--[-->`);
      ssrRenderList(this.projects, (project) => {
        _push(`<option${ssrRenderAttr("value", project.id)}>${ssrInterpolate(project.title)}</option>`);
      });
      _push(`<!--]--></select></div><div class="flex gap-2"><div class="td__btn relative flex flex-col w-[70%] rounded bg-gray-100 px-3 py-2.5"><span class="mb-1">${ssrInterpolate(_ctx.$t("List"))}</span><span class="text-[14px] font-bold">${ssrInterpolate($options.getSelectedList().title)}</span><select class="absolute left-0 top-0 opacity-0 w-full cursor-pointer h-[50px] z-2"><!--[-->`);
      ssrRenderList($options.getSelectedProjectLists(), (list_item) => {
        _push(`<option${ssrRenderAttr("value", list_item.id)}>${ssrInterpolate(list_item.title)}</option>`);
      });
      _push(`<!--]--></select></div><div class="td__btn relative flex flex-col w-[30%] rounded bg-gray-100 px-3 py-2.5"><span class="mb-1">${ssrInterpolate(_ctx.$t("Position"))}</span><span class="text-[14px] font-bold">${ssrInterpolate($data.move_object.order)}</span><select class="absolute left-0 top-0 opacity-0 w-full cursor-pointer h-[50px] z-2"><!--[-->`);
      ssrRenderList([...Array($options.getSelectedListPostions()).keys()].map((x) => ++x), (list_item) => {
        _push(`<option${ssrRenderAttr("value", list_item)}>${ssrInterpolate(list_item)}</option>`);
      });
      _push(`<!--]--></select></div></div><div class="flex justify-between items-center action__buttons mt-3"><button type="button" class="small save">${ssrInterpolate(_ctx.$t("Move"))}</button></div></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`<div class="m__body w-full"><main class="main"><div class="s__1"><div class="checklist-box"><input type="checkbox"${ssrIncludeBooleanAttr(!!$data.task.is_done) ? " checked" : ""}>`);
    _push(ssrRenderComponent(_component_icon, { name: "checklist_box" }, null, _parent));
    _push(`</div><div class="t__l"><h2 class="__t" contenteditable="true">${ssrInterpolate($data.task.title)}</h2><span class="text-xs">in list <span class="cursor-pointer underline">${ssrInterpolate($data.task.list.title)}</span></span><div class="flex flex-col mt-5"><span class="text-xs font-bold mb-1">${ssrInterpolate(_ctx.$t("Labels"))}</span><div class="list_labels flex flex-wrap gap-1"><!--[-->`);
    ssrRenderList($data.task.task_labels, (task_label, label_index) => {
      _push(`<button class="label_button" style="${ssrRenderStyle({ background: task_label.label.color })}"${ssrRenderAttr("aria-label", task_label.label.name)} data-a="">${ssrInterpolate(task_label.label.name)}</button>`);
    });
    _push(`<!--]--><button class="label_button bg-gray-200 hover:bg-gray-300">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "",
      name: "plus"
    }, null, _parent));
    _push(`</button></div></div></div></div>`);
    if ($data.showLabelBox) {
      _push(`<div class="absolute flex w-[300px] z-10 text-sm flex-col bg-white px-4 py-4 rounded shadow"><h4 class="text-center mb-3 font-bold">${ssrInterpolate(_ctx.$t("Labels"))}</h4><div class="absolute cursor-pointer hover:bg-gray-200 top-3 right-3 p-1.5 rounded">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "close"
      }, null, _parent));
      _push(`</div><input${ssrRenderAttr("value", $data.label_search)} class="border-[2px] px-2 py-1 border-gray-400 rounded-[3px]"${ssrRenderAttr("placeholder", _ctx.$t("Search labels"))}><ul class="flex flex-col mt-3 gap-3 max-h-[200px] overflow-y-auto"><!--[-->`);
      ssrRenderList($options.searchLabel($data.label_search), (lab, lab_index) => {
        _push(`<li><label class="flex gap-1"><input class="w-5 mr-2 cursor-pointer" type="checkbox"${ssrIncludeBooleanAttr($options.task_label_ids().includes(lab.id)) ? " checked" : ""}><span class="w-full px-3 py-2 rounded cursor-pointer hover:opacity-80" style="${ssrRenderStyle({ background: lab.color })}"${ssrRenderAttr("tabindex", lab_index)}${ssrRenderAttr("aria-label", lab.name)} data-color="orange">${ssrInterpolate(lab.name)}</span><button class="p-3 hover:bg-gray-200 rounded" type="button"${ssrRenderAttr("tabindex", lab_index)}>`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-3 h-3",
          name: "edit"
        }, null, _parent));
        _push(`</button></label></li>`);
      });
      _push(`<!--]--></ul><button class="w-full mt-4 px-3 py-2 rounded cursor-pointer bg-gray-300 hover:opacity-80">${ssrInterpolate(_ctx.$t("Create a new label"))}</button></div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.showEditLabelBox) {
      _push(`<div class="absolute flex w-[300px] z-10 text-sm flex-col bg-white px-4 py-4 rounded shadow"><div class="absolute cursor-pointer hover:bg-gray-200 top-3 left-3 p-1.5 rounded">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "arrow-left"
      }, null, _parent));
      _push(`</div><h4 class="text-center mb-3 font-bold">${ssrInterpolate(_ctx.$t("Edit Labels"))}</h4><div class="absolute cursor-pointer hover:bg-gray-200 top-3 right-3 p-1.5 rounded">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "close"
      }, null, _parent));
      _push(`</div><span class="w-full px-3 py-2 rounded cursor-pointer bg-gray-100 hover:opacity-80" style="${ssrRenderStyle({ background: $data.label.color })}"${ssrRenderAttr("tabindex", 0)}${ssrRenderAttr("aria-label", $data.label.name)}>${ssrInterpolate($data.label.name)}</span><span class="title mt-4 font-bold mb-2">${ssrInterpolate(_ctx.$t("Title"))}</span><input class="border-[2px] px-2 py-1 border-gray-400 rounded-[3px]" placeholder=""${ssrRenderAttr("value", $data.label.name)}><span class="title mt-4 mb-1 font-bold">${ssrInterpolate(_ctx.$t("Select a color"))}</span><div class="color__wrapper grid gap-1 mb-2 max-h-[120px] overflow-hidden overflow-y-auto"><!--[-->`);
      ssrRenderList($data.colors, (color) => {
        _push(`<div class="h-8 box cursor-pointer"><div class="w-full h-full border-[2px] rounded border-transparent hover:border-red-600"${ssrRenderAttr("title", color.name)}${ssrRenderAttr("aria-label", color.name)} style="${ssrRenderStyle({ backgroundColor: color.color })}"></div></div>`);
      });
      _push(`<!--]--></div><div class="flex justify-between items-center action__buttons mt-2"><button type="button" class="small save">${ssrInterpolate(_ctx.$t("Save"))}</button>`);
      if ($data.label.id) {
        _push(`<button type="button" class="small cancel">${ssrInterpolate(_ctx.$t("Delete"))}</button>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`<section class="s__2"><div class="__details_top">`);
    _push(ssrRenderComponent(_component_icon, { name: "details" }, null, _parent));
    _push(`<div class="flex-1"><span class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Description"))}</span></div>`);
    _push(ssrRenderComponent(_component_icon, {
      onClick: ($event) => $options.toggleDetails(),
      class: "w-4 h-4 ml-auto cursor-pointer",
      name: "edit"
    }, null, _parent));
    _push(`</div><div class="__details">`);
    if (!$data.editDescription) {
      _push(`<div class="prose pt-4 text-sm cursor-pointer">${($data.task.description || "Add more details...") ?? ""}</div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.editDescription) {
      _push(`<section class="mt-4">`);
      _push(ssrRenderComponent(_component_quill_editor, {
        ref: "editDescription",
        onReady: $options.onEditorReady,
        class: "task__description",
        content: $data.task.description,
        "onUpdate:content": ($event) => $data.task.description = $event,
        options: $data.editorOptions,
        contentType: "html",
        theme: "snow"
      }, null, _parent));
      _push(`<div class="mt-2"><button type="button" class="inline-flex items-center rounded border border-gray-300 bg-indigo-600 text-white px-2.5 py-1.5 text-xs font-medium shadow-sm hover:bg-gray-50 hover:text-dark focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2">${ssrInterpolate(_ctx.$t("Save"))}</button><button type="button" class="inline-flex items-center rounded border border-transparent hover:border-gray-300 bg-white px-2.5 py-1.5 text-xs font-medium hover:bg-gray-50 hover:text-gray-900 focus:outline-none focus:ring-0 ltr:ml-1 rtl:mr-1">${ssrInterpolate(_ctx.$t("Cancel"))}</button></div></section>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></section><section class="mt-6" id="checklist"><div><div class="flex">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-5 h-5 mr-3",
      name: "checklist"
    }, null, _parent));
    _push(`<div class="flex-1 border-b pb-2"><span class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Checklist"))}</span><span class="ml-2 text-sm font-light">${ssrInterpolate($options.checklistDoneCount($data.task.checklists))}/${ssrInterpolate($data.task.checklists.length)}</span></div></div></div><div class="pl-8 pt-4"><div class="space-y-4"><!--[-->`);
    ssrRenderList($data.task.checklists, (check_list, c_index) => {
      _push(`<div class="group relative flex items-center">`);
      if (!check_list.modify) {
        _push(`<div class="checklist-box2"><input class="inp-cbx"${ssrRenderAttr("id", "cbx-" + check_list.id)}${ssrIncludeBooleanAttr(!!check_list.is_done) ? " checked" : ""} type="checkbox" style="${ssrRenderStyle({ "display": "none" })}"><label class="cbx"${ssrRenderAttr("for", "cbx-" + check_list.id)}><span>`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4",
          name: "checklist_box_2"
        }, null, _parent));
        _push(`</span><span class="text-sm">${ssrInterpolate(check_list.title)}</span></label></div>`);
      } else {
        _push(`<!---->`);
      }
      if (check_list.modify) {
        _push(`<div class="checklist-box2 pl-6 w-full"><input${ssrRenderAttr("id", "modify_" + check_list.id)} class="border rounded p-2 text-sm bg-white w-full"${ssrRenderAttr("value", check_list.title)}><div class="flex"><div class="flex items-center action__buttons mt-2"><button type="button" class="small save">${ssrInterpolate(_ctx.$t("Save"))}</button><button type="button" class="small cancel">${ssrInterpolate(_ctx.$t("Cancel"))}</button></div></div></div>`);
      } else {
        _push(`<!---->`);
      }
      if (!check_list.modify) {
        _push(`<div class="absolute right-0 hidden pl-4 group-hover:flex">`);
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4 mr-3 cursor-pointer",
          name: "edit",
          onClick: ($event) => $options.modifyCheck(check_list)
        }, null, _parent));
        _push(ssrRenderComponent(_component_icon, {
          class: "w-4 h-4 cursor-pointer",
          name: "trash",
          onClick: ($event) => $options.deleteCheckList(check_list.id, c_index, $data.task.checklists)
        }, null, _parent));
        _push(`</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`</div>`);
    });
    _push(`<!--]--><div style="${ssrRenderStyle($data.newCheckList ? null : { display: "none" })}" class="group relative flex"><div class="checklist-box2 pl-6 w-full"><input class="border rounded p-2 text-sm bg-white w-full"${ssrRenderAttr("value", $data.new_chek_list.title)}><div class="flex"><div class="flex items-center action__buttons mt-2"><button type="button" class="small save">${ssrInterpolate(_ctx.$t("Save"))}</button><button type="button" class="small cancel">${ssrInterpolate(_ctx.$t("Cancel"))}</button></div></div></div></div></div><button class="group flex items-center mt-6">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-5 h-5",
      name: "add"
    }, null, _parent));
    _push(`<span class="pl-2 text-sm group-hover:opacity-70">${ssrInterpolate(_ctx.$t("Add a new item"))}</span></button></div></section><section class="mt-8"><div><div class="flex">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4 mr-3 mt-1",
      name: "attachment"
    }, null, _parent));
    _push(`<div class="flex-1 border-b pb-2"><span class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Attachments"))}</span><span class="ml-2 text-sm font-light">${ssrInterpolate($data.task.attachments.length)}</span></div></div></div><div class="pl-8 pt-4"><div class="flex flex-col gap-2 text-sm"><!--[-->`);
    ssrRenderList($data.task.attachments, (attachment, a_index) => {
      _push(`<div class="__attachment flex gap-3 py-4 hover:bg-gray-100"><div class="preview flex-shrink-0"${ssrRenderAttr("aria-label", attachment.name)}>`);
      if (["jpeg", "png", "gif", "jpg", "svg", "webp", "bmp"].includes(attachment.name.split(".").pop())) {
        _push(`<div class="" style="${ssrRenderStyle({ "backgroundImage": `url(${attachment.path})` })}"${ssrRenderAttr("alt", attachment.name)}></div>`);
      } else {
        _push(`<div>${ssrInterpolate(attachment.name.split(".").pop())}</div>`);
      }
      _push(`</div><div class="flex flex-col gap-2 w-full"><div class="font-bold truncate max-w-full"><a${ssrRenderAttr("href", attachment.path)} target="_blank" class="block break-words truncate text-ellipsis max-w-[260px]">${ssrInterpolate(attachment.name)}</a></div><div class="flex gap-3"><span${ssrRenderAttr("aria-label", _ctx.moment(attachment.created_at).format("MMMM D, YYYY h:mm A"))}>${ssrInterpolate(_ctx.moment(attachment.created_at).format("[Added] MMM D, YYYY [at] h:mm A"))}</span> - <span class="flex underline cursor-pointer">${ssrInterpolate(_ctx.$t("Delete"))}</span></div><div class="flex gap-3">`);
      if (!$data.task.cover && ["jpeg", "png", "gif", "jpg", "svg", "webp", "bmp"].includes(attachment.name.split(".").pop())) {
        _push(`<div class="cover">`);
        _push(ssrRenderComponent(_component_icon, { name: "image" }, null, _parent));
        _push(` ${ssrInterpolate(_ctx.$t("Make Cover"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      if ($data.task.cover && $data.task.cover.id === attachment.id) {
        _push(`<div class="cover">`);
        _push(ssrRenderComponent(_component_icon, { name: "image" }, null, _parent));
        _push(` ${ssrInterpolate(_ctx.$t("Remove Cover"))}</div>`);
      } else {
        _push(`<!---->`);
      }
      _push(`<a class="cover"${ssrRenderAttr("href", attachment.path)} target="_blank">`);
      _push(ssrRenderComponent(_component_icon, { name: "link_external" }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Open"))}</a></div></div></div>`);
    });
    _push(`<!--]--></div></div></section><section class="mt-8"><div><div class="flex">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4 mr-3 mt-1",
      name: "comments"
    }, null, _parent));
    _push(`<div class="flex-1 border-b pb-2"><span class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Activities"))}</span><span class="ml-2 text-sm font-light">${ssrInterpolate($data.task.activities.length)}</span></div></div></div><div class="pl-8 pt-4"><div>`);
    if (!$data.showCommentBox) {
      _push(`<div class="mt-1 mb-4 cursor-pointer rounded-md border border-gray-300 hover:shadow"><p class="px-3 py-2 text-sm">${ssrInterpolate(_ctx.$t("Write a comment..."))}</p></div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.showCommentBox) {
      _push(`<form class="mt-1 mb-4 rounded-md border border-gray-300" enctype="multipart/form-data">`);
      _push(ssrRenderComponent(_component_quill_editor, {
        ref: "editDescription",
        onReady: $options.onEditorReady,
        class: "task__description",
        content: $data.new_comment.details,
        "onUpdate:content": ($event) => $data.new_comment.details = $event,
        options: $data.editorOptions,
        contentType: "html",
        theme: "snow"
      }, null, _parent));
      _push(`<div class="flex items-center px-3 pt-2 pb-3"><div class="flex items-center"><button type="button" class="inline-flex items-center rounded border border-gray-300 bg-indigo-600 text-white px-2.5 py-1.5 text-xs font-medium shadow-sm hover:bg-gray-50 hover:text-dark focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2">${ssrInterpolate(_ctx.$t("Save"))}</button><button type="button" class="inline-flex items-center rounded border border-transparent hover:border-gray-300 bg-white px-2.5 py-1.5 text-xs font-medium hover:bg-gray-50 hover:text-gray-900 focus:outline-none focus:ring-0 ltr:ml-1 rtl:mr-1">${ssrInterpolate(_ctx.$t("Cancel"))}</button></div><div class="ml-auto hidden flex"><label class="cursor-pointer"><input${ssrRenderAttr("accept", $data.allowed_file_types)} class="hidden" type="file">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "attachment"
      }, null, _parent));
      _push(`</label></div></div></form>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div><div class="space-y-4">`);
    if (((_b = (_a = $data.task) == null ? void 0 : _a.activities) == null ? void 0 : _b.length) === 0) {
      _push(`<div class="text-gray-500 text-sm">No activities yet.</div>`);
    } else {
      _push(`<ul class="divide-y divide-gray-200"><!--[-->`);
      ssrRenderList($options.filteredActivities, (activity) => {
        var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j;
        _push(`<li class="py-2">`);
        if (["comment", "comment_edit"].includes(activity.field_changed) && activity.comment) {
          _push(`<div class="comment__ group relative flex py-1"><div class="h-6 w-6"><span class="block rounded-full h-6 w-6">`);
          if ((_a2 = activity.user) == null ? void 0 : _a2.photo_path) {
            _push(`<img class="h-full w-full rounded-full"${ssrRenderAttr("src", activity.user.photo_path)} alt="User Photo">`);
          } else {
            _push(`<img class="h-full w-full rounded-full" src="/images/user.svg" alt="Default Avatar">`);
          }
          _push(`</span></div><div class="group flex-1 ltr:pl-4 rtl:pr-4 w-full"><div class="flex">`);
          if (activity.user) {
            _push(`<h2 class="flex text-sm font-medium leading-none">${ssrInterpolate(((_b2 = activity.user) == null ? void 0 : _b2.first_name) + " " + ((_c = activity.user) == null ? void 0 : _c.last_name))}</h2>`);
          } else {
            _push(`<!---->`);
          }
          _push(`<span class="text-xs font-normal text-gray-500 ltr:ml-3 rtl:mr-3">${ssrInterpolate(_ctx.moment((_d = activity.comment) == null ? void 0 : _d.created_at).format("MMMM D, YYYY [at] h:mm a"))} `);
          if (_ctx.moment((_e = activity.comment) == null ? void 0 : _e.updated_at).isAfter(_ctx.moment((_f = activity.comment) == null ? void 0 : _f.created_at))) {
            _push(`<small>(edited)</small>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</span><div class="ml-auto">`);
          if (_ctx.$page.props.auth.user.id === ((_g = activity.user) == null ? void 0 : _g.id)) {
            _push(`<div class="absolute right-0 hidden pl-4 group-hover:flex">`);
            _push(ssrRenderComponent(_component_icon, {
              class: "w-3 h-3 mr-3 cursor-pointer",
              name: "edit",
              onClick: ($event) => activity.comment.modify = true
            }, null, _parent));
            _push(ssrRenderComponent(_component_icon, {
              class: "w-3 h-3 cursor-pointer",
              name: "trash",
              onClick: ($event) => $options.deleteComment(activity.comment.id, $data.task.activities, activity.id)
            }, null, _parent));
            _push(`</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
          if (activity.comment.modify) {
            _push(`<div class="checklist-box2 pt-3 w-full">`);
            _push(ssrRenderComponent(_component_quill_editor, {
              ref_for: true,
              ref: "editComment",
              onReady: $options.onEditorReady,
              class: "task__description",
              content: activity.comment.details,
              "onUpdate:content": ($event) => activity.comment.details = $event,
              options: $data.editorOptions,
              contentType: "html",
              theme: "snow"
            }, null, _parent));
            _push(`<div class="flex items-center action__buttons mt-2"><button type="button" class="small save">${ssrInterpolate(_ctx.$t("Save"))}</button><button type="button" class="small cancel">${ssrInterpolate(_ctx.$t("Cancel"))}</button></div></div>`);
          } else {
            _push(`<!---->`);
          }
          if (!activity.comment.modify) {
            _push(`<div class="prose text-sm pt-1 t_a_h">${activity.comment.details ?? ""}</div>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</div></div>`);
        } else {
          _push(`<!---->`);
        }
        if (["title", "slug", "list_id", "order", "due_date", "is_done", "is_archive", "comment_delete", "description", "cover"].includes(activity.field_changed)) {
          _push(`<div class="flex items-center space-x-3">`);
          if ((_h = activity.user) == null ? void 0 : _h.photo_path) {
            _push(`<img${ssrRenderAttr("src", activity.user.photo_path)} alt="User Avatar" class="w-8 h-8 rounded-full">`);
          } else {
            _push(`<!---->`);
          }
          _push(`<div><p class="text-sm text-gray-700"><strong class="pr-1">${ssrInterpolate((_i = activity.user) == null ? void 0 : _i.first_name)} ${ssrInterpolate((_j = activity.user) == null ? void 0 : _j.last_name)}</strong>`);
          if (["title", "slug", "list_id", "order", "due_date"].includes(activity.field_changed)) {
            _push(`<span>${ssrInterpolate(activity.old_value)} → ${ssrInterpolate(activity.new_value)}</span>`);
          } else {
            _push(`<!---->`);
          }
          if (["is_done", "is_archive"].includes(activity.field_changed)) {
            _push(`<span>${ssrInterpolate(activity.old_value)}. </span>`);
          } else {
            _push(`<!---->`);
          }
          if (activity.field_changed === "description") {
            _push(`<span> updated the description.</span>`);
          } else {
            _push(`<!---->`);
          }
          if (activity.field_changed === "cover") {
            _push(`<span> updated the cover image.</span>`);
          } else {
            _push(`<!---->`);
          }
          if (activity.field_changed === "comment_delete") {
            _push(`<span> deleted a comment.</span>`);
          } else {
            _push(`<!---->`);
          }
          _push(`</p><p class="text-xs pt-1 text-gray-500">${ssrInterpolate(_ctx.moment(activity.created_at).format("MMMM D, YYYY [at] h:mm a"))}</p></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</li>`);
      });
      _push(`<!--]--></ul>`);
    }
    _push(`</div></div></section></main><aside class="w-60 divide-y divide-gray-200 px-6 py-6"><section class="py-3"><h2 class="px-2 text-sm font-medium">${ssrInterpolate(_ctx.$t("Move Task"))}</h2><div class="relative"><div><div class="group mt-2 flex cursor-pointer items-center td__btn rounded-md px-2 py-1.5 bg-gray-200 dark:bg-white hover:bg-gray-300"><span class="block h-3.5 text-xs leading-none">${ssrInterpolate($data.task.list.title)}</span>`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-3.5 h-3.5 ml-auto cursor-pointer",
      name: "arrow-down"
    }, null, _parent));
    _push(`</div></div></div></section><section class="py-3.5"><div class="flex items-center px-2"><h2 class="text-sm font-medium">${ssrInterpolate(_ctx.$t("Assignees"))}</h2><div class="relative ml-auto" modal="true" name="task-assign"><div><span class="cursor-pointer">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "h-5 w-5 hover:opacity-80",
      name: "add"
    }, null, _parent));
    _push(`</span></div>`);
    if ($data.showAssigneeBox) {
      _push(`<div class="absolute right-1 flex w-[300px] z-10 text-sm flex-col bg-white px-4 py-4 rounded shadow"><h4 class="text-center mb-3 font-bold">${ssrInterpolate(_ctx.$t("Assignee"))}</h4><div class="absolute cursor-pointer hover:bg-gray-200 top-3 right-3 p-1.5 rounded">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "close"
      }, null, _parent));
      _push(`</div><input id="t_d_s_u"${ssrRenderAttr("value", $data.user_search)} class="border-[2px] px-2 py-1 border-gray-400 rounded-[3px]"${ssrRenderAttr("placeholder", _ctx.$t("Search User"))}><ul class="flex flex-col mt-3 gap-1 h-48 max-h-48 overflow-y-auto"><!--[-->`);
      ssrRenderList($options.searchUser($data.user_search), (userObject, user_index) => {
        _push(`<li><label${ssrRenderAttr("for", "td_u_id_" + user_index)} class="flex p-2 cursor-pointer hover:bg-gray-200 rounded"><input${ssrRenderAttr("id", "td_u_id_" + user_index)} class="w-5 ml-1 mr-2" type="checkbox"${ssrIncludeBooleanAttr($options.task_assignees().includes(userObject.user_id)) ? " checked" : ""}>`);
        if (userObject.user.photo_path) {
          _push(`<img${ssrRenderAttr("aria-label", userObject.user.name)}${ssrRenderAttr("alt", userObject.user.name)} class="w-6 h-6 rounded-full"${ssrRenderAttr("src", userObject.user.photo_path)}>`);
        } else {
          _push(`<img${ssrRenderAttr("aria-label", userObject.user.name)}${ssrRenderAttr("alt", userObject.user.name)} class="w-6 h-6 rounded-full" src="/images/user.svg">`);
        }
        _push(`<span data-a="" class="p-1" type="button"${ssrRenderAttr("tabindex", user_index)}>${ssrInterpolate(userObject.user.name)}</span></label></li>`);
      });
      _push(`<!--]--></ul></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></div><div class="flex flex-wrap gap-1 px-2 mb-1 pt-2"><!--[-->`);
    ssrRenderList($data.task.assignees, (assignee) => {
      _push(`<span${ssrRenderAttr("aria-label", assignee.user.name)} data-a="" class="block rounded-full h-8 w-8 border-2 border-white">`);
      if (assignee.user.photo_path) {
        _push(`<img class="h-full w-full rounded-full"${ssrRenderAttr("src", assignee.user.photo_path)}${ssrRenderAttr("alt", assignee.user.name)}>`);
      } else {
        _push(`<img class="h-full w-full rounded-full" src="/images/user.svg"${ssrRenderAttr("alt", assignee.user.name)}>`);
      }
      _push(`</span>`);
    });
    _push(`<!--]--></div></section><section class="py-4"><div class="flex px-2 text-sm font-medium justify-between">${ssrInterpolate(_ctx.$t("Time Count"))} `);
    if (!this.activeTimerString && $options.task_assignees().includes(_ctx.$page.props.auth.user.id)) {
      _push(`<span class="cursor-pointer items-center flex">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "h-4 w-4 hover:opacity-80",
        name: "add"
      }, null, _parent));
      _push(` <span class="text-xs">Manual</span></span>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
    if ($data.showManualTimeOption) {
      _push(`<div class="fixed flex w-[380px] z-10 text-sm flex-col bg-white px-4 py-4 rounded shadow"><h4 class="text-center mb-3 font-bold">${ssrInterpolate(_ctx.$t("Add time manually"))}</h4><div class="absolute cursor-pointer hover:bg-gray-200 top-3 right-3 p-1.5 rounded">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "close"
      }, null, _parent));
      _push(`</div><div class="flex w-full flex-col mb-2"><label for="website-admin" class="block mb-1 text-sm font-medium text-gray-900 dark:text-white">Memo</label><input${ssrRenderAttr("value", $data.manual_time.title)} placeholder="add time log..." class="rounded bg-gray-50 border border-gray-300 text-gray-900 block flex-1 min-w-0 w-full text-sm p-1"></div><div class="flex gap-2"><div class="max-w-sm mx-auto"><label for="website-admin" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">From (start time)</label><div class="flex">`);
      _push(ssrRenderComponent(_component_Datepicker, {
        class: "rounded bg-gray-50 border border-gray-300 text-gray-900 block flex-1 min-w-0 w-full text-sm p-1",
        modelValue: $data.manual_time.start,
        "onUpdate:modelValue": [($event) => $data.manual_time.start = $event, ($event) => $options.updateManualStart()],
        placeholder: "Select Time",
        "is-24": false,
        "time-picker-inline": ""
      }, null, _parent));
      _push(`</div></div><div class="max-w-sm mx-auto"><label for="website-admin" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">To (end time)</label><div class="flex">`);
      _push(ssrRenderComponent(_component_Datepicker, {
        class: "rounded bg-gray-50 border border-gray-300 text-gray-900 block flex-1 min-w-0 w-full text-sm p-1",
        modelValue: $data.manual_time.end,
        "onUpdate:modelValue": ($event) => $data.manual_time.end = $event,
        placeholder: "Select Time",
        "is-24": false,
        "time-picker-inline": ""
      }, null, _parent));
      _push(`</div></div></div><button class="w-full mt-4 px-3 py-2 rounded cursor-pointer bg-gray-300 hover:opacity-80">${ssrInterpolate(_ctx.$t("Add Time"))}</button></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`<div class="mt-3 flex justify-between items-center px-2"><div class="flex gap-1 items-center"><p class="">${ssrInterpolate($options.totalTime())}</p></div>`);
    if (!!this.activeTimerString && $options.task_assignees().includes(Number(_ctx.$page.props.auth.user.id))) {
      _push(`<button class="py-2 w-[70px] bg-red-600 hover:bg-red-700 rounded text-[12px] text-white select-none">${ssrInterpolate(_ctx.$t("STOP"))}</button>`);
    } else if (!$data.existing_timer && $options.task_assignees().includes(Number(_ctx.$page.props.auth.user.id))) {
      _push(`<button class="py-2 w-[70px] bg-indigo-600 hover:bg-indigo-800 rounded text-[12px] text-white select-none">${ssrInterpolate(_ctx.$t("START"))}</button>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></section><section class="py-3"><h2 class="px-2 text-sm font-medium">${ssrInterpolate(_ctx.$t("Due Date"))}</h2><div class="relative" modal="true"><div><div class="group mt-2 flex cursor-pointer items-center rounded-md px-2 py-1.5">`);
    _push(ssrRenderComponent(_component_Datepicker, {
      modelValue: $data.task.due_date,
      "onUpdate:modelValue": [($event) => $data.task.due_date = $event, ($event) => $options.saveTask({ due_date: _ctx.moment($data.task.due_date).format("YYYY-MM-DD HH:mm") })],
      placeholder: "Select Date",
      "is-24": false
    }, null, _parent));
    _push(`</div></div></div></section><section class="py-3"><div class="mt-2 space-y-2 px-1"><label class="flex cursor-pointer w-full items-center rounded bg-gray-200 td__btn hover:bg-gray-300 px-3 py-2 text-xs font-medium focus:outline-none focus:ring-0"><input${ssrRenderAttr("accept", $data.allowed_file_types)} class="hidden" type="file">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "mr-2 h-4 w-4",
      name: "attachment"
    }, null, _parent));
    _push(` ${ssrInterpolate(_ctx.$t("Attachment"))}</label>`);
    if (!this.task.is_archive) {
      _push(`<button class="flex td__btn w-full items-center rounded bg-gray-200 hover:bg-gray-300 px-3 py-2 text-xs font-medium focus:outline-none focus:ring-0">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "mr-2 h-4 w-4",
        name: "archive"
      }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Archive"))}</button>`);
    } else {
      _push(`<button class="flex td__btn w-full items-center py-1.5 text-xs font-medium rounded bg-gray-200 hover:bg-gray-300 px-3 py-2">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "mr-2 h-4 w-4",
        name: "undo"
      }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Revert Back"))}</button>`);
    }
    if (this.task.is_archive) {
      _push(`<button class="flex w-full text-white items-center td__btn py-1.5 text-xs font-medium rounded bg-red-600 hover:bg-red-700 px-3 py-2">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "mr-2 h-4 w-4 fill-white",
        name: "dash"
      }, null, _parent));
      _push(` ${ssrInterpolate(_ctx.$t("Delete"))}</button>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></section></aside></div></div>`);
  }
  _push(`</div></div></div><!--]-->`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Modals/TaskDetails.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const TaskDetails = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  TaskDetails as T
};
