import { mergeProps, useSSRContext, resolveComponent, withCtx, createVNode, toDisplayString, openBlock, createBlock, createCommentVNode, Fragment, renderList, resolveDirective, createTextVNode } from "vue";
import { ssrRenderAttrs, ssrRenderStyle, ssrRenderSlot, ssrRenderTeleport, ssrRenderClass, ssrRenderList, ssrRenderComponent, ssrInterpolate, ssrRenderAttr, ssrIncludeBooleanAttr, ssrLooseEqual, ssrGetDirectiveProps } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
import { F as FlashMessages, L as Logo } from "./FlashMessages-DizfipYZ.js";
import { createPopper } from "@popperjs/core";
import { Link } from "@inertiajs/vue3";
import axios from "axios";
import { v4 } from "uuid";
import moment from "moment";
import "moment-duration-format";
import { getActiveLanguage, loadLanguageAsync } from "laravel-vue-i18n";
const _sfc_main$a = {
  props: {
    name: String
  }
};
function _sfc_ssrRender$a(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  if ($props.name === "apple") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "100",
      height: "100",
      viewBox: "0 0 100 100"
    }, _attrs))}><g fill-rule="nonzero"><path d="M46.173 19.967C49.927-1.838 19.797-.233 14.538.21c-.429.035-.648.4-.483.8 2.004 4.825 14.168 31.66 32.118 18.957zm13.18 1.636c1.269-.891 1.35-1.614.047-2.453l-2.657-1.71c-.94-.607-1.685-.606-2.532.129-5.094 4.42-7.336 9.18-8.211 15.24 1.597.682 3.55.79 5.265.328 1.298-4.283 3.64-8.412 8.088-11.534z"></path><path d="M88.588 67.75c9.65-27.532-13.697-45.537-35.453-32.322-1.84 1.118-4.601 1.118-6.441 0-21.757-13.215-45.105 4.79-35.454 32.321 5.302 15.123 17.06 39.95 37.295 29.995.772-.38 1.986-.38 2.758 0 20.235 9.955 31.991-14.872 37.295-29.995z"></path></g></svg>`);
  } else if ($props.name === "book") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20"
    }, _attrs))}><path d="M6 4H5a1 1 0 1 1 0-2h11V1a1 1 0 0 0-1-1H4a2 2 0 0 0-2 2v16c0 1.1.9 2 2 2h12a2 2 0 0 0 2-2V5a1 1 0 0 0-1-1h-7v8l-2-2-2 2V4z"></path></svg>`);
  } else if ($props.name === "cheveron-down") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20"
    }, _attrs))}><path d="M9.293 12.95l.707.707L15.657 8l-1.414-1.414L10 10.828 5.757 6.586 4.343 8z"></path></svg>`);
  } else if ($props.name === "cheveron-right") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20"
    }, _attrs))}><polygon points="12.95 10.707 13.657 10 8 4.343 6.586 5.757 10.828 10 6.586 14.243 8 15.657 12.95 10.707"></polygon></svg>`);
  } else if ($props.name === "location") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20"
    }, _attrs))}><path d="M10 20S3 10.87 3 7a7 7 0 1 1 14 0c0 3.87-7 13-7 13zm0-11a2 2 0 1 0 0-4 2 2 0 0 0 0 4z"></path></svg>`);
  } else if ($props.name === "office") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M496.2 133.7C505.1 139.3 512 149.6 512 160.8C512 178 498 192 480.8 192H31.16C13.95 192 .0003 178 .0003 160.8C.0003 149.6 6.035 139.3 15.8 133.7L248.1 2.08C253-.6932 258.1-.6932 263.9 2.08L496.2 133.7zM477.7 160L256 34.39L34.34 160H205.4C201.9 152.7 200 144.6 200 136C200 105.1 225.1 80 256 80C286.9 80 312 105.1 312 136C312 144.6 310.1 152.7 306.6 160H477.7zM256 160C269.3 160 280 149.3 280 136C280 122.7 269.3 112 256 112C242.7 112 232 122.7 232 136C232 149.3 242.7 160 256 160zM64 224H96V352H176V224H208V352H304V224H336V352H416V224H448V352C456.8 352 464 359.2 464 368C464 376.8 456.8 384 448 384H64C55.16 384 48 376.8 48 368C48 359.2 55.16 352 64 352V224zM472 416C480.8 416 488 423.2 488 432C488 440.8 480.8 448 472 448H40C31.16 448 24 440.8 24 432C24 423.2 31.16 416 40 416H472zM496 480C504.8 480 512 487.2 512 496C512 504.8 504.8 512 496 512H16C7.164 512 0 504.8 0 496C0 487.2 7.164 480 16 480H496z"></path></svg>`);
  } else if ($props.name === "store-front") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20"
    }, _attrs))}><path d="M18 9.87V20H2V9.87a4.25 4.25 0 0 0 3-.38V14h10V9.5a4.26 4.26 0 0 0 3 .37zM3 0h4l-.67 6.03A3.43 3.43 0 0 1 3 9C1.34 9 .42 7.73.95 6.15L3 0zm5 0h4l.7 6.3c.17 1.5-.91 2.7-2.42 2.7h-.56A2.38 2.38 0 0 1 7.3 6.3L8 0zm5 0h4l2.05 6.15C19.58 7.73 18.65 9 17 9a3.42 3.42 0 0 1-3.33-2.97L13 0z"></path></svg>`);
  } else if ($props.name === "board") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path fill-rule="evenodd" clip-rule="evenodd" d="M2 7V15C2 16.1046 2.89543 17 4 17H6C7.10457 17 8 16.1046 8 15V7C8 5.89543 7.10457 5 6 5H4C2.89543 5 2 5.89543 2 7ZM4 7V15H6V7L4 7Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M9 7V13C9 14.1046 9.89543 15 11 15H13C14.1046 15 15 14.1046 15 13V7C15 5.89543 14.1046 5 13 5H11C9.89543 5 9 5.89543 9 7ZM11 7V13H13V7L11 7Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M16 17V7C16 5.89543 16.8954 5 18 5H20C21.1046 5 22 5.89543 22 7V17C22 18.1046 21.1046 19 20 19H18C16.8954 19 16 18.1046 16 17ZM18 17V7L20 7V17H18Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "table") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M0 96C0 60.65 28.65 32 64 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416V96zM192 160H480V96C480 78.33 465.7 64 448 64H192V160zM160 64H64C46.33 64 32 78.33 32 96V160H160V64zM32 192V320H160V192H32zM32 352V416C32 433.7 46.33 448 64 448H160V352H32zM192 448H448C465.7 448 480 433.7 480 416V352H192V448zM480 320V192H192V320H480z"></path></svg>`);
  } else if ($props.name === "trash") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 448 512" }, _attrs))}><path d="M144 400C144 408.8 136.8 416 128 416C119.2 416 112 408.8 112 400V176C112 167.2 119.2 160 128 160C136.8 160 144 167.2 144 176V400zM240 400C240 408.8 232.8 416 224 416C215.2 416 208 408.8 208 400V176C208 167.2 215.2 160 224 160C232.8 160 240 167.2 240 176V400zM336 400C336 408.8 328.8 416 320 416C311.2 416 304 408.8 304 400V176C304 167.2 311.2 160 320 160C328.8 160 336 167.2 336 176V400zM310.1 22.56L336.9 64H432C440.8 64 448 71.16 448 80C448 88.84 440.8 96 432 96H416V432C416 476.2 380.2 512 336 512H112C67.82 512 32 476.2 32 432V96H16C7.164 96 0 88.84 0 80C0 71.16 7.164 64 16 64H111.1L137 22.56C145.8 8.526 161.2 0 177.7 0H270.3C286.8 0 302.2 8.526 310.1 22.56V22.56zM148.9 64H299.1L283.8 39.52C280.9 34.84 275.8 32 270.3 32H177.7C172.2 32 167.1 34.84 164.2 39.52L148.9 64zM64 432C64 458.5 85.49 480 112 480H336C362.5 480 384 458.5 384 432V96H64V432z"></path></svg>`);
  } else if ($props.name === "star") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      fill: "none",
      viewBox: "0 0 24 24",
      "stroke-width": "1.5",
      stroke: "currentColor"
    }, _attrs))}><path stroke-linecap="round" stroke-linejoin="round" d="M11.48 3.499a.562.562 0 011.04 0l2.125 5.111a.563.563 0 00.475.345l5.518.442c.499.04.701.663.321.988l-4.204 3.602a.563.563 0 00-.182.557l1.285 5.385a.562.562 0 01-.84.61l-4.725-2.885a.563.563 0 00-.586 0L6.982 20.54a.562.562 0 01-.84-.61l1.285-5.386a.562.562 0 00-.182-.557l-4.204-3.602a.563.563 0 01.321-.988l5.518-.442a.563.563 0 00.475-.345L11.48 3.5z"></path></svg>`);
  } else if ($props.name === "project") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      x: "0px",
      y: "0px",
      viewBox: "0 0 256 256"
    }, _attrs))}><g><g><path d="M226.8,136.1c-1.6-1.6-3.2-3-4.9-4.4V18.6c0-5.8-4.7-10.5-10.5-10.5H20.5C14.7,8,10,12.8,10,18.6v199.5c0,5.8,4.7,10.5,10.5,10.5h112.9V228c0.2,0.2,0.5,0.5,0.7,0.7c12.4,12.4,28.8,19.2,46.3,19.2s34-6.8,46.3-19.2c12.4-12.4,19.2-28.8,19.2-46.3C246,164.9,239.2,148.5,226.8,136.1z M20.5,220.5c-1.3,0-2.4-1.1-2.4-2.4V18.6c0-1.3,1.1-2.4,2.4-2.4h190.9c1.3,0,2.4,1.1,2.4,2.4V126c-10-5.9-21.4-9.1-33.4-9.1c-15.2,0-29.7,5.2-41.3,14.7H70.3v8.1h60.5c-7.4,8.6-12.4,18.8-14.6,29.8H70.3v8.1h44.8c-0.1,1.6-0.2,3.2-0.2,4.8c0,13.8,4.3,27,12.2,38H20.5L20.5,220.5z M180.5,239.8c-31.6,0-57.4-25.7-57.4-57.4c0-31.6,25.7-57.4,57.4-57.4c31.6,0,57.4,25.7,57.4,57.4C237.9,214.1,212.1,239.8,180.5,239.8z"></path><path d="M215.5,163.7l-37.7,36.6l-23.3-19.7l-5.2,6.2l28.9,24.4l43-41.7L215.5,163.7z"></path><path d="M42.6,55.8h19.6v8.1H42.6V55.8z"></path><path d="M70.3,55.8h121.1v8.1H70.3V55.8L70.3,55.8z"></path><path d="M42.6,93.7h19.6v8.1H42.6V93.7z"></path><path d="M70.3,93.7h121.1v8.1H70.3V93.7L70.3,93.7z"></path><path d="M42.6,131.6h19.6v8.1H42.6V131.6z"></path><path d="M42.6,169.5h19.6v8.1H42.6V169.5z"></path></g></g></svg>`);
  } else if ($props.name === "arrow-down") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 16 16" }, _attrs))}><path d="M14 5.758L13.156 5 7.992 9.506l-.55-.48.002.002-4.588-4.003L2 5.77 7.992 11 14 5.758" fill="currentColor"></path></svg>`);
  } else if ($props.name === "arrow-right") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 256 512"
    }, _attrs))}><path d="M219.9 266.7L75.89 426.7c-5.906 6.562-16.03 7.094-22.59 1.188c-6.918-6.271-6.783-16.39-1.188-22.62L186.5 256L52.11 106.7C46.23 100.1 46.75 90.04 53.29 84.1C59.86 78.2 69.98 78.73 75.89 85.29l144 159.1C225.4 251.4 225.4 260.6 219.9 266.7z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "arrow-left") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 24 24",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path d="M7.29289 11.2929L14.364 4.22185C14.7545 3.83132 15.3876 3.83132 15.7782 4.22185C16.1687 4.61237 16.1687 5.24554 15.7782 5.63606L9.41421 12L15.7782 18.364C16.1687 18.7545 16.1687 19.3877 15.7782 19.7782C15.3877 20.1687 14.7545 20.1687 14.364 19.7782L7.29289 12.7071C6.90237 12.3166 6.90237 11.6834 7.29289 11.2929Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "workspace") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      focusable: "false",
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path fill-rule="evenodd" clip-rule="evenodd" d="M12.5048 5.67168C11.9099 5.32669 11.2374 5.10082 10.5198 5.0267C11.2076 3.81639 12.5085 3 14 3C16.2092 3 18 4.79086 18 7C18 7.99184 17.639 8.89936 17.0413 9.59835C19.9512 10.7953 22 13.6584 22 17C22 17.5523 21.5523 18 21 18H18.777C18.6179 17.2987 18.3768 16.6285 18.0645 16H19.917C19.4892 13.4497 17.4525 11.445 14.8863 11.065C14.9608 10.7218 15 10.3655 15 10C15 9.58908 14.9504 9.18974 14.857 8.80763C15.5328 8.48668 16 7.79791 16 7C16 5.89543 15.1046 5 14 5C13.4053 5 12.8711 5.25961 12.5048 5.67168ZM10 12C11.1046 12 12 11.1046 12 10C12 8.89543 11.1046 8 10 8C8.89543 8 8 8.89543 8 10C8 11.1046 8.89543 12 10 12ZM14 10C14 10.9918 13.639 11.8994 13.0412 12.5984C15.9512 13.7953 18 16.6584 18 20C18 20.5523 17.5523 21 17 21H3C2.44772 21 2 20.5523 2 20C2 16.6584 4.04879 13.7953 6.95875 12.5984C6.36099 11.8994 6 10.9918 6 10C6 7.79086 7.79086 6 10 6C12.2091 6 14 7.79086 14 10ZM9.99999 14C12.973 14 15.441 16.1623 15.917 19H4.08295C4.55902 16.1623 7.02699 14 9.99999 14Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "logout") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M176 448h-96C53.53 448 32 426.5 32 400v-288C32 85.53 53.53 64 80 64h96C184.8 64 192 56.84 192 48S184.8 32 176 32h-96C35.88 32 0 67.88 0 112v288C0 444.1 35.88 480 80 480h96C184.8 480 192 472.8 192 464S184.8 448 176 448zM502.6 233.4l-128-128c-9.156-9.156-22.91-11.91-34.88-6.938C327.8 103.4 320 115.1 320 128l.0918 63.1L176 192C149.5 192 128 213.5 128 240v32C128 298.5 149.5 320 176 320l144.1-.001L320 384c0 12.94 7.797 24.62 19.75 29.56c11.97 4.969 25.72 2.219 34.88-6.938l128-128C508.9 272.4 512 264.2 512 256S508.9 239.6 502.6 233.4zM352 384V288H176C167.2 288 160 280.8 160 272v-32C160 231.2 167.2 224 176 224H352l-.0039-96l128 128L352 384z"></path></svg>`);
  } else if ($props.name === "user_edit") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M625.9 234.2l-28.13-28.14c-9.373-9.373-21.66-14.06-33.94-14.06s-24.57 4.688-33.94 14.06l-175.5 175.5c-8.936 8.936-15.03 20.32-17.5 32.71l-16.66 83.35C318.7 505.2 324.6 512 331.1 512c.7852 0 1.586-.0781 2.398-.2402l83.35-16.67c12.39-2.479 23.77-8.566 32.7-17.5l175.5-175.5C644.7 283.3 644.7 252.9 625.9 234.2zM427.8 454.1c-4.48 4.48-10.13 7.506-16.35 8.748L357.5 474.5l10.78-53.93c1.244-6.219 4.27-11.88 8.754-16.36l114.3-114.3l50.76 50.76L427.8 454.1zM603.3 279.5l-38.62 38.62l-50.76-50.76l38.62-38.62c4.076-4.076 8.838-4.686 11.31-4.686s7.236 .6094 11.31 4.686l28.13 28.14C607.4 260.9 608 265.7 608 268.1C608 270.6 607.4 275.4 603.3 279.5zM223.1 256c70.7 0 128-57.31 128-128s-57.3-128-128-128C153.3 0 96 57.31 96 128S153.3 256 223.1 256zM223.1 32c52.94 0 96 43.06 96 96c0 52.93-43.06 96-96 96s-96-43.07-96-96C127.1 75.06 171.1 32 223.1 32zM272.5 480H34.66C33.21 480 32 478.8 32 477.3C31.99 399.4 95.4 336 173.3 336h101.3c19.17 0 37.23 4.199 53.84 11.27c6.475 2.758 13.1 .9727 18.97-4.002c7.65-7.652 5.398-20.84-4.533-25.13C321.1 309.1 298.9 304 274.7 304H173.3C77.54 304-.1152 381.6 0 477.4C.0234 496.4 15.63 512 34.66 512h237.9c8.545 0 15.47-6.928 15.47-15.47v-1.059C287.1 486.9 281.1 480 272.5 480z"></path></svg>`);
  } else if ($props.name === "service") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      "aria-hidden": "true",
      focusable: "false",
      "data-prefix": "fas",
      "data-icon": "book-open",
      class: "svg-inline--fa fa-book-open fa-w-18",
      role: "img",
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 576 512"
    }, _attrs))}><path d="M542.22 32.05c-54.8 3.11-163.72 14.43-230.96 55.59-4.64 2.84-7.27 7.89-7.27 13.17v363.87c0 11.55 12.63 18.85 23.28 13.49 69.18-34.82 169.23-44.32 218.7-46.92 16.89-.89 30.02-14.43 30.02-30.66V62.75c.01-17.71-15.35-31.74-33.77-30.7zM264.73 87.64C197.5 46.48 88.58 35.17 33.78 32.05 15.36 31.01 0 45.04 0 62.75V400.6c0 16.24 13.13 29.78 30.02 30.66 49.49 2.6 149.59 12.11 218.77 46.95 10.62 5.35 23.21-1.94 23.21-13.46V100.63c0-5.29-2.62-10.14-7.27-12.99z"></path></svg>`);
  } else if ($props.name === "category") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M64 64C81.67 64 96 78.33 96 96C96 113.7 81.67 128 64 128C46.33 128 32 113.7 32 96C32 78.33 46.33 64 64 64zM496 80C504.8 80 512 87.16 512 96C512 104.8 504.8 112 496 112H176C167.2 112 160 104.8 160 96C160 87.16 167.2 80 176 80H496zM496 240C504.8 240 512 247.2 512 256C512 264.8 504.8 272 496 272H176C167.2 272 160 264.8 160 256C160 247.2 167.2 240 176 240H496zM496 400C504.8 400 512 407.2 512 416C512 424.8 504.8 432 496 432H176C167.2 432 160 424.8 160 416C160 407.2 167.2 400 176 400H496zM64 288C46.33 288 32 273.7 32 256C32 238.3 46.33 224 64 224C81.67 224 96 238.3 96 256C96 273.7 81.67 288 64 288zM64 384C81.67 384 96 398.3 96 416C96 433.7 81.67 448 64 448C46.33 448 32 433.7 32 416C32 398.3 46.33 384 64 384z"></path></svg>`);
  } else if ($props.name === "status") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M496 352C504.8 352 512 359.2 512 368C512 376.8 504.8 384 496 384H158.4C150.1 420.5 118.7 448 80 448C35.82 448 0 412.2 0 368C0 323.8 35.82 288 80 288C118.7 288 150.1 315.5 158.4 352H496zM32 368C32 394.5 53.49 416 80 416C106.5 416 128 394.5 128 368C128 341.5 106.5 320 80 320C53.49 320 32 341.5 32 368zM353.6 128C361 91.48 393.3 64 432 64C476.2 64 512 99.82 512 144C512 188.2 476.2 224 432 224C393.3 224 361 196.5 353.6 160H16C7.164 160 0 152.8 0 144C0 135.2 7.164 128 16 128H353.6zM432 192C458.5 192 480 170.5 480 144C480 117.5 458.5 96 432 96C405.5 96 384 117.5 384 144C384 170.5 405.5 192 432 192z"></path></svg>`);
  } else if ($props.name === "contact") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M272 288h-64C163.8 288 128 323.8 128 368C128 376.8 135.2 384 144 384C152.8 384 160 376.8 160 368C160 341.5 181.5 320 208 320h64c26.51 0 48 21.49 48 48c0 8.836 7.164 16 16 16c8.837 0 16-7.164 16-16C352 323.8 316.2 288 272 288zM496 192H480v96h16C504.8 288 512 280.8 512 272v-64C512 199.2 504.8 192 496 192zM240 256c35.35 0 64-28.65 64-64s-28.65-64-64-64s-64 28.65-64 64S204.7 256 240 256zM240 160c17.64 0 32 14.36 32 32s-14.36 32-32 32s-32-14.36-32-32S222.4 160 240 160zM496 320H480v96h16c8.837 0 16-7.164 16-16v-64C512 327.2 504.8 320 496 320zM496 64H480v96h16C504.8 160 512 152.8 512 144v-64C512 71.16 504.8 64 496 64zM384 0H96C60.65 0 32 28.65 32 64v384c0 35.35 28.65 64 64 64h288c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H96c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h288c17.64 0 32 14.36 32 32V448z"></path></svg>`);
  } else if ($props.name === "faq") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 384 512" }, _attrs))}><path d="M272 96C280.8 96 288 103.2 288 112C288 120.8 280.8 128 272 128H112C103.2 128 96 120.8 96 112C96 103.2 103.2 96 112 96H136.6C131.1 86.59 128 75.66 128 64C128 28.65 156.7 0 192 0C227.3 0 256 28.65 256 64C256 75.66 252.9 86.59 247.4 96H272zM192 32C174.3 32 160 46.33 160 64C160 81.67 174.3 96 192 96C209.7 96 224 81.67 224 64C224 46.33 209.7 32 192 32zM79.78 77.37C81.24 86.09 75.35 94.33 66.63 95.78L58.74 97.1C43.31 99.67 32 113 32 128.7V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V128.7C352 113 340.7 99.67 325.3 97.1L317.4 95.78C308.7 94.33 302.8 86.09 304.2 77.37C305.7 68.65 313.9 62.77 322.6 64.22L330.5 65.53C361.4 70.68 384 97.38 384 128.7V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V128.7C0 97.38 22.62 70.68 53.48 65.53L61.37 64.22C70.09 62.76 78.33 68.65 79.78 77.37zM104.7 233.8C111.2 209.2 133.4 192 158.9 192H216C251.5 192 280 221 280 256.3C280 280.3 266.6 302.5 245.1 313.4L208 332.3V352C208 360.8 200.8 368 192 368C183.2 368 176 360.8 176 352V322.5C176 316.5 179.4 311 184.7 308.3L230.5 284.9C241.2 279.5 248 268.3 248 256.3C248 238.5 233.6 224 216 224H158.9C147.1 224 138.4 231.4 135.7 241.9L135.5 242.6C133.2 251.1 124.5 256.3 115.9 254C107.4 251.8 102.3 243 104.5 234.5L104.7 233.8zM216 416C216 429.3 205.3 440 192 440C178.7 440 168 429.3 168 416C168 402.7 178.7 392 192 392C205.3 392 216 402.7 216 416z"></path></svg>`);
  } else if ($props.name === "chat") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M576 128H448v32h128c17.64 0 32 14.36 32 32v192c0 17.64-14.36 32-32 32h-64v49.57L424.4 416H320c-17.64 0-32-14.36-32-32v-32l-32-.0039v31.98c0 35.25 28.75 63.1 63.1 63.1L416 448l108.9 61.63C527.1 511.3 529.6 512 532 512C538.3 512 544 507.1 544 500v-52.03h32c35.25 0 64-28.75 64-63.1V191.1C640 156.7 611.3 128 576 128zM416 256V63.1C416 28.75 387.3 0 352 0H64C28.75 0 0 28.75 0 63.1v192C0 291.3 28.75 320 64 320l32 .0106V372C96 379.1 101.8 384 108 384c2.375 0 4.875-.75 7.125-2.375L224 320l128-.075C387.3 319.9 416 291.3 416 256zM215.6 288L128 337.6V288H64C46.36 288 32 273.6 32 256V64c0-17.64 14.36-32 32-32h288c17.64 0 32 14.36 32 32v192c0 17.64-14.36 32-32 32H215.6z"></path></svg>`);
  } else if ($props.name === "en") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      "enable-background": "new 0 0 512 512",
      version: "1.1",
      viewBox: "0 0 512 512",
      "xml:space": "preserve",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><circle cx="256" cy="256" r="256" fill="#F0F0F0"></circle><g fill="#0052B4"><path d="m52.92 100.14c-20.109 26.163-35.272 56.318-44.101 89.077h133.18l-89.077-89.077z"></path><path d="m503.18 189.22c-8.829-32.758-23.993-62.913-44.101-89.076l-89.075 89.076h133.18z"></path><path d="m8.819 322.78c8.83 32.758 23.993 62.913 44.101 89.075l89.074-89.075h-133.18z"></path><path d="m411.86 52.921c-26.163-20.109-56.317-35.272-89.076-44.102v133.18l89.076-89.075z"></path><path d="m100.14 459.08c26.163 20.109 56.318 35.272 89.076 44.102v-133.18l-89.076 89.074z"></path><path d="M189.217,8.819c-32.758,8.83-62.913,23.993-89.075,44.101l89.075,89.075V8.819z"></path><path d="m322.78 503.18c32.758-8.83 62.913-23.993 89.075-44.101l-89.075-89.075v133.18z"></path><path d="m370 322.78l89.075 89.076c20.108-26.162 35.272-56.318 44.101-89.076h-133.18z"></path></g><g fill="#D80027"><path d="m509.83 222.61h-220.44v-220.44c-10.931-1.423-22.075-2.167-33.392-2.167-11.319 0-22.461 0.744-33.391 2.167v220.44h-220.44c-1.423 10.931-2.167 22.075-2.167 33.392 0 11.319 0.744 22.461 2.167 33.391h220.44v220.44c10.931 1.423 22.073 2.167 33.392 2.167 11.317 0 22.461-0.743 33.391-2.167v-220.44h220.44c1.423-10.931 2.167-22.073 2.167-33.392 0-11.317-0.744-22.461-2.167-33.391z"></path><path d="m322.78 322.78l114.24 114.24c5.254-5.252 10.266-10.743 15.048-16.435l-97.802-97.802h-31.482v1e-3z"></path><path d="m189.22 322.78h-2e-3l-114.24 114.24c5.252 5.254 10.743 10.266 16.435 15.048l97.802-97.804v-31.479z"></path><path d="m189.22 189.22v-2e-3l-114.24-114.24c-5.254 5.252-10.266 10.743-15.048 16.435l97.803 97.803h31.481z"></path><path d="m322.78 189.22l114.24-114.24c-5.252-5.254-10.743-10.266-16.435-15.047l-97.802 97.803v31.482z"></path></g></svg>`);
  } else if ($props.name === "knowledge") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M617.8 136.7l-286.3-102.7C324 31.33 315.9 31.36 308.5 33.98L22.22 136.7C8.719 141.5 0 153.8 0 167.1s8.719 26.47 22.22 31.31L48 208.6v113.1l-31.59 138.8c-1.094 4.75 .0469 9.719 3.078 13.53S27.13 480 32.01 480h63.98c4.859 0 9.461-2.219 12.49-6c3.047-3.781 4.188-8.75 3.125-13.5L80 319.6V220l228.5 81.99c3.703 1.313 7.578 1.938 11.47 1.938c3.906 0 7.812-.6563 11.56-1.969l286.2-102.7C631.3 194.5 640 182.2 640 167.1S631.3 141.5 617.8 136.7zM52.08 447.1l12.09-52.75l11.84 52.75H52.08zM319.3 271.9L129.5 203.8l195.2-60.5c8.438-2.625 13.2-11.55 10.57-20.02c-2.609-8.407-11.49-13.23-20.01-10.55L79.4 185.8L32 168l288.7-103.9L608 168L319.3 271.9zM482.3 288.1c-8.766 1.156-14.94 9.188-13.78 17.97l11.36 86.63c1.156 8.907-4.656 17.66-14.8 22.34c-43.91 20.31-93.56 31.72-143.2 32.94H318.5c-50.02-1.219-99.67-12.63-143.6-32.94c-10.14-4.688-15.95-13.44-14.8-22.31L171.5 306.1c1.156-8.782-5.016-16.81-13.78-17.97C148.8 286.9 140.9 293.2 139.8 301.9l-11.36 86.69c-3.016 23.03 9.969 44.85 33.08 55.53C209.4 466.2 263.4 478.7 318.1 480h4.141c54.36-1.344 108.4-13.75 156.2-35.88c23.11-10.69 36.09-32.5 33.08-55.56l-11.36-86.66C499.1 293.2 491.1 286.9 482.3 288.1z"></path></svg>`);
  } else if ($props.name === "de") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      "enable-background": "new 0 0 512 512",
      version: "1.1",
      viewBox: "0 0 512 512",
      "xml:space": "preserve",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path d="M15.923,345.043C52.094,442.527,145.929,512,256,512s203.906-69.473,240.077-166.957L256,322.783  L15.923,345.043z" fill="#FFDA44"></path><path d="M256,0C145.929,0,52.094,69.472,15.923,166.957L256,189.217l240.077-22.261C459.906,69.472,366.071,0,256,0z"></path><path d="M15.923,166.957C5.633,194.69,0,224.686,0,256s5.633,61.31,15.923,89.043h480.155  C506.368,317.31,512,287.314,512,256s-5.632-61.31-15.923-89.043H15.923z" fill="#D80027"></path></svg>`);
  } else if ($props.name === "link_external") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      fill: "none",
      viewBox: "0 0 24 24",
      "stroke-width": "1.5",
      stroke: "currentColor",
      "aria-hidden": "true",
      class: "h-4 w-4 text-gray-600 hover:text-gray-800"
    }, _attrs))}><path stroke-linecap="round" stroke-linejoin="round" d="M13.5 6H5.25A2.25 2.25 0 003 8.25v10.5A2.25 2.25 0 005.25 21h10.5A2.25 2.25 0 0018 18.75V10.5m-10.5 6L21 3m0 0h-5.25M21 3v5.25"></path></svg>`);
  } else if ($props.name === "add") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      class: "",
      fill: "none",
      viewBox: "0 0 24 24",
      stroke: "currentColor"
    }, _attrs))}><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path></svg>`);
  } else if ($props.name === "details") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path fill-rule="evenodd" clip-rule="evenodd" d="M4 5C3.44772 5 3 5.44772 3 6C3 6.55228 3.44772 7 4 7H20C20.5523 7 21 6.55228 21 6C21 5.44772 20.5523 5 20 5H4ZM4 9C3.44772 9 3 9.44772 3 10C3 10.5523 3.44772 11 4 11H20C20.5523 11 21 10.5523 21 10C21 9.44772 20.5523 9 20 9H4ZM3 14C3 13.4477 3.44772 13 4 13H20C20.5523 13 21 13.4477 21 14C21 14.5523 20.5523 15 20 15H4C3.44772 15 3 14.5523 3 14ZM4 17C3.44772 17 3 17.4477 3 18C3 18.5523 3.44772 19 4 19H14C14.5523 19 15 18.5523 15 18C15 17.4477 14.5523 17 14 17H4Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "list") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 384 512" }, _attrs))}><path d="M304 336h-128C167.2 336 160 343.2 160 352s7.156 16 16 16h128c8.844 0 16-7.156 16-16S312.8 336 304 336zM304 240h-96C199.2 240 192 247.2 192 256s7.156 16 16 16h96C312.8 272 320 264.8 320 256S312.8 240 304 240zM96 328c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 338.7 109.3 328 96 328zM320 64c-8.844 0-16 7.156-16 16S311.2 96 320 96c17.64 0 32 14.34 32 32v320c0 17.66-14.36 32-32 32H64c-17.64 0-32-14.34-32-32V128c0-17.66 14.36-32 32-32c8.844 0 16-7.156 16-16S72.84 64 64 64C28.7 64 0 92.72 0 128v320c0 35.28 28.7 64 64 64h256c35.3 0 64-28.72 64-64V128C384 92.72 355.3 64 320 64zM112 128h160C280.8 128 288 120.8 288 112S280.8 96 272 96h-24.88C252.6 86.55 256 75.72 256 64c0-35.35-28.65-64-64-64S128 28.65 128 64c0 11.72 3.379 22.55 8.877 32H112C103.2 96 96 103.2 96 112S103.2 128 112 128zM192 32c17.64 0 32 14.36 32 32s-14.36 32-32 32S160 81.64 160 64S174.4 32 192 32zM68.25 229.2c-6 6.5-5.594 16.59 .9062 22.59l34.66 32C106.9 286.6 110.8 288 114.7 288c4.203 0 8.406-1.656 11.55-4.938l61.33-64c6.125-6.375 5.906-16.5-.4844-22.62c-6.359-6.094-16.48-5.906-22.61 .5L113.1 249.6L90.84 228.3C84.39 222.3 74.22 222.6 68.25 229.2z"></path></svg>`);
  } else if ($props.name === "date") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      class: "w-4 h-4 text-gray-300 fill-current",
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20",
      fill: "currentColor"
    }, _attrs))}><path fill-rule="evenodd" d="M6 2a1 1 0 00-1 1v1H4a2 2 0 00-2 2v10a2 2 0 002 2h12a2 2 0 002-2V6a2 2 0 00-2-2h-1V3a1 1 0 10-2 0v1H7V3a1 1 0 00-1-1zm0 5a1 1 0 000 2h8a1 1 0 100-2H6z" clip-rule="evenodd"></path></svg>`);
  } else if ($props.name === "comment") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path fill-rule="evenodd" clip-rule="evenodd" d="M16 17H12.5L8.28037 20.4014C6.97772 21.4869 5 20.5606 5 18.865V16.1973C3.2066 15.1599 2 13.2208 2 11C2 7.68629 4.68629 5 8 5H16C19.3137 5 22 7.68629 22 11C22 14.3137 19.3137 17 16 17ZM16 7H8C5.79086 7 4 8.79086 4 11C4 12.8638 5.27477 14.4299 7 14.874V19L12 15H16C18.2091 15 20 13.2091 20 11C20 8.79086 18.2091 7 16 7Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "more") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      class: "w-4 h-4 fill-current",
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20",
      fill: "currentColor"
    }, _attrs))}><path d="M10 6a2 2 0 110-4 2 2 0 010 4zM10 12a2 2 0 110-4 2 2 0 010 4zM10 18a2 2 0 110-4 2 2 0 010 4z"></path></svg>`);
  } else if ($props.name === "display") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 576 512"
    }, _attrs))}><path d="M512 0H64C28.65 0 0 28.65 0 64v288c0 35.35 28.65 64 64 64h149.7l-19.2 64H144C135.2 480 128 487.2 128 496S135.2 512 144 512h288c8.836 0 16-7.164 16-16S440.8 480 432 480h-50.49l-19.2-64H512c35.35 0 64-28.65 64-64V64C576 28.65 547.3 0 512 0zM348.1 480H227.9l19.2-64h81.79L348.1 480zM544 352c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V352z"></path></svg>`);
  } else if ($props.name === "more-h") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 24 24",
      fill: "currentColor",
      "aria-hidden": "true",
      class: "h-4 w-4"
    }, _attrs))}><path fill-rule="evenodd" d="M4.5 12a1.5 1.5 0 113 0 1.5 1.5 0 01-3 0zm6 0a1.5 1.5 0 113 0 1.5 1.5 0 01-3 0zm6 0a1.5 1.5 0 113 0 1.5 1.5 0 01-3 0z" clip-rule="evenodd"></path></svg>`);
  } else if ($props.name === "calendar") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 448 512"
    }, _attrs))}><path d="M96 368C96 359.2 103.2 352 112 352H240C248.8 352 256 359.2 256 368C256 376.8 248.8 384 240 384H112C103.2 384 96 376.8 96 368zM336 256C344.8 256 352 263.2 352 272C352 280.8 344.8 288 336 288H112C103.2 288 96 280.8 96 272C96 263.2 103.2 256 112 256H336zM112 0C120.8 0 128 7.164 128 16V64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V448C448 483.3 419.3 512 384 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0zM416 192H32V448C32 465.7 46.33 480 64 480H384C401.7 480 416 465.7 416 448V192zM384 96H64C46.33 96 32 110.3 32 128V160H416V128C416 110.3 401.7 96 384 96z"></path></svg>`);
  } else if ($props.name === "cn") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#d80027" d="M0 0h512v512H0z"></path><path fill="#ffda44" d="m140.1 155.8 22.1 68h71.5l-57.8 42.1 22.1 68-57.9-42-57.9 42 22.2-68-57.9-42.1H118zm163.4 240.7-16.9-20.8-25 9.7 14.5-22.5-16.9-20.9 25.9 6.9 14.6-22.5 1.4 26.8 26 6.9-25.1 9.6zm33.6-61 8-25.6-21.9-15.5 26.8-.4 7.9-25.6 8.7 25.4 26.8-.3-21.5 16 8.6 25.4-21.9-15.5zm45.3-147.6L370.6 212l19.2 18.7-26.5-3.8-11.8 24-4.6-26.4-26.6-3.8 23.8-12.5-4.6-26.5 19.2 18.7zm-78.2-73-2 26.7 24.9 10.1-26.1 6.4-1.9 26.8-14.1-22.8-26.1 6.4 17.3-20.5-14.2-22.7 24.9 10.1z"></path></g></svg>`);
  } else if ($props.name === "pt") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 64 64",
      xmlns: "http://www.w3.org/2000/svg",
      "aria-hidden": "true",
      class: "prefix__iconify prefix__iconify--emojione"
    }, _attrs))}><path d="M17 58V6a30 30 0 0 0 0 52z" fill="#699635"></path><path d="M32 2c-5.5 0-10.6 1.5-15 4v52A30 30 0 1 0 32 2" fill="#ed4c5c"></path><g fill="#ffe62e"><path d="M17 20c-6.6 0-12 5.4-12 12s5.4 12 12 12 12-5.4 12-12-5.4-12-12-12m0 22.5a10.5 10.5 0 1 1 0-21 10.5 10.5 0 0 1 0 21"></path><path d="M21.1 43.7c-.2.2-.5.2-.7 0L6.7 25.6a.5.5 0 0 1 0-.7l.3-.3c.2-.2.5-.2.7 0l13.7 18.1c.2.2.2.5 0 .7l-.3.3"></path><path d="M17.2 19.5c.3 0 .5.2.5.5v24c0 .3-.2.5-.5.5h-.5c-.3 0-.5-.2-.5-.5V20c0-.3.2-.5.5-.5h.5"></path><path d="M28.9 33.3 17 31.2v1.5l11.7 2.1c.3 0 .5-.1.6-.4l.1-.5c0-.2-.2-.5-.5-.6M17 31.1l-9.4-6.6c-.2-.2-.5-.1-.7.1l-.3.4c-.2.2-.1.5.1.7L17 32.9v-1.8"></path><path d="m16.6 30-9.4 9.4c-.2.2-.2.5 0 .7l.4.4c.2.2.5.2.7 0l8.3-8.3V30M17 25.5 4.5 31.4c-.2.1-.4.4-.2.7l.2.5c.1.2.4.4.7.2L17 27.2v-1.7"></path><path d="m28.1 27.2-11.9-2.1v1.5l11.7 2.1c.3 0 .5-.1.6-.4l.1-.5c-.1-.3-.3-.6-.5-.6M16.9 38.9c-.2.1-.4.4-.2.7l.2.5c.1.2.4.4.7.2l10-4.6.5-1.9-11.2 5.1M16.9 35.5 5.7 31.4V33l11.2 4.1z"></path><path d="M9.1 38.8v1.5l14.8 1 1.6-1.4-16.4-1.1"></path></g><path d="M12 27v7c0 2.8 2.2 5 5 5s5-2.2 5-5v-7H12" fill="#fff"></path><path d="M17 41a7 7 0 0 1-7-7v-9h14v9a7 7 0 0 1-7 7m-3-12v5c0 1.7 1.3 3 3 3s3-1.3 3-3v-5h-6" fill="#ed4c5c"></path><g fill="#0071bc"><path d="M16.1 29.4V31c0 .3.2.5.5.5h.8c.3 0 .5-.2.5-.5v-1.7h-1.8zM16.1 31.9v1.7c0 .3.2.5.5.5h.8c.3 0 .5-.2.5-.5v-1.7h-1.8M14.1 31.9v1.7c0 .3.2.5.5.5h.8c.3 0 .5-.2.5-.5v-1.7h-1.8M18.1 31.9v1.7c0 .3.2.5.5.5h.8c.3 0 .5-.2.5-.5v-1.7h-1.8M16.1 34.3V36c0 .3.2.5.5.5h.8c.3 0 .5-.2.5-.5v-1.7h-1.8"></path></g><g fill="#fff"><circle cx="17" cy="32.9" r=".2"></circle><circle cx="16.6" cy="33.4" r=".2"></circle><circle cx="17.4" cy="33.4" r=".2"></circle><circle cx="16.6" cy="32.4" r=".2"></circle><circle cx="17.4" cy="32.4" r=".2"></circle><circle cx="17" cy="30.4" r=".2"></circle><circle cx="16.6" cy="30.9" r=".2"></circle><circle cx="17.4" cy="30.9" r=".2"></circle><circle cx="16.6" cy="29.9" r=".2"></circle><circle cx="17.4" cy="29.9" r=".2"></circle><circle cx="19" cy="32.9" r=".2"></circle><circle cx="18.6" cy="33.4" r=".2"></circle><circle cx="19.4" cy="33.4" r=".2"></circle><circle cx="18.6" cy="32.4" r=".2"></circle><circle cx="19.4" cy="32.4" r=".2"></circle><circle cx="15" cy="32.9" r=".2"></circle><circle cx="14.6" cy="33.4" r=".2"></circle><circle cx="15.4" cy="33.4" r=".2"></circle><circle cx="14.6" cy="32.4" r=".2"></circle><circle cx="15.4" cy="32.4" r=".2"></circle><circle cx="17" cy="35.4" r=".2"></circle><circle cx="16.6" cy="35.9" r=".2"></circle><circle cx="17.4" cy="35.9" r=".2"></circle><circle cx="16.6" cy="34.9" r=".2"></circle><circle cx="17.4" cy="34.9" r=".2"></circle></g><path fill="#ffe62e" d="M16 28h2l-.2-1v-1h.2v-.5h-.3v.3h-.1v-.3h-.3v.3h-.2v-.3h-.2v.3h-.2v-.3h-.3v.3h-.2v-.3H16v.5h.2v1z"></path><g fill="#3e4347"><path d="M17.3 28h-.1v-.4l-.2-.2-.2.2v.4h-.1v-.4c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.4M17 26.9h-.6v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4M17.6 26.9H17v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4"></path></g><path fill="#ffe62e" d="M11 28h2l-.2-1v-1h.2v-.5h-.3v.3h-.1v-.3h-.3v.3h-.2v-.3h-.2v.3h-.2v-.3h-.3v.3h-.2v-.3H11v.5h.2v1z"></path><g fill="#3e4347"><path d="M12.3 28h-.1v-.4l-.2-.2-.2.2v.4h-.1v-.4c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.4M12 26.9h-.6v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4"></path><path d="M12.6 26.9H12v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4"></path></g><path fill="#ffe62e" d="M11 33.9h2l-.2-1v-1h.2v-.5h-.2v.3h-.2v-.3h-.2v.3h-.3v-.3h-.2v.3h-.2v-.3h-.2v.3h-.2v-.3H11v.5h.3v1z"></path><g fill="#3e4347"><path d="M12.3 33.9h-.1v-.4l-.2-.2-.2.2v.4h-.1v-.4c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.4M12 32.8h-.6v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4M12.7 32.8h-.6v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4"></path></g><path fill="#ffe62e" d="M21 34h2l-.2-1v-1h.2v-.4h-.3v.2h-.1v-.2h-.3v.2h-.2v-.2h-.2v.2h-.2v-.2h-.3v.2h-.2v-.2H21v.4h.2v1z"></path><g fill="#3e4347"><path d="M22.3 34h-.1v-.4l-.2-.2-.2.2v.4h-.1v-.4c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.4M22 32.9h-.6v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4M22.6 32.9H22v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4"></path></g><path fill="#ffe62e" d="M21 28h2l-.2-1v-1h.2v-.5h-.3v.3h-.1v-.3h-.3v.3h-.2v-.3h-.2v.3h-.2v-.3h-.3v.3h-.2v-.3H21v.5h.2v1z"></path><g fill="#3e4347"><path d="M22.3 28h-.1v-.4l-.2-.2-.2.2v.4h-.1v-.4c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.4M22 26.9h-.6v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4M22.6 26.9H22v-.5c0-.2.1-.3.3-.3.2 0 .3.1.3.3v.5m-.5-.1h.4v-.4l-.2-.2-.2.2v.4"></path></g><path fill="#ffe62e" d="m14.2 39.6 1.4-1.5-.9-.5-.7-.7.2-.2-.3-.3-.2.2.2.2-.1.1-.2-.2-.2.2.2.1-.2.2-.1-.2-.2.2.2.2-.2.1-.1-.2-.2.2.1.2-.1.1-.1-.2-.2.2.3.3h.1l.1-.1.7.7z"></path><g fill="#3e4347"><path d="m15.1 38.6-.4-.2h-.3v.3l.3.3-.1.1-.3-.3c-.1-.1-.1-.3 0-.4s.3-.1.4 0l.4.2M14.1 38.1l-.4.4-.3-.3c-.1-.1-.1-.3 0-.4s.3-.1.4 0l.3.3m-.4.3.3-.3-.3-.3h-.3v.3l.3.3M14.6 37.6l-.4.4-.3-.3c-.1-.1-.1-.3 0-.4s.3-.1.4 0l.3.3m-.4.3.3-.3-.3-.3h-.3v.3l.3.3"></path></g><path fill="#ffe62e" d="m19.8 39.6-1.4-1.5.8-.5.7-.7-.1-.2.3-.3.2.2-.2.2.1.1.2-.2.2.2-.2.1.2.2.1-.2.2.2-.2.2.2.1.1-.2.2.2-.2.2.2.1.1-.2.2.2-.3.3h-.1L21 38l-.7.7z"></path><g fill="#3e4347"><path d="m18.9 38.6.4-.2h.3v.3l-.4.3.1.1.3-.3c.1-.1.1-.3 0-.4a.3.3 0 0 0-.4 0l-.3.2M20.2 37.8c.1-.1.3-.1.4 0 .1.1.1.3 0 .4l-.3.3-.4-.4.3-.3m.3.3v-.3h-.3l-.2.3.3.3.2-.3M19.7 37.3c.1-.1.3-.1.4 0 .1.1.1.3 0 .4l-.3.3-.4-.4.3-.3m.4.3v-.3h-.3l-.3.3.3.3.3-.3"></path></g></svg>`);
  } else if ($props.name === "he") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 1100 650"
    }, _attrs))}><g data-name="Layer 2"><g data-name="Layer 1"><path class="cls-1" fill="#0038b8" d="M0,0H1100V125H0Z"></path><path class="cls-1" fill="#0038b8" d="M0,525H1100V650H0Z"></path><path fill="none" stroke="#0038b8" stroke-width="27.5px" d="M423.82,397.85H676.18L550,179.29ZM550,470.71,676.18,252.15H423.82Z"></path></g></g></svg>`);
  } else if ($props.name === "nl") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#eee" d="m0 167 253.8-19.3L512 167v178l-254.9 32.3L0 345z"></path><path fill="#a2001d" d="M0 0h512v167H0z"></path><path fill="#0052b4" d="M0 345h512v167H0z"></path></g></svg>`);
  } else if ($props.name === "bd") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#496e2d" d="M0 0h512v512H0z"></path><circle cx="200.3" cy="256" r="111.3" fill="#d80027"></circle></g></svg>`);
  } else if ($props.name === "it") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#eee" d="M167 0h178l25.9 252.3L345 512H167l-29.8-253.4z"></path><path fill="#6da544" d="M0 0h167v512H0z"></path><path fill="#d80027" d="M345 0h167v512H345z"></path></g></svg>`);
  } else if ($props.name === "sa") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#496e2d" d="M0 0h512v512H0z"></path><g fill="#eee"><path d="M144.7 306c0 18.5 15 33.5 33.4 33.5h100.2a27.8 27.8 0 0 0 27.8 27.8h33.4a27.8 27.8 0 0 0 27.8-27.8V306zm225.4-161.3v78c0 12.2-10 22.2-22.3 22.2v33.4c30.7 0 55.7-25 55.7-55.7v-77.9H370zm-239.3 78c0 12.2-10 22.2-22.3 22.2v33.4c30.7 0 55.7-25 55.7-55.7v-77.9h-33.4z"></path><path d="M320 144.7h33.4v78H320zm-50 44.5a5.6 5.6 0 0 1-11.2 0v-44.5h-33.4v44.5a5.6 5.6 0 0 1-11.1 0v-44.5h-33.4v44.5a39 39 0 0 0 39 39 38.7 38.7 0 0 0 22.2-7 38.7 38.7 0 0 0 22.2 7c1.7 0 3.4-.1 5-.3a22.3 22.3 0 0 1-21.6 17v33.4c30.6 0 55.6-25 55.6-55.7v-77.9H270z"></path><path d="M180.9 244.9h50v33.4h-50z"></path></g></g></svg>`);
  } else if ($props.name === "es") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#ffda44" d="m0 128 256-32 256 32v256l-256 32L0 384Z"></path><path fill="#d80027" d="M0 0h512v128H0zm0 384h512v128H0z"></path><g fill="#eee"><path d="M144 304h-16v-80h16zm128 0h16v-80h-16z"></path><ellipse cx="208" cy="296" rx="48" ry="32"></ellipse></g><g fill="#d80027"><rect width="16" height="24" x="128" y="192" rx="8"></rect><rect width="16" height="24" x="272" y="192" rx="8"></rect><path d="M208 272v24a24 24 0 0 0 24 24 24 24 0 0 0 24-24v-24h-24z"></path></g><rect width="32" height="16" x="120" y="208" fill="#ff9811" ry="8"></rect><rect width="32" height="16" x="264" y="208" fill="#ff9811" ry="8"></rect><rect width="32" height="16" x="120" y="304" fill="#ff9811" rx="8"></rect><rect width="32" height="16" x="264" y="304" fill="#ff9811" rx="8"></rect><path fill="#ff9811" d="M160 272v24c0 8 4 14 9 19l5-6 5 10a21 21 0 0 0 10 0l5-10 5 6c6-5 9-11 9-19v-24h-9l-5 8-5-8h-10l-5 8-5-8z"></path><path d="M122 252h172m-172 24h28m116 0h28"></path><path fill="#d80027" d="M122 248a4 4 0 0 0-4 4 4 4 0 0 0 4 4h172a4 4 0 0 0 4-4 4 4 0 0 0-4-4zm0 24a4 4 0 0 0-4 4 4 4 0 0 0 4 4h28a4 4 0 0 0 4-4 4 4 0 0 0-4-4zm144 0a4 4 0 0 0-4 4 4 4 0 0 0 4 4h28a4 4 0 0 0 4-4 4 4 0 0 0-4-4z"></path><path fill="#eee" d="M196 168c-7 0-13 5-15 11l-5-1c-9 0-16 7-16 16s7 16 16 16c7 0 13-4 15-11a16 16 0 0 0 17-4 16 16 0 0 0 17 4 16 16 0 1 0 10-20 16 16 0 0 0-27-5c-3-4-7-6-12-6zm0 8c5 0 8 4 8 8 0 5-3 8-8 8-4 0-8-3-8-8 0-4 4-8 8-8zm24 0c5 0 8 4 8 8 0 5-3 8-8 8-4 0-8-3-8-8 0-4 4-8 8-8zm-44 10 4 1 4 8c0 4-4 7-8 7s-8-3-8-8c0-4 4-8 8-8zm64 0c5 0 8 4 8 8 0 5-3 8-8 8-4 0-8-3-8-7l4-8z"></path><path fill="none" d="M220 284v12c0 7 5 12 12 12s12-5 12-12v-12z"></path><path fill="#ff9811" d="M200 160h16v32h-16z"></path><path fill="#eee" d="M208 224h48v48h-48z"></path><path fill="#d80027" d="m248 208-8 8h-64l-8-8c0-13 18-24 40-24s40 11 40 24zm-88 16h48v48h-48z"></path><rect width="20" height="32" x="222" y="232" fill="#d80027" rx="10" ry="10"></rect><path fill="#ff9811" d="M168 232v8h8v16h-8v8h32v-8h-8v-16h8v-8zm8-16h64v8h-64z"></path><g fill="#ffda44"><circle cx="186" cy="202" r="6"></circle><circle cx="208" cy="202" r="6"></circle><circle cx="230" cy="202" r="6"></circle></g><path fill="#d80027" d="M169 272v43a24 24 0 0 0 10 4v-47h-10zm20 0v47a24 24 0 0 0 10-4v-43h-10z"></path><g fill="#338af3"><circle cx="208" cy="272" r="16"></circle><rect width="32" height="16" x="264" y="320" ry="8"></rect><rect width="32" height="16" x="120" y="320" ry="8"></rect></g></g></svg>`);
  } else if ($props.name === "se") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "512",
      height: "512",
      viewBox: "0 0 512 512"
    }, _attrs))}><mask id="a"><circle cx="256" cy="256" r="256" fill="#fff"></circle></mask><g mask="url(#a)"><path fill="#0052b4" d="M0 0h133.6l35.3 16.7L200.3 0H512v222.6l-22.6 31.7 22.6 35.1V512H200.3l-32-19.8-34.7 19.8H0V289.4l22.1-33.3L0 222.6z"></path><path fill="#ffda44" d="M133.6 0v222.6H0v66.8h133.6V512h66.7V289.4H512v-66.8H200.3V0z"></path></g></svg>`);
  } else if ($props.name === "br") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      width: "256",
      height: "256",
      viewBox: "0 0 256 256",
      "xml:space": "preserve"
    }, _attrs))}><defs></defs><g style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "0", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "none", "fill-rule": "nonzero", "opacity": "1" })}" transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)"><circle cx="45" cy="45" r="45" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(34,158,69)", "fill-rule": "nonzero", "opacity": "1" })}" transform="  matrix(1 0 0 1 0 0) "></circle><path d="M 45.168 68.369 l 35.957 -23.337 l -36.175 -23.4 L 8.875 45.088 L 45.168 68.369 L 45.168 68.369 z" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(248,229,9)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path><path d="M 60.835 45.001 c 0 8.388 -6.81 15.187 -15.212 15.187 c -8.401 0 -15.212 -6.8 -15.212 -15.187 s 6.811 -15.187 15.212 -15.187 C 54.025 29.813 60.835 36.613 60.835 45.001 L 60.835 45.001 z" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(43,73,163)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path><path d="M 40.623 54.097 l -0.47 -0.271 l -0.488 0.242 l 0.109 -0.543 l -0.377 -0.397 l 0.539 -0.063 l 0.253 -0.487 l 0.226 0.503 l 0.532 0.097 l -0.399 0.373 M 50.817 56.678 l -0.47 -0.271 l -0.488 0.242 l 0.109 -0.543 l -0.377 -0.397 l 0.539 -0.063 l 0.253 -0.487 l 0.226 0.503 l 0.532 0.097 l -0.399 0.373 M 46.423 52.555 l -0.406 -0.234 l -0.422 0.208 l 0.094 -0.469 l -0.326 -0.343 l 0.466 -0.055 l 0.219 -0.42 l 0.195 0.435 l 0.46 0.083 l -0.345 0.323 M 56.718 51.072 l -0.399 -0.23 l -0.414 0.205 l 0.093 -0.46 l -0.32 -0.337 l 0.457 -0.054 l 0.215 -0.413 l 0.192 0.427 l 0.451 0.082 l -0.338 0.317 M 46.237 47.985 l -0.47 -0.271 l -0.488 0.242 l 0.109 -0.543 l -0.377 -0.397 l 0.539 -0.063 l 0.253 -0.487 l 0.226 0.503 l 0.532 0.097 l -0.399 0.373 M 33.685 43.273 l -0.47 -0.271 l -0.488 0.242 l 0.109 -0.542 l -0.377 -0.398 l 0.539 -0.063 l 0.253 -0.487 l 0.226 0.503 l 0.532 0.097 l -0.399 0.373 M 35.195 49.542 l -0.47 -0.271 l -0.488 0.242 l 0.109 -0.542 l -0.377 -0.398 l 0.539 -0.063 l 0.253 -0.487 l 0.226 0.503 l 0.532 0.097 l -0.399 0.374 M 50.858 39.965 l -0.415 -0.239 l -0.431 0.213 l 0.097 -0.479 l -0.333 -0.351 l 0.476 -0.056 l 0.224 -0.43 l 0.2 0.445 l 0.47 0.085 l -0.352 0.33" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(255,255,239)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path><path d="M 40.623 46.502 l -0.47 -0.271 l -0.488 0.242 l 0.109 -0.542 l -0.377 -0.398 l 0.539 -0.063 l 0.253 -0.487 l 0.226 0.503 l 0.532 0.097 l -0.399 0.374" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(255,255,239)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path><path d="M 59.833 50.464 c 0.232 -0.606 0.531 -1.521 0.69 -2.36 c -8.079 -7.097 -17.086 -10.733 -28.467 -9.985 c -0.408 0.782 -0.735 1.601 -1.01 2.487 C 44.531 39.32 54.415 45.29 59.833 50.464 L 59.833 50.464 z" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(255,255,255)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path></g></svg>`);
  } else if ($props.name === "home") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      "data-v-4d521fc4": "",
      xmlns: "http://www.w3.org/2000/svg",
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      fill: "none",
      stroke: "currentColor",
      "stroke-width": "2",
      "stroke-linecap": "round",
      "stroke-linejoin": "round",
      class: "feather feather-home feather__content"
    }, _attrs))}><path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path><polyline points="9 22 9 12 15 12 15 22"></polyline></svg>`);
  } else if ($props.name === "clock") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M240 112C240 103.2 247.2 96 256 96C264.8 96 272 103.2 272 112V256C272 259.2 271.1 262.2 269.3 264.9L205.3 360.9C200.4 368.2 190.5 370.2 183.1 365.3C175.8 360.4 173.8 350.5 178.7 343.1L240 251.2L240 112zM256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0zM32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32C132.3 32 32 132.3 32 256z"></path></svg>`);
  } else if ($props.name === "blink") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 8 8" }, _attrs))}><circle fill="#ff0000" stroke="none" cx="4" cy="4" r="4"><animate attributeName="opacity" dur="2s" values="0;1;0" repeatCount="indefinite" begin="0.1"></animate></circle></svg>`);
  } else if ($props.name === "settings") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M225.1 378.1c-5.346-9.277-17.67-11.48-25.24-3.91l-91.57 91.55c-15.01 15-38.9 18.79-56.54 6.984c-23.71-15.88-26.04-48.76-6.967-67.97l134.8-134.8c6.242-6.238 6.229-16.36-.0313-22.59C173.3 241.2 163.2 241.2 156.1 247.4l-134.7 134.7c-29.62 29.62-29.62 77.86 0 107.5c16.64 16.78 39.93 24.7 63.89 21.57c17.43-2.273 33.27-11.36 45.7-23.79l90.54-90.52c4.883-4.883 6.32-12.52 2.857-18.49C225.2 378.3 225.1 378.2 225.1 378.1zM259.8 88.66c4.697-7.82 10.35-15.14 16.98-21.8c22.75-22.62 52.62-34.87 83.87-34.87c6.875 0 13.75 .625 20.62 1.75l-69.25 69.48l13.75 82.98l83.12 13.75l69.37-69.23c6.625 38.12-5.373 76.73-33.12 104.5c-4.432 4.434-9.207 8.426-14.23 12c-7.775 5.527-8.24 16.98-1.475 23.7c5.625 5.594 14.65 6.258 21.07 1.602c6.045-4.383 11.82-9.293 17.26-14.81c37.75-37.74 52.62-91.35 39.62-143.2c-2.25-9.492-9.625-16.99-19.12-19.62s-19.62 0-26.62 7l-63.87 63.86L353.5 158.3l-7.373-44.12l63.87-63.98c6.873-6.871 9.623-16.99 6.998-26.49c-2.623-9.496-10.25-16.74-19.75-19.12c-51.62-12.88-105.2 1.875-143.1 39.61c-8.27 8.348-15.16 17.61-20.98 27.39c-3.791 6.367-3.049 14.45 2.191 19.68C242.5 98.44 254.6 97.3 259.8 88.66zM63.1 431.9c0 8.746 7.25 15.1 16 15.1s15.1-7.25 15.1-15.1s-7.248-15.1-15.1-15.1S63.1 423.1 63.1 431.9zM502.6 389.4l-124.4-124.5c-15.62-15.62-36.12-23.37-56.62-23.37c-15.38 0-30.88 4.371-44.12 13.25L191.1 169.3l.002-73.35l-127.1-95.99L0 63.1l96 127.1l73.37-.0289l85.5 85.48c-20.62 31.12-17.12 73.23 10.25 100.7l124.5 124.5C395.7 508.8 403.1 512 412.2 512c8.123 0 16.37-3.125 22.5-9.375l67.1-67.98C515.1 422.1 515.1 401.9 502.6 389.4zM159.1 159.1h-47.1L42.25 66.98L66.1 42.24l92.1 69.73V159.1zM412.1 479.9l-124.4-124.5c-9.123-9.125-14.12-21.12-14.12-33.87c0-12.88 5-24.87 14.12-33.87c9-9.125 21-14.12 33.88-14.12c12.75 0 24.88 4.996 33.87 14.12l124.5 124.3L412.1 479.9z"></path></svg>`);
  } else if ($props.name === "dashboard") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 440" }, _attrs))}><g data-name="Layer 2"><g data-name="Capa 1"><path d="M452,130a10,10,0,0,0-10-10H70a10,10,0,0,0-10,10v90a10,10,0,0,0,10,10H442a10,10,0,0,0,10-10Zm-20,80H80V140H432Z"></path><path d="M60,370a10,10,0,0,0,10,10H226a10,10,0,0,0,10-10V280a10,10,0,0,0-10-10H70a10,10,0,0,0-10,10Zm20-80H216v70H80Z"></path><path d="M442,270H286a10,10,0,0,0-10,10v90a10,10,0,0,0,10,10H442a10,10,0,0,0,10-10V280A10,10,0,0,0,442,270Zm-10,90H296V290H432Z"></path><circle cx="255.92" cy="429.98" r="10"></circle><path d="M482,0H30A30,30,0,0,0,0,30V410a30,30,0,0,0,30,30H211a10,10,0,0,0,0-20H30a10,10,0,0,1-10-10V80H492V410a10,10,0,0,1-10,10H301a10,10,0,0,0,0,20H482a30,30,0,0,0,30-30V30A30,30,0,0,0,482,0ZM20,30A10,10,0,0,1,30,20H366V60H20ZM386,60V20h96a10,10,0,0,1,10,10V60Z"></path></g></g></svg>`);
  } else if ($props.name === "drag") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 24 24" }, _attrs))}><g fill="currentColor" fill-rule="evenodd"><circle cx="10" cy="8" r="1"></circle><circle cx="14" cy="8" r="1"></circle><circle cx="10" cy="16" r="1"></circle><circle cx="14" cy="16" r="1"></circle><circle cx="10" cy="12" r="1"></circle><circle cx="14" cy="12" r="1"></circle></g></svg>`);
  } else if ($props.name === "edit") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M386.7 22.63C411.7-2.365 452.3-2.365 477.3 22.63L489.4 34.74C514.4 59.74 514.4 100.3 489.4 125.3L269 345.6C260.6 354.1 249.9 359.1 238.2 362.7L147.6 383.6C142.2 384.8 136.6 383.2 132.7 379.3C128.8 375.4 127.2 369.8 128.4 364.4L149.3 273.8C152 262.1 157.9 251.4 166.4 242.1L386.7 22.63zM454.6 45.26C442.1 32.76 421.9 32.76 409.4 45.26L382.6 72L440 129.4L466.7 102.6C479.2 90.13 479.2 69.87 466.7 57.37L454.6 45.26zM180.5 281L165.3 346.7L230.1 331.5C236.8 330.2 242.2 327.2 246.4 322.1L417.4 152L360 94.63L189 265.6C184.8 269.8 181.8 275.2 180.5 281V281zM208 64C216.8 64 224 71.16 224 80C224 88.84 216.8 96 208 96H80C53.49 96 32 117.5 32 144V432C32 458.5 53.49 480 80 480H368C394.5 480 416 458.5 416 432V304C416 295.2 423.2 288 432 288C440.8 288 448 295.2 448 304V432C448 476.2 412.2 512 368 512H80C35.82 512 0 476.2 0 432V144C0 99.82 35.82 64 80 64H208z"></path></svg>`);
  } else if ($props.name === "up") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 320.02 192.03"
    }, _attrs))}><g data-name="Layer 2"><g data-name="Layer 1"><path d="M27.66,192h264.7c24.6,0,36.89-29.78,19.54-47.12L179.6,8.11a27.47,27.47,0,0,0-39,0L8.12,144.93C-9.23,162.23,3.06,192,27.66,192Z"></path></g></g></svg>`);
  } else if ($props.name === "down") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 319.98 192"
    }, _attrs))}><g data-name="Layer 2"><g data-name="Layer 1"><path d="M311.9,47.1,179.5,183.9a27.47,27.47,0,0,1-39,0L8.13,47.09C-9.23,29.8,3.05,0,27.66,0h264.7C316.9,0,329.2,29.8,311.9,47.1Z"></path></g></g></svg>`);
  } else if ($props.name === "tick") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM371.8 211.8C382.7 200.9 382.7 183.1 371.8 172.2C360.9 161.3 343.1 161.3 332.2 172.2L224 280.4L179.8 236.2C168.9 225.3 151.1 225.3 140.2 236.2C129.3 247.1 129.3 264.9 140.2 275.8L204.2 339.8C215.1 350.7 232.9 350.7 243.8 339.8L371.8 211.8z"></path></svg>`);
  } else if ($props.name === "tick_check") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      focusable: "false",
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path d="M6.73534 12.3223C6.36105 11.9162 5.72841 11.8904 5.3223 12.2647C4.91619 12.639 4.89039 13.2716 5.26467 13.6777L8.87678 17.597C9.41431 18.1231 10.2145 18.1231 10.7111 17.6264C10.7724 17.5662 10.7724 17.5662 11.0754 17.2683C11.3699 16.9785 11.6981 16.6556 12.0516 16.3075C13.0614 15.313 14.0713 14.3169 15.014 13.3848L15.0543 13.3449C16.7291 11.6887 18.0004 10.4236 18.712 9.70223C19.0998 9.30904 19.0954 8.67589 18.7022 8.28805C18.309 7.90022 17.6759 7.90457 17.2881 8.29777C16.5843 9.01131 15.3169 10.2724 13.648 11.9228L13.6077 11.9626C12.6662 12.8937 11.6572 13.8889 10.6483 14.8825C10.3578 15.1685 10.0845 15.4375 9.83288 15.6851L6.73534 12.3223Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "cross") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256zM175 208.1L222.1 255.1L175 303C165.7 312.4 165.7 327.6 175 336.1C184.4 346.3 199.6 346.3 208.1 336.1L255.1 289.9L303 336.1C312.4 346.3 327.6 346.3 336.1 336.1C346.3 327.6 346.3 312.4 336.1 303L289.9 255.1L336.1 208.1C346.3 199.6 346.3 184.4 336.1 175C327.6 165.7 312.4 165.7 303 175L255.1 222.1L208.1 175C199.6 165.7 184.4 165.7 175 175C165.7 184.4 165.7 199.6 175 208.1V208.1z"></path></svg>`);
  } else if ($props.name === "close") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 320 512" }, _attrs))}><path d="M315.3 411.3c-6.253 6.253-16.37 6.253-22.63 0L160 278.6l-132.7 132.7c-6.253 6.253-16.37 6.253-22.63 0c-6.253-6.253-6.253-16.37 0-22.63L137.4 256L4.69 123.3c-6.253-6.253-6.253-16.37 0-22.63c6.253-6.253 16.37-6.253 22.63 0L160 233.4l132.7-132.7c6.253-6.253 16.37-6.253 22.63 0c6.253 6.253 6.253 16.37 0 22.63L182.6 256l132.7 132.7C321.6 394.9 321.6 405.1 315.3 411.3z"></path></svg>`);
  } else if ($props.name === "file") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 576 512" }, _attrs))}><path d="M64 480H296.2C305.1 491.8 317.3 502.3 329.7 511.3C326.6 511.7 323.3 512 320 512H64C28.65 512 0 483.3 0 448V64C0 28.65 28.65 0 64 0H220.1C232.8 0 245.1 5.057 254.1 14.06L369.9 129.9C378.9 138.9 384 151.2 384 163.9V198.6C372.8 201.8 362.1 206 352 211.2V192H240C213.5 192 192 170.5 192 144V32H64C46.33 32 32 46.33 32 64V448C32 465.7 46.33 480 64 480V480zM347.3 152.6L231.4 36.69C229.4 34.62 226.8 33.18 224 32.48V144C224 152.8 231.2 160 240 160H351.5C350.8 157.2 349.4 154.6 347.3 152.6zM448 351.1H496C504.8 351.1 512 359.2 512 367.1C512 376.8 504.8 383.1 496 383.1H448V431.1C448 440.8 440.8 447.1 432 447.1C423.2 447.1 416 440.8 416 431.1V383.1H368C359.2 383.1 352 376.8 352 367.1C352 359.2 359.2 351.1 368 351.1H416V303.1C416 295.2 423.2 287.1 432 287.1C440.8 287.1 448 295.2 448 303.1V351.1zM576 368C576 447.5 511.5 512 432 512C352.5 512 288 447.5 288 368C288 288.5 352.5 224 432 224C511.5 224 576 288.5 576 368zM432 256C370.1 256 320 306.1 320 368C320 429.9 370.1 480 432 480C493.9 480 544 429.9 544 368C544 306.1 493.9 256 432 256z"></path></svg>`);
  } else if ($props.name === "attachment") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 20 20",
      fill: "currentColor"
    }, _attrs))}><path fill-rule="evenodd" d="M8 4a3 3 0 00-3 3v4a5 5 0 0010 0V7a1 1 0 112 0v4a7 7 0 11-14 0V7a5 5 0 0110 0v4a3 3 0 11-6 0V7a1 1 0 012 0v4a1 1 0 102 0V7a3 3 0 00-3-3z" clip-rule="evenodd"></path></svg>`);
  } else if ($props.name === "archive") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M464 32h-416C21.49 32 0 53.49 0 80v64C0 152.8 7.25 160 16 160H32v256c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V160h16C504.8 160 512 152.8 512 144V80C512 53.49 490.5 32 464 32zM448 416c0 17.6-14.4 32-32 32H96c-17.6 0-32-14.4-32-32V160h384V416zM480 128H32V80C32 71.25 39.25 64 48 64h416C472.8 64 480 71.25 480 80V128zM176 256h160C344.8 256 352 248.8 352 240S344.8 224 336 224h-160C167.2 224 160 231.2 160 240S167.2 256 176 256z"></path></svg>`);
  } else if ($props.name === "checked") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 16 16",
      fill: "white"
    }, _attrs))}><path d="M12.207 4.793a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0l-2-2a1 1 0 011.414-1.414L6.5 9.086l4.293-4.293a1 1 0 011.414 0z"></path></svg>`);
  } else if ($props.name === "checklist") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path fill-rule="evenodd" clip-rule="evenodd" d="M6 4C4.89543 4 4 4.89543 4 6V18C4 19.1046 4.89543 20 6 20H18C19.1046 20 20 19.1046 20 18V13C20 12.4477 19.5523 12 19 12C18.4477 12 18 12.4477 18 13V18H6V6L16 6C16.5523 6 17 5.55228 17 5C17 4.44772 16.5523 4 16 4H6ZM8.73534 10.3223C8.36105 9.91618 7.72841 9.89038 7.3223 10.2647C6.91619 10.639 6.89039 11.2716 7.26467 11.6777L10.8768 15.597C11.4143 16.1231 12.2145 16.1231 12.7111 15.6264L13.0754 15.2683C13.3699 14.9785 13.6981 14.6556 14.0516 14.3075C15.0614 13.313 16.0713 12.3169 17.014 11.3848L17.0543 11.3449C18.7291 9.68869 20.0004 8.42365 20.712 7.70223C21.0998 7.30904 21.0954 6.67589 20.7022 6.28805C20.309 5.90022 19.6759 5.90457 19.2881 6.29777C18.5843 7.01131 17.3169 8.27244 15.648 9.92281L15.6077 9.96263C14.6662 10.8937 13.6572 11.8889 12.6483 12.8825L11.8329 13.6851L8.73534 10.3223Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "time") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      width: "24",
      height: "24",
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path d="M13 6C13 5.44772 12.5523 5 12 5C11.4477 5 11 5.44772 11 6V12C11 12.2652 11.1054 12.5196 11.2929 12.7071L13.7929 15.2071C14.1834 15.5976 14.8166 15.5976 15.2071 15.2071C15.5976 14.8166 15.5976 14.1834 15.2071 13.7929L13 11.5858V6Z" fill="currentColor"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "un_checked") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      fill: "white",
      viewbox: "0 0 16 16"
    }, _attrs))}><path d="M12.207 4.793a1 1 0 010 1.414l-5 5a1 1 0 01-1.414 0l-2-2a1 1 0 011.414-1.414L6.5 9.086l4.293-4.293a1 1 0 011.414 0z"></path></svg>`);
  } else if ($props.name === "users") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M319.9 320c57.41 0 103.1-46.56 103.1-104c0-57.44-46.54-104-103.1-104c-57.41 0-103.1 46.56-103.1 104C215.9 273.4 262.5 320 319.9 320zM319.9 144c39.68 0 71.96 32.3 71.96 72S359.5 288 319.9 288S247.9 255.7 247.9 216S280.2 144 319.9 144zM496 192c-10.8 0-21.38 2.342-31.47 6.971c-7.74 3.551-12.13 12.51-9.143 20.48c3.336 8.883 13.51 12.88 21.86 8.889C483.3 225.5 489.6 224 496 224h65.08c16.65 0 31.24 9.439 39.55 23.6C603.6 252.7 608.8 256 614.7 256c12.42 0 19.93-13.48 13.7-24.22C614.5 207.1 589.6 192 561.1 192H496zM512 160c44.18 0 80-35.82 80-80S556.2 0 512 0c-44.18 0-80 35.82-80 80S467.8 160 512 160zM512 32c26.47 0 48 21.53 48 48S538.5 128 512 128s-48-21.53-48-48S485.5 32 512 32zM624.5 397.2l-10.02-5.828c.3594-4.891 .3594-9.781 0-14.66l9.531-5.562c8.844-4.766 13.17-15.28 10.2-25.22c-5.672-18.02-15.44-34.89-28.08-48.55c-6.703-7.516-17.92-9.266-26.64-4.25l-9.984 5.766c-4.047-2.734-8.266-5.172-12.64-7.297V279.1c0-10.19-7.234-18.98-16.77-20.83c-18.61-4.188-38.11-4.156-55.88-.0938c-9.922 1.922-17.14 10.72-17.14 20.92v11.61c-4.375 2.125-8.609 4.562-12.66 7.297l-9.75-5.609c-8.547-5.156-19.73-3.578-26.75 3.859C405 311.1 395.3 328 389.7 346.1c-2.906 9.719 1.172 19.94 9.688 24.73l10.06 5.859c-.3281 4.859-.3281 9.734 0 14.59L399.9 396.9c-8.953 4.812-13.12 15.09-10.14 25.12c5.484 17.81 15.22 34.7 28.31 48.97c6.859 7.281 17.73 8.906 26.31 3.938l10.09-5.797c4.031 2.734 8.266 5.172 12.64 7.297v11.61c0 10.2 7.219 19 16.7 20.83C493.2 510.1 502.7 512 512.2 512c9.375 0 18.68-1.016 27.49-3.047c9.969-1.938 17.2-10.73 17.2-20.92v-11.59c4.375-2.125 8.594-4.562 12.64-7.297l9.688 5.594c8.812 5.281 20.11 3.578 26.75-3.859c12.83-13.88 22.59-30.75 28.33-48.98C637.2 412.2 632.9 401.7 624.5 397.2zM581.6 371.2c1.578 8.406 1.578 17.28 0 25.69l-2.094 11.11l21.38 12.44c-3.297 7.953-7.672 15.48-12.98 22.38l-21.28-12.3l-8.609 7.312c-6.688 5.688-14.22 10.05-22.39 12.92l-10.69 3.766v24.67c-8.438 1.094-17.09 1.094-25.78-.0313v-24.62l-10.67-3.781c-8.172-2.875-15.72-7.234-22.39-12.92l-8.578-7.297l-21.38 12.3c-5.359-6.938-9.75-14.52-12.97-22.41L444.3 408l-1.969-11c-1.516-8.5-1.516-17.5 0-26L444.3 360l-21.22-12.38c3.25-7.984 7.641-15.58 12.94-22.42l21.41 12.31l8.578-7.297c6.672-5.688 14.22-10.05 22.39-12.92l10.67-3.781V288.9c8.406-1.156 17.06-1.141 25.78 .0469v24.62l10.69 3.766c8.172 2.875 15.7 7.234 22.39 12.92l8.609 7.312l21.3-12.3c5.297 6.859 9.688 14.42 12.97 22.36l-21.38 12.45L581.6 371.2zM128 160c44.18 0 80-35.82 80-80S172.2 0 128 0C83.82 0 48 35.82 48 80S83.82 160 128 160zM128 32c26.47 0 48 21.53 48 48S154.5 128 128 128S80 106.5 80 80S101.5 32 128 32zM384 480H160.2c3.021-53.41 51.19-96 109.1-96H336c8.836 0 16-7.164 16-16c0-8.838-7.164-16-16-16H270.1C191.6 352 128 411.7 128 485.3C128 500.1 140.7 512 156.4 512H384c8.836 0 16-7.164 16-16C400 487.2 392.8 480 384 480zM512 336c-26.47 0-48 21.53-48 48s21.53 48 48 48s48-21.53 48-48S538.5 336 512 336zM512 400c-8.828 0-16-7.172-16-16s7.172-16 16-16s16 7.172 16 16S520.8 400 512 400zM162.8 228.3c7.938 3.797 17.53 .375 21.31-7.594c3.797-7.969 .3906-17.52-7.594-21.31C166.1 194.5 155.2 192 144 192H78.92C35.41 192 0 229.1 0 274.7V288c0 8.844 7.156 16 16 16S32 296.8 32 288V274.7C32 246.7 53.05 224 78.92 224H144C150.4 224 156.7 225.5 162.8 228.3z"></path></svg>`);
  } else if ($props.name === "all_users") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M83.2 128C83.2 92.65 111.9 64 147.2 64C182.5 64 211.2 92.65 211.2 128C211.2 163.3 182.5 192 147.2 192C111.9 192 83.2 163.3 83.2 128V128zM147.2 160C164.9 160 179.2 145.7 179.2 128C179.2 110.3 164.9 96 147.2 96C129.5 96 115.2 110.3 115.2 128C115.2 145.7 129.5 160 147.2 160zM435.2 128C435.2 92.65 463.9 64 499.2 64C534.5 64 563.2 92.65 563.2 128C563.2 163.3 534.5 192 499.2 192C463.9 192 435.2 163.3 435.2 128V128zM499.2 160C516.9 160 531.2 145.7 531.2 128C531.2 110.3 516.9 96 499.2 96C481.5 96 467.2 110.3 467.2 128C467.2 145.7 481.5 160 499.2 160V160zM177.6 352C177.6 298.1 220.6 256 273.6 256H369.6C422.6 256 465.6 298.1 465.6 352C465.6 369.7 451.3 384 433.6 384H209.6C191.9 384 177.6 369.7 177.6 352V352zM273.6 288C238.3 288 209.6 316.7 209.6 352H433.6C433.6 316.7 404.9 288 369.6 288H273.6zM241.6 144C241.6 99.82 277.4 64 321.6 64C365.8 64 401.6 99.82 401.6 144C401.6 188.2 365.8 224 321.6 224C277.4 224 241.6 188.2 241.6 144V144zM321.6 192C348.1 192 369.6 170.5 369.6 144C369.6 117.5 348.1 96 321.6 96C295.1 96 273.6 117.5 273.6 144C273.6 170.5 295.1 192 321.6 192zM64 304C64 312.8 56.84 320 48 320C39.16 320 32 312.8 32 304V288C32 252.7 60.65 224 96 224H184C192.8 224 200 231.2 200 240C200 248.8 192.8 256 184 256H96C78.33 256 64 270.3 64 288V304zM456 256C447.2 256 440 248.8 440 240C440 231.2 447.2 224 456 224H544C579.3 224 608 252.7 608 288V304C608 312.8 600.8 320 592 320C583.2 320 576 312.8 576 304V288C576 270.3 561.7 256 544 256H456zM624 448C632.8 448 640 455.2 640 464C640 472.8 632.8 480 624 480H16C7.164 480 0 472.8 0 464C0 455.2 7.164 448 16 448H624z"></path></svg>`);
  } else if ($props.name === "pending_users") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M32 128C32 136.8 24.84 144 16 144C7.164 144 0 136.8 0 128V24C0 10.75 10.75 0 24 0H128C136.8 0 144 7.164 144 16C144 24.84 136.8 32 128 32H32V128zM608 32H512C503.2 32 496 24.84 496 16C496 7.164 503.2 0 512 0H616C629.3 0 640 10.75 640 24V128C640 136.8 632.8 144 624 144C615.2 144 608 136.8 608 128V32zM144 496C144 504.8 136.8 512 128 512H24C10.75 512 0 501.3 0 488V384C0 375.2 7.164 368 16 368C24.84 368 32 375.2 32 384V480H128C136.8 480 144 487.2 144 496zM608 384C608 375.2 615.2 368 624 368C632.8 368 640 375.2 640 384V488C640 501.3 629.3 512 616 512H512C503.2 512 496 504.8 496 496C496 487.2 503.2 480 512 480H608V384zM384 192C384 227.3 355.3 256 320 256C284.7 256 256 227.3 256 192C256 156.7 284.7 128 320 128C355.3 128 384 156.7 384 192zM320 160C302.3 160 288 174.3 288 192C288 209.7 302.3 224 320 224C337.7 224 352 209.7 352 192C352 174.3 337.7 160 320 160zM360 288C399.8 288 432 320.2 432 360C432 373.3 421.3 384 408 384H232C218.7 384 208 373.3 208 360C208 320.2 240.2 288 280 288H360zM280 320C260.6 320 244.5 333.7 240.8 352H399.2C395.5 333.7 379.4 320 360 320H280zM223.8 176C223.8 202.5 202.3 224 175.8 224C149.3 224 127.8 202.5 127.8 176C127.8 149.5 149.3 128 175.8 128C202.3 128 223.8 149.5 223.8 176zM175.8 160C166.1 160 159.8 167.2 159.8 176C159.8 184.8 166.1 192 175.8 192C184.7 192 191.8 184.8 191.8 176C191.8 167.2 184.7 160 175.8 160zM128 320C128 328.8 120.8 336 112 336C103.2 336 96 328.8 96 320V312C96 281.1 121.1 256 152 256H208C216.8 256 224 263.2 224 272C224 280.8 216.8 288 208 288H152C138.7 288 128 298.7 128 312V320zM464.2 224C437.7 224 416.2 202.5 416.2 176C416.2 149.5 437.7 128 464.2 128C490.7 128 512.2 149.5 512.2 176C512.2 202.5 490.7 224 464.2 224zM480.2 176C480.2 167.2 473 160 464.2 160C455.3 160 448.2 167.2 448.2 176C448.2 184.8 455.3 192 464.2 192C473 192 480.2 184.8 480.2 176zM432 288C423.2 288 416 280.8 416 272C416 263.2 423.2 256 432 256H488C518.9 256 544 281.1 544 312V320C544 328.8 536.8 336 528 336C519.2 336 512 328.8 512 320V312C512 298.7 501.3 288 488 288H432z"></path></svg>`);
  } else if ($props.name === "user_plus") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 640 512"
    }, _attrs))}><path d="M274.7 304H173.3C77.61 304 0 381.6 0 477.3C0 496.5 15.52 512 34.66 512h378.7C432.5 512 448 496.5 448 477.3C448 381.6 370.4 304 274.7 304zM413.3 480H34.66C33.2 480 32 478.8 32 477.3C32 399.4 95.4 336 173.3 336H274.7C352.6 336 416 399.4 416 477.3C416 478.8 414.8 480 413.3 480zM224 256c70.7 0 128-57.31 128-128S294.7 0 224 0C153.3 0 96 57.31 96 128S153.3 256 224 256zM224 32c52.94 0 96 43.06 96 96c0 52.93-43.06 96-96 96S128 180.9 128 128C128 75.06 171.1 32 224 32zM624 208h-64v-64C560 135.2 552.8 128 544 128s-16 7.156-16 16v64h-64C455.2 208 448 215.2 448 224s7.156 16 16 16h64v64c0 8.844 7.156 16 16 16s16-7.156 16-16v-64h64C632.8 240 640 232.8 640 224S632.8 208 624 208z"></path></svg>`);
  } else if ($props.name === "types") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 448 512" }, _attrs))}><path d="M96 360c-13.25 0-24 10.74-24 24c0 13.25 10.75 24 24 24c13.26 0 24-10.75 24-24C120 370.7 109.3 360 96 360zM352 368H176C167.2 368 160 375.2 160 384s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 368 352 368zM101.3 288c4.094 0 8.188-1.562 11.31-4.688l58.67-58.67c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L101.3 249.4L83.31 231.4c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62l29.33 29.33C93.14 286.4 97.23 288 101.3 288zM96 152c13.26 0 24-10.75 24-24c0-13.26-10.74-24-24-24C82.75 104 72 114.7 72 128C72 141.3 82.75 152 96 152zM352 240H208C199.2 240 192 247.2 192 256s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 240 352 240zM384 0H64C28.65 0 0 28.65 0 64v384c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V64C448 28.65 419.3 0 384 0zM416 448c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V64c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V448zM352 112H176C167.2 112 160 119.2 160 128s7.156 16 16 16H352c8.844 0 16-7.156 16-16S360.8 112 352 112z"></path></svg>`);
  } else if ($props.name === "priorities") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 448 512" }, _attrs))}><path d="M439.6 391.6l-68.98-79.59h15.2c25.59 0 39.5-29.17 23.19-48.48l-60.86-71.51h10.77c21.28 0 32.9-22.5 19.28-37.31l-134.9-146.5C238.3 2.796 231.2 0 224 0S209.7 2.799 204.7 8.236L69.93 154.7C56.34 169.5 67.93 192 89.21 192h10.73L39.03 263.5C22.72 282.9 36.62 312 62.22 312h15.2l-68.98 79.59c-18.1 21.91-3.811 56.4 24.69 56.4L208 447.1V496c0 8.844 7.269 16 16.11 16S240 504.8 240 496v-48l174.8 .0133C443.4 448 458.5 413.4 439.6 391.6zM414.8 415.1L240 416v-57.38l43.31-43.31c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0L240 313.4V176c0-8.844-7.157-16.01-16-16.01S208 167.2 208 176v80.01L188.8 230.4C183.5 223.3 173.5 221.9 166.4 227.2C159.3 232.5 157.9 242.5 163.2 249.6L208 309.3v106.7l-175.1 .0039c-.1934-.127-.7109-.8008-.8379-1.717c-.0957-.6934 .0469-1.115 .5938-1.748l114.9-132.6l-80.48-.002l102.2-120H108.5l115.5-125.6l115.6 125.6h-60.7l102.1 120H300.6l114.9 132.6c.457 .5273 .6562 .918 .5469 1.701C415.8 415.2 415.3 415.9 414.8 415.1z"></path></svg>`);
  } else if ($props.name === "departments") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M320 344C320 330.7 330.7 320 344 320H392C405.3 320 416 330.7 416 344V392C416 405.3 405.3 416 392 416H344C330.7 416 320 405.3 320 392V344zM384 384V352H352V384H384zM320 88C320 74.75 330.7 64 344 64H392C405.3 64 416 74.75 416 88V136C416 149.3 405.3 160 392 160H344C330.7 160 320 149.3 320 136V88zM352 96V128H384V96H352zM344 288C330.7 288 320 277.3 320 264V216C320 202.7 330.7 192 344 192H392C405.3 192 416 202.7 416 216V264C416 277.3 405.3 288 392 288H344zM352 224V256H384V224H352zM448 0C483.3 0 512 28.65 512 64V448C512 483.3 483.3 512 448 512H288C252.7 512 224 483.3 224 448V64C224 28.65 252.7 0 288 0H448zM448 32H288C270.3 32 256 46.33 256 64V448C256 465.7 270.3 480 288 480H448C465.7 480 480 465.7 480 448V64C480 46.33 465.7 32 448 32zM176 160H64C46.33 160 32 174.3 32 192V448C32 465.7 46.33 480 64 480H192C200.8 480 208 487.2 208 496C208 504.8 200.8 512 192 512H64C28.65 512 0 483.3 0 448V192C0 156.7 28.65 128 64 128H176C184.8 128 192 135.2 192 144C192 152.8 184.8 160 176 160zM136 320C149.3 320 160 330.7 160 344V392C160 405.3 149.3 416 136 416H88C74.75 416 64 405.3 64 392V344C64 330.7 74.75 320 88 320H136zM128 384V352H96V384H128zM136 192C149.3 192 160 202.7 160 216V264C160 277.3 149.3 288 136 288H88C74.75 288 64 277.3 64 264V216C64 202.7 74.75 192 88 192H136zM128 256V224H96V256H128z"></path></svg>`);
  } else if ($props.name === "email_template") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 640 512" }, _attrs))}><path d="M32 128V167.9L227.6 311.3C244.5 323.7 267.5 323.7 284.4 311.3L329.8 278.1C324.6 292.8 321.4 308.4 320.4 324.6L303.3 337.1C275.1 357.8 236.9 357.8 208.7 337.1L32 207.6V384C32 401.7 46.33 416 64 416H339.2C345 427.4 352.1 438.2 360.2 448H64C28.65 448 0 419.3 0 384V128C0 92.65 28.65 64 64 64H448C483.3 64 512 92.65 512 128V160.7C506.7 160.2 501.4 160 496 160C490.6 160 485.3 160.2 480 160.7V128C480 110.3 465.7 96 448 96H64C46.33 96 32 110.3 32 128L32 128zM563.3 292.7C569.6 298.9 569.6 309.1 563.3 315.3L491.3 387.3C485.1 393.6 474.9 393.6 468.7 387.3L428.7 347.3C422.4 341.1 422.4 330.9 428.7 324.7C434.9 318.4 445.1 318.4 451.3 324.7L480 353.4L540.7 292.7C546.9 286.4 557.1 286.4 563.3 292.7H563.3zM352 336C352 256.5 416.5 192 496 192C575.5 192 640 256.5 640 336C640 415.5 575.5 480 496 480C416.5 480 352 415.5 352 336zM496 448C557.9 448 608 397.9 608 336C608 274.1 557.9 224 496 224C434.1 224 384 274.1 384 336C384 397.9 434.1 448 496 448z"></path></svg>`);
  } else if ($props.name === "notes") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M368 32C376.8 32 384 24.84 384 16S376.8 0 368 0H96C42.98 0 0 42.98 0 96v272C0 376.8 7.164 384 16 384S32 376.8 32 368V96c0-35.34 28.66-64 64-64H368zM416 96H160c-35.35 0-64 28.65-64 63.1L96 415.1C96 451.3 124.7 480 160 480h165.5c16.97 0 33.25-6.742 45.26-18.75l90.51-90.51C473.3 358.7 480 342.5 480 325.5L480 160C480 124.7 451.4 96 416 96zM352 434.7V368c0-8.828 7.188-16 16-16h66.75L352 434.7zM448 320h-80c-26.47 0-48 21.53-48 48V448H160c-17.64 0-32-14.36-32-32V160c0-17.64 14.36-32 32-32h256c17.64 0 32 14.36 32 32V320z"></path></svg>`);
  } else if ($props.name === "plus") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 448 512" }, _attrs))}><path d="M432 256C432 264.8 424.8 272 416 272h-176V448c0 8.844-7.156 16.01-16 16.01S208 456.8 208 448V272H32c-8.844 0-16-7.15-16-15.99C16 247.2 23.16 240 32 240h176V64c0-8.844 7.156-15.99 16-15.99S240 55.16 240 64v176H416C424.8 240 432 247.2 432 256z"></path></svg>`);
  } else if ($props.name === "move_left") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 448 512"
    }, _attrs))}><path d="M336 240H150.6l68.69-68.69c6.25-6.25 6.25-16.38 0-22.62s-16.38-6.25-22.62 0l-96 96C97.56 247.8 96 251.9 96 256s1.562 8.184 4.688 11.31l96 96c6.25 6.25 16.38 6.25 22.62 0s6.25-16.38 0-22.62L150.6 272H336c8.844 0 16-7.154 16-15.1C352 247.2 344.8 240 336 240zM384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM416 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V416z"></path></svg>`);
  } else if ($props.name === "move_right") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 448 512"
    }, _attrs))}><path d="M251.3 148.7c-6.25-6.25-16.38-6.25-22.62 0s-6.25 16.38 0 22.62L297.4 240H112C103.2 240 96 247.2 96 255.1C96 264.8 103.2 272 112 272h185.4l-68.69 68.69c-6.25 6.25-6.25 16.38 0 22.62s16.38 6.25 22.62 0l96-96C350.4 264.2 352 260.1 352 255.1s-1.562-8.184-4.688-11.31L251.3 148.7zM384 32H64C28.65 32 0 60.65 0 96v320c0 35.35 28.65 64 64 64h320c35.35 0 64-28.65 64-64V96C448 60.65 419.3 32 384 32zM416 416c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V96c0-17.64 14.36-32 32-32h320c17.64 0 32 14.36 32 32V416z"></path></svg>`);
  } else if ($props.name === "dash") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 320 512" }, _attrs))}><path d="M320 256C320 264.8 312.8 272 304 272h-288C7.156 272 0 264.8 0 256C0 247.2 7.156 240 16 240h288C312.8 240 320 247.2 320 256z"></path></svg>`);
  } else if ($props.name === "check") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M235.3 331.3C229.1 337.6 218.9 337.6 212.7 331.3L148.7 267.3C142.4 261.1 142.4 250.9 148.7 244.7C154.9 238.4 165.1 238.4 171.3 244.7L224 297.4L340.7 180.7C346.9 174.4 357.1 174.4 363.3 180.7C369.6 186.9 369.6 197.1 363.3 203.3L235.3 331.3zM512 256C512 397.4 397.4 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256zM256 32C132.3 32 32 132.3 32 256C32 379.7 132.3 480 256 480C379.7 480 480 379.7 480 256C480 132.3 379.7 32 256 32z"></path></svg>`);
  } else if ($props.name === "post") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 576 512" }, _attrs))}><path d="M128 64H320V16C320 7.164 327.2 0 336 0C344.8 0 352 7.164 352 16V64H384C419.3 64 448 92.65 448 128V192H32V448C32 465.7 46.33 480 64 480H258.5L257.4 484.2C255.1 493.6 255.7 503.2 258.8 512H64C28.65 512 0 483.3 0 448V128C0 92.65 28.65 64 64 64H96V16C96 7.164 103.2 0 112 0C120.8 0 128 7.164 128 16V64zM32 128V160H416V128C416 110.3 401.7 96 384 96H64C46.33 96 32 110.3 32 128zM240 352C248.8 352 256 359.2 256 368C256 376.8 248.8 384 240 384H112C103.2 384 96 376.8 96 368C96 359.2 103.2 352 112 352H240zM96 272C96 263.2 103.2 256 112 256H336C344.8 256 352 263.2 352 272C352 280.8 344.8 288 336 288H112C103.2 288 96 280.8 96 272zM473.5 241.4C492.3 222.6 522.7 222.6 541.4 241.4L558.8 258.7C577.5 277.5 577.5 307.9 558.8 326.6L405.1 480.3C398.9 486.5 391.2 490.8 382.8 492.1L307.9 511.7C302.4 513 296.7 511.4 292.7 507.5C288.7 503.5 287.1 497.7 288.5 492.3L307.2 417.4C309.3 408.9 313.7 401.2 319.8 395.1L473.5 241.4zM518.8 264C512.5 257.8 502.4 257.8 496.2 264L471.3 288.8L511.3 328.8L536.2 303.1C542.4 297.7 542.4 287.6 536.2 281.4L518.8 264zM338.2 425.1L325.1 474.2L375 461.9C377.8 461.2 380.4 459.8 382.4 457.7L488.7 351.4L448.7 311.5L342.5 417.7C340.4 419.8 338.9 422.3 338.2 425.1H338.2z"></path></svg>`);
  } else if ($props.name === "no_image") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      x: "0px",
      y: "0px",
      width: "621.127px",
      height: "621.127px",
      viewBox: "89.437 -10.563 621.127 621.127",
      "enable-background": "new 89.437 -10.563 621.127 621.127",
      "xml:space": "preserve"
    }, _attrs))}><rect x="109.437" y="10" fill="#DADBDC" width="581.127" height="580.562"></rect><g transform="translate(-5.000000, -5.000000)"><path fill="#F3F4F4" d="M94.437-5.563h621.127v621.127H94.437V-5.563L94.437-5.563z M475.346,254.057l-8.185-47.831L299.63,235.641 l24.553,139.908l16.627-2.813v12.021h170.087V254.057H475.346L475.346,254.057z M340.811,358.666l-5.371,1.021l-19.95-112.794 l140.419-24.812l5.628,31.974H340.811V358.666L340.811,358.666L340.811,358.666z M497.087,370.943H354.621V267.868h142.466V370.943 L497.087,370.943z M363.828,277.075v76.474l28.903-19.181l17.903,11.252l43.48-47.829l5.629,2.301l28.134,32.485v-55.502H363.828 L363.828,277.075L363.828,277.075z M391.451,310.068c-6.648,0-12.276-5.626-12.276-12.277c0-6.65,5.628-12.279,12.276-12.279 c6.651,0,12.276,5.626,12.276,12.279C403.729,304.442,398.102,310.068,391.451,310.068L391.451,310.068L391.451,310.068z"></path></g></svg>`);
  } else if ($props.name === "filter") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      focusable: "false",
      viewBox: "0 0 24 24",
      xmlns: "http://www.w3.org/2000/svg"
    }, _attrs))}><path fill-rule="evenodd" clip-rule="evenodd" d="M4.61799 6C3.87461 6 3.39111 6.78231 3.72356 7.44721L3.99996 8H20L20.2763 7.44721C20.6088 6.78231 20.1253 6 19.3819 6H4.61799ZM10.8618 17.7236C10.9465 17.893 11.1196 18 11.309 18H12.6909C12.8803 18 13.0535 17.893 13.1382 17.7236L14 16H9.99996L10.8618 17.7236ZM17 13H6.99996L5.99996 11H18L17 13Z" fill="currentColor"></path></svg>`);
  } else if ($props.name === "undo") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M480 256c0 123.5-100.4 223.9-223.9 223.9c-69.41 0-133.9-31.3-176.7-86.05c-5.438-6.938-4.203-17 2.75-22.44c6.984-5.531 17.03-4.25 22.47 2.75C141.3 421.1 196.5 448 256 448c105.9 0 192-86.13 192-192s-86.13-192-192-192C187.1 64 124.5 100.7 90.15 160H176C184.8 160 192 167.2 192 176S184.8 192 176 192h-128C39.16 192 32 184.8 32 176v-128C32 39.16 39.16 32 48 32S64 39.16 64 48v93.56C104.4 73.87 176.6 32.11 256.1 32.11C379.6 32.11 480 132.5 480 256z"></path></svg>`);
  } else if ($props.name === "to_up") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 384 512" }, _attrs))}><path d="M6.625 215.5l168-176C179.2 34.7 185.4 32.02 192 32.02s12.84 2.688 17.38 7.438l168 176c9.125 9.594 8.781 24.78-.8125 33.94c-9.5 9.156-24.75 8.812-33.94-.8125L216 115.9V456c0 13.25-10.75 23.1-23.1 23.1S168 469.3 168 456V115.9l-126.6 132.7C32.22 258.2 16.97 258.5 7.438 249.4C-2.156 240.2-2.5 225 6.625 215.5z"></path></svg>`);
  } else if ($props.name === "angle-up") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 384 512" }, _attrs))}><path d="M192 160c1.1 0 3.969 .7344 5.531 2.219l151.1 144c3.187 3.047 3.312 8.125 .25 11.31c-3.094 3.188-8.156 3.281-11.31 .25L192 179.1L45.53 317.8c-3.219 3.031-8.281 2.938-11.31-.25c-3.062-3.188-2.937-8.266 .25-11.31l151.1-144C188 160.7 190 160 192 160z"></path></svg>`);
  } else if ($props.name === "gear") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M168 255.1C168 207.4 207.4 167.1 256 167.1C304.6 167.1 344 207.4 344 255.1C344 304.6 304.6 344 256 344C207.4 344 168 304.6 168 255.1zM256 199.1C225.1 199.1 200 225.1 200 255.1C200 286.9 225.1 311.1 256 311.1C286.9 311.1 312 286.9 312 255.1C312 225.1 286.9 199.1 256 199.1zM65.67 230.6L25.34 193.8C14.22 183.7 11.66 167.2 19.18 154.2L49.42 101.8C56.94 88.78 72.51 82.75 86.84 87.32L138.8 103.9C152.2 93.56 167 84.96 182.8 78.43L194.5 25.16C197.7 10.47 210.7 0 225.8 0H286.2C301.3 0 314.3 10.47 317.5 25.16L329.2 78.43C344.1 84.96 359.8 93.56 373.2 103.9L425.2 87.32C439.5 82.75 455.1 88.78 462.6 101.8L492.8 154.2C500.3 167.2 497.8 183.7 486.7 193.8L446.3 230.6C447.4 238.9 448 247.4 448 255.1C448 264.6 447.4 273.1 446.3 281.4L486.7 318.2C497.8 328.3 500.3 344.8 492.8 357.8L462.6 410.2C455.1 423.2 439.5 429.2 425.2 424.7L373.2 408.1C359.8 418.4 344.1 427 329.2 433.6L317.5 486.8C314.3 501.5 301.3 512 286.2 512H225.8C210.7 512 197.7 501.5 194.5 486.8L182.8 433.6C167 427 152.2 418.4 138.8 408.1L86.84 424.7C72.51 429.2 56.94 423.2 49.42 410.2L19.18 357.8C11.66 344.8 14.22 328.3 25.34 318.2L65.67 281.4C64.57 273.1 64 264.6 64 255.1C64 247.4 64.57 238.9 65.67 230.6V230.6zM158.4 129.2L145.1 139.5L77.13 117.8L46.89 170.2L99.58 218.2L97.39 234.8C96.47 241.7 96 248.8 96 255.1C96 263.2 96.47 270.3 97.39 277.2L99.58 293.8L46.89 341.8L77.13 394.2L145.1 372.5L158.4 382.8C169.5 391.4 181.9 398.6 195 403.1L210.5 410.4L225.8 480H286.2L301.5 410.4L316.1 403.1C330.1 398.6 342.5 391.4 353.6 382.8L366.9 372.5L434.9 394.2L465.1 341.8L412.4 293.8L414.6 277.2C415.5 270.3 416 263.2 416 256C416 248.8 415.5 241.7 414.6 234.8L412.4 218.2L465.1 170.2L434.9 117.8L366.9 139.5L353.6 129.2C342.5 120.6 330.1 113.4 316.1 108L301.5 101.6L286.2 32H225.8L210.5 101.6L195 108C181.9 113.4 169.5 120.6 158.4 129.2H158.4z"></path></svg>`);
  } else if ($props.name === "phone") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M484.6 330.6C484.6 330.6 484.6 330.6 484.6 330.6l-101.8-43.66c-18.5-7.688-40.2-2.375-52.75 13.08l-33.14 40.47C244.2 311.8 200.3 267.9 171.6 215.2l40.52-33.19c15.67-12.92 20.83-34.16 12.84-52.84L181.4 27.37C172.7 7.279 150.8-3.737 129.6 1.154L35.17 23.06C14.47 27.78 0 45.9 0 67.12C0 312.4 199.6 512 444.9 512c21.23 0 39.41-14.44 44.17-35.13l21.8-94.47C515.7 361.1 504.7 339.3 484.6 330.6zM457.9 469.7c-1.375 5.969-6.844 10.31-12.98 10.31c-227.7 0-412.9-185.2-412.9-412.9c0-6.188 4.234-11.48 10.34-12.88l94.41-21.91c1-.2344 2-.3438 2.984-.3438c5.234 0 10.11 3.094 12.25 8.031l43.58 101.7C197.9 147.2 196.4 153.5 191.8 157.3L141.3 198.7C135.6 203.4 133.8 211.4 137.1 218.1c33.38 67.81 89.11 123.5 156.9 156.9c6.641 3.313 14.73 1.531 19.44-4.219l41.39-50.5c3.703-4.563 10.16-6.063 15.5-3.844l101.6 43.56c5.906 2.563 9.156 8.969 7.719 15.22L457.9 469.7z"></path></svg>`);
  } else if ($props.name === "email") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M0 128C0 92.65 28.65 64 64 64H448C483.3 64 512 92.65 512 128V384C512 419.3 483.3 448 448 448H64C28.65 448 0 419.3 0 384V128zM32 128V167.9L227.6 311.3C244.5 323.7 267.5 323.7 284.4 311.3L480 167.9V128C480 110.3 465.7 96 448 96H63.1C46.33 96 31.1 110.3 31.1 128H32zM32 207.6V384C32 401.7 46.33 416 64 416H448C465.7 416 480 401.7 480 384V207.6L303.3 337.1C275.1 357.8 236.9 357.8 208.7 337.1L32 207.6z"></path></svg>`);
  } else if ($props.name === "user") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      "aria-hidden": "true",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      viewBox: "0 0 20 20"
    }, _attrs))}><path d="M10 0a10 10 0 1 0 10 10A10.011 10.011 0 0 0 10 0Zm0 5a3 3 0 1 1 0 6 3 3 0 0 1 0-6Zm0 13a8.949 8.949 0 0 1-4.951-1.488A3.987 3.987 0 0 1 9 13h2a3.987 3.987 0 0 1 3.951 3.512A8.949 8.949 0 0 1 10 18Z"></path></svg>`);
  } else if ($props.name === "security") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M231 7.838C247 1.065 265.1 1.066 281 7.84L457.7 82.79C479.7 92.12 496.2 113.8 496 139.1C495.5 239.2 454.7 420.7 282.4 503.2C265.7 511.1 246.3 511.1 229.6 503.2C57.26 420.7 16.49 239.2 16 139.1C15.87 113.8 32.32 92.12 54.3 82.79L231 7.838zM268.5 37.3C260.5 33.91 251.5 33.91 243.5 37.3L66.79 112.3C55.51 117 47.94 127.7 48 139.8C48.46 233.8 87.33 399.6 243.4 474.3C251.4 478.1 260.6 478.1 268.6 474.3C424.7 399.6 463.6 233.8 464 139.8C464.1 127.7 456.5 117 445.2 112.3L268.5 37.3z"></path></svg>`);
  } else if ($props.name === "airplay") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 576 512" }, _attrs))}><path d="M496 32h-416C35.88 32 0 67.88 0 112v224C0 380.1 35.88 416 80 416C88.84 416 96 408.8 96 400S88.84 384 80 384C53.53 384 32 362.5 32 336v-224C32 85.53 53.53 64 80 64h416C522.5 64 544 85.53 544 112v224c0 26.47-21.53 48-48 48c-8.844 0-16 7.156-16 16s7.156 16 16 16c44.13 0 80-35.88 80-80v-224C576 67.88 540.1 32 496 32zM310.6 297.4c-12.5-12.5-32.86-12.5-45.36 0l-127.1 128C117.3 445.5 131.7 480 160 480h255.9c28.37 0 42.73-34.5 22.62-54.63L310.6 297.4zM160 448l127.1-128L415.1 448H160z"></path></svg>`);
  } else if ($props.name === "compass") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M298.3 182.2C285.5 188.5 271.2 192 255.1 192C240.8 192 226.5 188.5 213.7 182.2L142.2 307.4C176.1 325.6 214.8 336 255.1 336C344.8 336 422.4 287.8 463.9 215.1C468.3 208.3 478.1 205.7 485.8 210.2C493.4 214.6 496 224.4 491.6 232C444.6 313.3 356.7 368 255.1 368C209 368 164.9 356.1 126.3 335.2L29.89 503.9C25.51 511.6 15.73 514.3 8.06 509.9C.3882 505.5-2.277 495.7 2.107 488.1L99.15 318.2C67.07 295.6 40.13 266.1 20.4 232C15.97 224.4 18.59 214.6 26.24 210.2C33.88 205.7 43.67 208.3 48.1 215.1C65.01 245.2 87.91 270.6 115.1 290.3L187.6 163.4C170.5 146.1 159.1 122.3 159.1 96C159.1 42.98 202.1 0 255.1 0C309 0 352 42.98 352 96C352 122.3 341.5 146.1 324.4 163.4L372.7 248.1C377.1 255.7 374.5 265.5 366.8 269.9C359.1 274.3 349.3 271.6 344.1 263.9L298.3 182.2zM255.1 32C220.7 32 191.1 60.65 191.1 96C191.1 131.3 220.7 160 255.1 160C291.3 160 320 131.3 320 96C320 60.65 291.3 32 255.1 32zM408.1 375.9C404.6 368.3 407.2 358.5 414.9 354.1C422.6 349.7 432.4 352.4 436.7 360.1L509.9 488.1C514.3 495.7 511.6 505.5 503.9 509.9C496.3 514.3 486.5 511.6 482.1 503.9L408.1 375.9z"></path></svg>`);
  } else if ($props.name === "aperture") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM458.1 160H237.5l70.27-121.7C374.3 54.12 429.3 99.59 458.1 160zM292.9 320H219.1L182.1 256L219.1 192h73.89l36.95 64L292.9 320zM256 32c6.059 0 12.01 .4336 17.95 .9082L163.6 223.1L93.41 102.4C134.3 59.15 191.1 32 256 32zM71.76 128.9L182.1 320h-140.7C35.37 299.7 32 278.2 32 256C32 208.8 46.75 165 71.76 128.9zM53.92 352h220.5l-70.27 121.7C137.7 457.9 82.74 412.4 53.92 352zM256 480c-6.059 0-12.01-.4336-17.95-.9082l110.3-191.1l70.22 121.6C377.7 452.8 320 480 256 480zM440.2 383.1L329.9 192h140.7C476.6 212.3 480 233.8 480 256C480 303.2 465.3 346.1 440.2 383.1z"></path></svg>`);
  } else if ($props.name === "camera") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M0 416V144C0 108.7 28.65 80 64 80H192L238.9 44.8C250 36.49 263.5 32 277.3 32H448C483.3 32 512 60.65 512 96V416C512 451.3 483.3 480 448 480H64C28.65 480 0 451.3 0 416zM64 112C46.33 112 32 126.3 32 144V224H145.1C167.3 185.7 208.6 160 256 160C303.4 160 344.7 185.7 366.9 224H480V96C480 78.33 465.7 64 448 64H277.3C270.4 64 263.7 66.25 258.1 70.4L211.2 105.6C205.7 109.8 198.9 112 192 112H64zM32 256V416C32 433.7 46.33 448 64 448H448C465.7 448 480 433.7 480 416V256H379.1C382.6 266.2 384 276.1 384 288C384 358.7 326.7 416 256 416C185.3 416 128 358.7 128 288C128 276.1 129.4 266.2 132 256H32zM256 192C202.1 192 160 234.1 160 288C160 341 202.1 384 256 384C309 384 352 341 352 288C352 234.1 309 192 256 192zM64 48C64 39.16 71.16 32 80 32H144C152.8 32 160 39.16 160 48C160 56.84 152.8 64 144 64H80C71.16 64 64 56.84 64 48z"></path></svg>`);
  } else if ($props.name === "palette") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M152 255.1C152 269.3 141.3 279.1 128 279.1C114.7 279.1 104 269.3 104 255.1C104 242.7 114.7 231.1 128 231.1C141.3 231.1 152 242.7 152 255.1zM136 159.1C136 146.7 146.7 135.1 160 135.1C173.3 135.1 184 146.7 184 159.1C184 173.3 173.3 183.1 160 183.1C146.7 183.1 136 173.3 136 159.1zM280 127.1C280 141.3 269.3 151.1 256 151.1C242.7 151.1 232 141.3 232 127.1C232 114.7 242.7 103.1 256 103.1C269.3 103.1 280 114.7 280 127.1zM328 159.1C328 146.7 338.7 135.1 352 135.1C365.3 135.1 376 146.7 376 159.1C376 173.3 365.3 183.1 352 183.1C338.7 183.1 328 173.3 328 159.1zM441.9 319.1H344C317.5 319.1 296 341.5 296 368C296 371.4 296.4 374.7 297 377.9C299.2 388.1 303.5 397.1 307.9 407.8C313.9 421.6 320 435.3 320 449.8C320 481.7 298.4 510.5 266.6 511.8C263.1 511.9 259.5 512 256 512C114.6 512 0 397.4 0 256C0 114.6 114.6 0 256 0C397.4 0 512 114.6 512 256C512 256.9 511.1 257.8 511.1 258.7C511.6 295.2 478.4 320 441.9 320V319.1zM479.1 258.3C479.1 257.6 480 256.8 480 255.1C480 132.3 379.7 31.1 256 31.1C132.3 31.1 32 132.3 32 255.1C32 379.7 132.3 480 256 480C259.1 480 262.2 479.9 265.3 479.8C275.7 479.4 288 469.1 288 449.8C288 444.6 286.1 438 281.1 426.4C280.4 424.9 279.7 423.3 278.1 421.6C274.6 411.9 268.6 398.3 265.7 384.6C264.6 379.2 264 373.6 264 368C264 323.8 299.8 288 344 288H441.9C466.2 288 479.8 272.4 479.1 258.3V258.3z"></path></svg>`);
  } else if ($props.name === "login") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M384 256c0-8.188-3.125-16.38-9.375-22.62l-128-128C237.5 96.22 223.7 93.47 211.8 98.44C199.8 103.4 192 115.1 192 128v64H48C21.49 192 0 213.5 0 240v32C0 298.5 21.49 320 48 320H192v64c0 12.94 7.797 24.62 19.75 29.56c11.97 4.969 25.72 2.219 34.88-6.938l128-128C380.9 272.4 384 264.2 384 256zM224 384V288H48C39.18 288 32 280.8 32 272v-32C32 231.2 39.18 224 48 224H224L223.1 128l128 128L224 384zM432 32h-96C327.2 32 320 39.16 320 48S327.2 64 336 64h96C458.5 64 480 85.53 480 112v288c0 26.47-21.53 48-48 48h-96c-8.844 0-16 7.156-16 16s7.156 16 16 16h96c44.13 0 80-35.88 80-80v-288C512 67.88 476.1 32 432 32z"></path></svg>`);
  } else if ($props.name === "info") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, _attrs))}><path d="M256 0C114.6 0 0 114.6 0 256s114.6 256 256 256s256-114.6 256-256S397.4 0 256 0zM256 480c-123.5 0-224-100.5-224-224s100.5-224 224-224s224 100.5 224 224S379.5 480 256 480zM256 184c13.25 0 24-10.74 24-24c0-13.25-10.75-24-24-24S232 146.7 232 160C232 173.3 242.7 184 256 184zM304 352h-32V240C272 231.2 264.8 224 256 224H224C215.2 224 208 231.2 208 240S215.2 256 224 256h16v96h-32C199.2 352 192 359.2 192 368C192 376.8 199.2 384 208 384h96c8.836 0 16-7.164 16-16C320 359.2 312.8 352 304 352z"></path></svg>`);
  } else if ($props.name === "page") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 384 512" }, _attrs))}><path d="M0 64C0 28.65 28.65 0 64 0H220.1C232.8 0 245.1 5.057 254.1 14.06L369.9 129.9C378.9 138.9 384 151.2 384 163.9V448C384 483.3 355.3 512 320 512H64C28.65 512 0 483.3 0 448V64zM352 192H240C213.5 192 192 170.5 192 144V32H64C46.33 32 32 46.33 32 64V448C32 465.7 46.33 480 64 480H320C337.7 480 352 465.7 352 448V192zM347.3 152.6L231.4 36.69C229.4 34.62 226.8 33.18 224 32.48V144C224 152.8 231.2 160 240 160H351.5C350.8 157.2 349.4 154.6 347.3 152.6z"></path></svg>`);
  } else if ($props.name === "send") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M492.6 226.6L44.6 34.59C40.54 32.85 36.26 31.1 32.02 31.1c-8.623 0-17.1 3.499-23.3 10.05C-.4983 51.81-2.623 66.3 3.377 78.31L96 256l-92.62 177.7c-6 12.02-3.875 26.5 5.344 36.27c6.188 6.547 14.66 10.05 23.28 10.05c4.25 0 8.531-.8438 12.59-2.594L492.6 285.4c11.78-5.031 19.41-16.61 19.41-29.41C511.1 243.2 504.4 231.6 492.6 226.6zM31.98 64.03C31.99 64.01 31.96 64.04 31.98 64.03L442.7 240H123.7L31.98 64.03zM31.75 448.5L123.7 272h318.1L31.75 448.5z"></path></svg>`);
  } else if ($props.name === "send_plan") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M498.1 5.629C492.7 1.891 486.4 0 480 0c-5.461 0-10.94 1.399-15.88 4.223l-448 255.1C5.531 266.3-.6875 277.8 .0625 289.1s8.375 22.86 19.62 27.55l103.2 43.01l61.85 146.5C186.2 510.6 189.2 512 191.1 512c2.059 0 4.071-.8145 5.555-2.24l85.75-82.4l120.4 50.16c4.293 1.793 8.5 2.472 12.29 2.472c6.615 0 12.11-2.093 15.68-4.097c8.594-4.828 14.47-13.31 15.97-23.05l64-415.1C513.5 24.72 508.3 12.58 498.1 5.629zM32 288l380.1-217.2l-288.2 255.5L32 288zM200.7 462.3L151.1 344.9l229.5-203.4l-169.5 233.1c-2.906 4-3.797 9.094-2.438 13.84c1.374 4.75 4.844 8.594 9.438 10.41l34.4 13.76L200.7 462.3zM416.7 443.3l-167.7-66.56l225.7-310.3L416.7 443.3z"></path></svg>`);
  } else if ($props.name === "user_role") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 448 512" }, _attrs))}><path d="M96 128C96 57.31 153.3 0 224 0C294.7 0 352 57.31 352 128C352 198.7 294.7 256 224 256C153.3 256 96 198.7 96 128zM320 128C320 74.98 277 32 224 32C170.1 32 128 74.98 128 128C128 181 170.1 224 224 224C277 224 320 181 320 128zM256 304C264.8 304 272 311.2 272 320C272 328.8 264.8 336 256 336H246.2L266.1 395.8L303.6 320.9C384.7 329.3 448 397.9 448 481.3C448 498.2 434.2 511.1 417.3 511.1H30.72C13.75 511.1 0 498.2 0 481.3C0 397.9 63.28 329.3 144.4 320.9L181.9 395.8L201.8 336H191.1C183.2 336 175.1 328.8 175.1 320C175.1 311.2 183.2 304 191.1 304H256zM224 479.1L245.9 436.2L224 370.6L202.1 436.2L224 479.1zM415.1 479.1C415.4 421.2 375.6 371.8 321.4 356.7L259.8 479.1H415.1zM188.2 479.1L126.6 356.7C72.43 371.8 32.58 421.2 32.01 479.1H188.2z"></path></svg>`);
  } else if ($props.name === "global_setting") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 512 512" }, _attrs))}><path d="M0 416C0 407.2 7.164 400 16 400H81.6C89.01 363.5 121.3 336 160 336C198.7 336 230.1 363.5 238.4 400H496C504.8 400 512 407.2 512 416C512 424.8 504.8 432 496 432H238.4C230.1 468.5 198.7 496 160 496C121.3 496 89.01 468.5 81.6 432H16C7.164 432 0 424.8 0 416V416zM208 416C208 389.5 186.5 368 160 368C133.5 368 112 389.5 112 416C112 442.5 133.5 464 160 464C186.5 464 208 442.5 208 416zM352 176C390.7 176 422.1 203.5 430.4 240H496C504.8 240 512 247.2 512 256C512 264.8 504.8 272 496 272H430.4C422.1 308.5 390.7 336 352 336C313.3 336 281 308.5 273.6 272H16C7.164 272 0 264.8 0 256C0 247.2 7.164 240 16 240H273.6C281 203.5 313.3 176 352 176zM400 256C400 229.5 378.5 208 352 208C325.5 208 304 229.5 304 256C304 282.5 325.5 304 352 304C378.5 304 400 282.5 400 256zM496 80C504.8 80 512 87.16 512 96C512 104.8 504.8 112 496 112H270.4C262.1 148.5 230.7 176 192 176C153.3 176 121 148.5 113.6 112H16C7.164 112 0 104.8 0 96C0 87.16 7.164 80 16 80H113.6C121 43.48 153.3 16 192 16C230.7 16 262.1 43.48 270.4 80H496zM144 96C144 122.5 165.5 144 192 144C218.5 144 240 122.5 240 96C240 69.49 218.5 48 192 48C165.5 48 144 69.49 144 96z"></path></svg>`);
  } else if ($props.name === "image") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 576 512" }, _attrs))}><path d="M160 184c13.26 0 24-10.75 24-24S173.3 136 160 136C146.7 136 136 146.7 136 160S146.7 184 160 184zM346.6 171.9c-11.28-15.81-38.5-15.94-49.1-.0313L252.6 233.3L245.6 224.4C234.2 209.9 208.6 209.8 197.2 224.4L134.2 304.8c-7.123 9.131-8.154 21.55-2.623 31.56C136.8 345.1 147.1 352 158.4 352h259.2c11 0 21.17-5.805 26.54-15.09c0-.0313-.0313 .0313 0 0c5.656-9.883 5.078-21.84-1.578-31.15L346.6 171.9zM162.2 319.9l58.25-75.61l20.09 25.66C244.9 275.5 258.1 280.6 266.1 269.4l54.44-78.75l92.68 129.2H162.2zM512 64H64C28.65 64 0 92.65 0 128v256c0 35.35 28.65 64 64 64h448c35.35 0 64-28.65 64-64V128C576 92.65 547.3 64 512 64zM544 384c0 17.64-14.36 32-32 32H64c-17.64 0-32-14.36-32-32V128c0-17.64 14.36-32 32-32h448c17.64 0 32 14.36 32 32V384z"></path></svg>`);
  } else if ($props.name === "pulse_image") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      "aria-hidden": "true",
      xmlns: "http://www.w3.org/2000/svg",
      fill: "currentColor",
      viewBox: "0 0 20 18"
    }, _attrs))}><path d="M18 0H2a2 2 0 0 0-2 2v14a2 2 0 0 0 2 2h16a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2Zm-5.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3Zm4.376 10.481A1 1 0 0 1 16 15H4a1 1 0 0 1-.895-1.447l3.5-7A1 1 0 0 1 7.468 6a.965.965 0 0 1 .9.5l2.775 4.757 1.546-1.887a1 1 0 0 1 1.618.1l2.541 4a1 1 0 0 1 .028 1.011Z"></path></svg>`);
  } else if ($props.name === "checklist_box") {
    _push(`<svg${ssrRenderAttrs(mergeProps({ viewBox: "0 0 35.6 35.6" }, _attrs))}><circle class="background" cx="17.8" cy="17.8" r="17.8"></circle><circle class="stroke" cx="17.8" cy="17.8" r="14.37"></circle><polyline class="check" points="11.78 18.12 15.55 22.23 25.17 12.87"></polyline></svg>`);
  } else if ($props.name === "checklist_box_2") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      width: "12px",
      height: "9px",
      viewbox: "0 0 12 9"
    }, _attrs))}><polyline points="1 5 4 8 11 1"></polyline></svg>`);
  } else if ($props.name === "comments") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      height: "10px",
      width: "10px",
      xmlns: "http://www.w3.org/2000/svg",
      "xmlns:xlink": "http://www.w3.org/1999/xlink",
      viewBox: "0 0 512 512",
      "xml:space": "preserve"
    }, _attrs))}><g><path class="st0" fill="currentcolor" d="M92.574,294.24V124.336H43.277C19.449,124.336,0,144.213,0,168.467v206.44c0,24.254,19.449,44.133,43.277,44.133h62v45.469c0,3.041,1.824,5.777,4.559,6.932c2.736,1.154,5.957,0.486,8.023-1.641l49.844-50.76h106.494c23.828,0,43.279-19.879,43.279-44.133v-0.061H172.262C128.314,374.846,92.574,338.676,92.574,294.24z"></path><path class="st0" fill="currentcolor" d="M462.717,40H172.26c-27.105,0-49.283,22.59-49.283,50.197v204.037c0,27.61,22.178,50.199,49.283,50.199 h164.668l75.348,76.033c2.399,2.442,6.004,3.172,9.135,1.852c3.133-1.322,5.176-4.434,5.176-7.887v-69.998h36.131 c27.106,0,49.283-22.59,49.283-50.199V90.197C512,62.59,489.822,40,462.717,40z M369.156,280.115H195.92v-24.316h173.236V280.115z M439.058,204.129H195.92v-24.314h243.138V204.129z M439.058,128.143H195.92v-24.315h243.138V128.143z"></path></g></svg>`);
  } else if ($props.name === "tr") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 256 256",
      "xml:space": "preserve"
    }, _attrs))}><g transform="translate(1.4065934065934016 1.4065934065934016) scale(2.81 2.81)"><path d="M 87.429 30 C 81.254 12.534 64.611 0.015 45.034 0 h -0.068 C 25.389 0.015 8.745 12.534 2.571 30 C 0.911 34.693 0 39.739 0 45 c 0 5.261 0.912 10.308 2.571 15 C 8.75 77.476 25.408 90 45 90 s 36.25 -12.524 42.429 -30 C 89.088 55.307 90 50.261 90 45 C 90 39.739 89.089 34.693 87.429 30 z" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(243,25,48)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path><path d="M 42.102 62.332 c -9.739 0 -17.634 -7.76 -17.634 -17.333 s 7.895 -17.333 17.634 -17.333 c 5.241 0 9.934 2.26 13.164 5.828 c -3.899 -6.102 -10.803 -10.161 -18.675 -10.161 c -12.174 0 -22.042 9.7 -22.042 21.667 s 9.868 21.667 22.042 21.667 c 7.875 0 14.781 -4.062 18.679 -10.168 C 52.041 60.07 47.346 62.332 42.102 62.332 z" style="${ssrRenderStyle({ "stroke": "none", "stroke-width": "1", "stroke-dasharray": "none", "stroke-linecap": "butt", "stroke-linejoin": "miter", "stroke-miterlimit": "10", "fill": "rgb(243,244,245)", "fill-rule": "nonzero", "opacity": "1" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path><path d="M 62.926 34.878 l -0.178 8.009 l -7.472 2.029 l 7.366 2.623 l -0.178 7.345 l 4.804 -5.736 l 7.259 2.518 l -4.199 -6.155 l 5.124 -6.121 l -7.864 2.168 L 62.926 34.878 L 62.926 34.878 z" style="${ssrRenderStyle({ "fill": "rgb(243,244,245)" })}" transform=" matrix(1 0 0 1 0 0) " stroke-linecap="round"></path></g></svg>`);
  } else if ($props.name === "ro") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512",
      "xml:space": "preserve"
    }, _attrs))}><path style="${ssrRenderStyle({ "fill": "#FFDA44" })}" d="M345.043,15.922C317.309,5.633,287.314,0,256,0c-31.314-0.001-61.31,5.633-89.043,15.922 l-22.261,240.077l22.261,240.077C194.689,506.368,224.685,512,256,512c31.313,0,61.31-5.632,89.043-15.924L367.303,256 L345.043,15.922z"></path><path style="${ssrRenderStyle({ "fill": "#D80027" })}" d="M512,256c0-110.07-69.472-203.907-166.957-240.077v480.156C442.528,459.905,511.999,366.072,512,256z"></path><path style="${ssrRenderStyle({ "fill": "#0052B4" })}" d="M0,255.999c0,110.073,69.472,203.906,166.955,240.079l0.001-480.154C69.472,52.094,0,145.928,0,255.999z"></path></svg>`);
  } else if ($props.name === "vi") {
    _push(`<svg${ssrRenderAttrs(mergeProps({
      viewBox: "0 0 64 64",
      xmlns: "http://www.w3.org/2000/svg",
      "xmlns:xlink": "http://www.w3.org/1999/xlink",
      "aria-hidden": "true",
      role: "img",
      class: "iconify iconify--emojione",
      preserveAspectRatio: "xMidYMid meet"
    }, _attrs))}><circle cx="32" cy="32" r="30" fill="#f42f4c"></circle><path fill="#ffe62e" d="M32 39l9.9 7l-3.7-11.4l9.8-7.4H35.8L32 16l-3.7 11.2H16l9.8 7.4L22.1 46z"></path></svg>`);
  } else {
    _push(`<!---->`);
  }
}
const _sfc_setup$a = _sfc_main$a.setup;
_sfc_main$a.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Icon.vue");
  return _sfc_setup$a ? _sfc_setup$a(props, ctx) : void 0;
};
const Icon = /* @__PURE__ */ _export_sfc(_sfc_main$a, [["ssrRender", _sfc_ssrRender$a]]);
const _sfc_main$9 = {
  props: {
    className: String,
    placement: {
      type: String,
      default: "bottom-end"
    },
    autoClose: {
      type: Boolean,
      default: true
    }
  },
  data() {
    return {
      show: false
    };
  },
  watch: {
    show(show) {
      if (show) {
        this.$nextTick(() => {
          this.popper = createPopper(this.$el, this.$refs.dropdown, {
            placement: this.placement,
            modifiers: [
              {
                name: "preventOverflow",
                options: {
                  altBoundary: true
                }
              }
            ]
          });
        });
      } else if (this.popper) {
        setTimeout(() => this.popper.destroy(), 100);
      }
    }
  },
  mounted() {
    document.addEventListener("keydown", (e) => {
      if (e.key === "Escape") {
        this.show = false;
      }
    });
  }
};
function _sfc_ssrRender$9(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<button${ssrRenderAttrs(mergeProps({ type: "button" }, _attrs))}>`);
  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
  if ($data.show) {
    ssrRenderTeleport(_push, (_push2) => {
      _push2(`<div><div style="${ssrRenderStyle({ "position": "fixed", "top": "0", "right": "0", "left": "0", "bottom": "0", "z-index": "99998", "background": "black", "opacity": "0.2" })}"></div><div class="${ssrRenderClass([$props.className, "dd_container"])}" style="${ssrRenderStyle({ "position": "absolute", "z-index": "99999" })}">`);
      ssrRenderSlot(_ctx.$slots, "dropdown", {}, null, _push2, _parent);
      _push2(`</div></div>`);
    }, "#dropdown", false, _parent);
  } else {
    _push(`<!---->`);
  }
  _push(`</button>`);
}
const _sfc_setup$9 = _sfc_main$9.setup;
_sfc_main$9.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Dropdown.vue");
  return _sfc_setup$9 ? _sfc_setup$9(props, ctx) : void 0;
};
const Dropdown = /* @__PURE__ */ _export_sfc(_sfc_main$9, [["ssrRender", _sfc_ssrRender$9]]);
const _sfc_main$8 = {
  components: {
    Icon,
    Link
  },
  data() {
    return {
      user: null,
      menu_items: [
        { "name": "Global", "route": "global", "url": "settings/global", "icon": "global_setting" },
        { "name": "Manage Users", "route": "users", "url": "settings/users", "icon": "users" },
        { "name": "Pre-made Boards", "route": "pre-made-boards", "url": "settings/pre-made-boards", "icon": "table" },
        { "name": "Workspace Types", "route": "workspace_types.index", "url": "settings/workspace_types", "icon": "user_role" },
        { "name": "User Roles", "route": "roles", "url": "settings/roles", "icon": "user_role" },
        { "name": "Languages", "route": "languages", "url": "settings/languages", "icon": "edit" },
        { "name": "Email Templates", "route": "templates", "url": "settings/templates", "icon": "email" },
        { "name": "SMTP Mail", "route": "settings.smtp", "url": "settings/smtp", "icon": "email_template" },
        { "name": "Latest Update", "route": "settings.update", "url": "settings/update", "icon": "archive" }
      ],
      enable_option: {}
    };
  },
  methods: {
    isUrl(...urls) {
      let currentUrl = this.$page.url.substr(1);
      currentUrl = currentUrl.replace("dashboard/", "");
      if (urls[0] === "") {
        return currentUrl === "";
      }
      return urls.filter((url) => currentUrl.startsWith(url)).length;
    },
    addActiveClass(e) {
      e.currentTarget.classList.toggle("hover");
    }
  },
  created() {
    this.user = this.$page.props.auth.user;
  }
};
function _sfc_ssrRender$8(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Link = resolveComponent("Link");
  const _component_icon = resolveComponent("icon");
  _push(`<div${ssrRenderAttrs(_attrs)}><!--[-->`);
  ssrRenderList($data.menu_items, (menu_item, m_index) => {
    _push(`<div class="${ssrRenderClass([$options.isUrl(menu_item.url) ? " active" : "", "menu-item"])}">`);
    _push(ssrRenderComponent(_component_Link, {
      class: ["flex items-center group py-3 menu-link", { "have-sub-menu": menu_item.submenu }],
      href: menu_item.route ? _ctx.route(menu_item.route) : "#"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(ssrRenderComponent(_component_icon, {
            name: menu_item.icon,
            class: "w-6 h-6 mr-3 rtl:ml-3 menu__icon"
          }, null, _parent2, _scopeId));
          _push2(`<div class="menu__name"${_scopeId}>${ssrInterpolate(_ctx.$t(menu_item.name))}</div>`);
        } else {
          return [
            createVNode(_component_icon, {
              name: menu_item.icon,
              class: "w-6 h-6 mr-3 rtl:ml-3 menu__icon"
            }, null, 8, ["name"]),
            createVNode("div", { class: "menu__name" }, toDisplayString(_ctx.$t(menu_item.name)), 1)
          ];
        }
      }),
      _: 2
    }, _parent));
    if (menu_item.submenu) {
      _push(`<div class="sub-menu-items"><!--[-->`);
      ssrRenderList(menu_item.submenu, (sub_menu_item, s_m_index) => {
        _push(ssrRenderComponent(_component_Link, {
          class: ["sub-menu-item", this.isUrl(sub_menu_item.url) ? " active" : ""],
          key: s_m_index,
          href: sub_menu_item.param ? _ctx.route(sub_menu_item.route, sub_menu_item.param) : _ctx.route(sub_menu_item.route)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              if (sub_menu_item.icon) {
                _push2(ssrRenderComponent(_component_icon, {
                  name: sub_menu_item.icon,
                  class: "w-4 h-4 mr-1 rtl:ml-1 menu__icon"
                }, null, _parent2, _scopeId));
              } else {
                _push2(ssrRenderComponent(_component_icon, {
                  name: "dash",
                  class: "w-4 h-4 mr-1 rtl:mr-1 menu__icon"
                }, null, _parent2, _scopeId));
              }
              _push2(`<div class="menu__name"${_scopeId}>${ssrInterpolate(_ctx.$t(sub_menu_item.name))}</div>`);
            } else {
              return [
                sub_menu_item.icon ? (openBlock(), createBlock(_component_icon, {
                  key: 0,
                  name: sub_menu_item.icon,
                  class: "w-4 h-4 mr-1 rtl:ml-1 menu__icon"
                }, null, 8, ["name"])) : (openBlock(), createBlock(_component_icon, {
                  key: 1,
                  name: "dash",
                  class: "w-4 h-4 mr-1 rtl:mr-1 menu__icon"
                })),
                createVNode("div", { class: "menu__name" }, toDisplayString(_ctx.$t(sub_menu_item.name)), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
      });
      _push(`<!--]--></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  });
  _push(`<!--]--></div>`);
}
const _sfc_setup$8 = _sfc_main$8.setup;
_sfc_main$8.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/MainMenu.vue");
  return _sfc_setup$8 ? _sfc_setup$8(props, ctx) : void 0;
};
const MainMenu = /* @__PURE__ */ _export_sfc(_sfc_main$8, [["ssrRender", _sfc_ssrRender$8]]);
const _sfc_main$7 = {
  name: "top-project-menu",
  props: {
    filter: {
      required: false
    }
  },
  components: { Link, Icon },
  data() {
    return {
      projects: [],
      loading: true
    };
  },
  methods: {
    saveProject(e, project) {
      e.preventDefault();
      axios.post(this.route("json.p.starred.save", project.id)).then((resp) => {
        window.location.reload();
      });
    },
    getProjects() {
      const workspace_id = this.$page.props.project ? this.$page.props.project.workspace_id : this.$page.props.workspace ? this.$page.props.workspace.id : null;
      const routString = this.filter ? "json.projects." + this.filter : "json.projects.all";
      axios.get(this.route(routString, workspace_id)).then((response) => {
        if (Object.keys(response.data).length) {
          this.projects = response.data.data;
          this.loading = false;
        }
      });
    }
  },
  created() {
    this.getProjects();
  }
};
function _sfc_ssrRender$7(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Link = resolveComponent("Link");
  const _component_icon = resolveComponent("icon");
  _push(`<section${ssrRenderAttrs(mergeProps({ class: "top_project_menu" }, _attrs))}><div tabindex="-1" class="menu__wrapper"><ul role="menu" class="list"><!--[-->`);
  ssrRenderList($data.projects, (project, p_index) => {
    _push(`<li class="item group"><div class="content">`);
    _push(ssrRenderComponent(_component_Link, {
      class: "flex px-1 py-2",
      href: _ctx.route("projects.view.board", project.slug || project.id)
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          if (project.background) {
            _push2(`<div style="${ssrRenderStyle({ "background-image": "url(" + project.background + ")" })}" class="flex bg-cover rounded-full w-6 h-6"${_scopeId}></div>`);
          } else {
            _push2(`<!---->`);
          }
          _push2(`<div class="flex w-full flex-1 justify-center flex-col pl-2 overflow-hidden text-ellipsis whitespace-nowrap"${_scopeId}><div class="font-medium text-sm leading-[18px]"${_scopeId}>${ssrInterpolate(project.title)}</div><div class="font-normal text-xs"${_scopeId}>${ssrInterpolate(project.workspace)}</div></div><button class="flex w-7 items-center justify-center"${_scopeId}>`);
          if (!!project.star) {
            _push2(ssrRenderComponent(_component_icon, {
              name: "star",
              class: "w-4 h-4 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
            }, null, _parent2, _scopeId));
          } else {
            _push2(ssrRenderComponent(_component_icon, {
              name: "star",
              class: "w-4 h-4 opacity-0 group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
            }, null, _parent2, _scopeId));
          }
          _push2(`</button>`);
        } else {
          return [
            project.background ? (openBlock(), createBlock("div", {
              key: 0,
              style: { "background-image": "url(" + project.background + ")" },
              class: "flex bg-cover rounded-full w-6 h-6"
            }, null, 4)) : createCommentVNode("", true),
            createVNode("div", { class: "flex w-full flex-1 justify-center flex-col pl-2 overflow-hidden text-ellipsis whitespace-nowrap" }, [
              createVNode("div", { class: "font-medium text-sm leading-[18px]" }, toDisplayString(project.title), 1),
              createVNode("div", { class: "font-normal text-xs" }, toDisplayString(project.workspace), 1)
            ]),
            createVNode("button", {
              class: "flex w-7 items-center justify-center",
              onClick: ($event) => $options.saveProject($event, project)
            }, [
              !!project.star ? (openBlock(), createBlock(_component_icon, {
                key: 0,
                name: "star",
                class: "w-4 h-4 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
              })) : (openBlock(), createBlock(_component_icon, {
                key: 1,
                name: "star",
                class: "w-4 h-4 opacity-0 group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
              }))
            ], 8, ["onClick"])
          ];
        }
      }),
      _: 2
    }, _parent));
    _push(`</div></li>`);
  });
  _push(`<!--]-->`);
  if (!$data.projects.length) {
    _push(`<li class="flex"><div class="flex px-2 py-2">${ssrInterpolate(_ctx.$t("No item found!"))}</div></li>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</ul></div></section>`);
}
const _sfc_setup$7 = _sfc_main$7.setup;
_sfc_main$7.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/TopProjectMenu.vue");
  return _sfc_setup$7 ? _sfc_setup$7(props, ctx) : void 0;
};
const TopProjectMenu = /* @__PURE__ */ _export_sfc(_sfc_main$7, [["ssrRender", _sfc_ssrRender$7]]);
const _sfc_main$6 = {
  inheritAttrs: false,
  props: {
    id: {
      type: String,
      default() {
        return `select-input-${v4()}`;
      }
    },
    error: String,
    label: String,
    required: {
      type: Boolean,
      default() {
        return false;
      }
    },
    modelValue: [String, Number, Boolean]
  },
  emits: ["update:modelValue"],
  data() {
    return {
      selected: this.modelValue
    };
  },
  watch: {
    selected(selected) {
      this.$emit("update:modelValue", selected);
    }
  },
  methods: {
    focus() {
      this.$refs.input.focus();
    },
    select() {
      this.$refs.input.select();
    }
  }
};
function _sfc_ssrRender$6(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: _ctx.$attrs.class
  }, _attrs))}>`);
  if ($props.label) {
    _push(`<label class="form-label"${ssrRenderAttr("for", $props.id)}>${ssrInterpolate($props.label)}</label>`);
  } else {
    _push(`<!---->`);
  }
  _push(`<select${ssrRenderAttrs(mergeProps({
    id: $props.id,
    ref: "input"
  }, { ..._ctx.$attrs, class: null }, {
    class: ["form-select", { error: $props.error }],
    required: $props.required
  }))}>`);
  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
  _push(`</select>`);
  if ($props.error) {
    _push(`<div class="form-error">${ssrInterpolate($props.error)}</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup$6 = _sfc_main$6.setup;
_sfc_main$6.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/SelectInput.vue");
  return _sfc_setup$6 ? _sfc_setup$6(props, ctx) : void 0;
};
const SelectInput = /* @__PURE__ */ _export_sfc(_sfc_main$6, [["ssrRender", _sfc_ssrRender$6]]);
const _sfc_main$5 = {
  name: "create-project",
  props: {
    top: {
      required: false,
      default: "50px"
    },
    left: {
      required: false,
      default: "390px"
    }
  },
  components: { SelectInput, Icon },
  data() {
    return {
      project: {},
      loading: true,
      workspaces: [],
      backgrounds: []
    };
  },
  methods: {
    async getData() {
      const workspaceResp = await axios.get(this.route("json.workspaces.all"));
      this.workspaces = workspaceResp.data;
      const backgroundResp = await axios.get(this.route("json.backgrounds.all"));
      this.backgrounds = backgroundResp.data;
      this.project.color = this.backgrounds[0];
      this.loading = false;
      if (this.$page.props.workspace || this.$page.props.project) {
        this.project.workspace_id = this.$page.props.workspace ? this.$page.props.workspace.id : this.$page.props.project ? this.$page.props.project.workspace_id : "";
      }
      if (!this.workspaces.length) {
        alert("You must need to create/join a workspace first.");
        this.$emit("createProject");
      }
    },
    createProject() {
      const project = { ...this.project };
      project.background_id = project.color.id;
      delete project.color;
      axios.post(this.route("json.project.create"), project).then((response) => {
        if (response.data) {
          window.location = this.route("projects.view.board", response.data.slug || response.data.id);
        }
      });
    }
  },
  created() {
    this.getData();
  }
};
function _sfc_ssrRender$5(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_icon = resolveComponent("icon");
  const _component_select_input = resolveComponent("select-input");
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: "fixed top-[52px] w-[260px] left-[30%] z-[200] rounded-[8px] bg-white shadow overflow-hidden create__project",
    style: { top: $props.top, left: $props.left }
  }, _attrs))}>`);
  if (!$data.loading) {
    _push(`<div class="flex gap-3 flex-col py-3 px-3"><div class="flex items-center justify-between gap-1"><div class="flex"></div><div class="flex text-center">${ssrInterpolate(_ctx.$t("Create Project"))}</div><div class="flex hover:bg-gray-200 cursor-pointer rounded w-7 h-7 justify-center items-center">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4",
      name: "close"
    }, null, _parent));
    _push(`</div></div><div class="flex justify-center"><div class="w-[70%] h-[100px] p-3 flex rounded justify-center" style="${ssrRenderStyle({ backgroundImage: "url(" + $data.project.color.image + ")", backgroundColor: $data.project.color.bg })}"><img src="/images/board.svg" class="w-auto max-h-full" alt="Board"></div></div><div class="flex"><label class="flex flex-col"><div class="title mb-2">${ssrInterpolate(_ctx.$t("Background"))}</div><div class="color__list"><ul class="grid grid-rows-2 grid-flow-col gap-[9px]"><!--[-->`);
    ssrRenderList($data.backgrounds, (color) => {
      _push(`<li class="flex"><button class="w-10 h-8 flex items-center justify-center rounded" style="${ssrRenderStyle({ backgroundImage: "url(" + color.image + ")", backgroundColor: color.bg })}">`);
      if ($data.project.color.id === color.id) {
        _push(ssrRenderComponent(_component_icon, {
          name: "tick_check",
          class: "text-white w-4 h-4"
        }, null, _parent));
      } else {
        _push(`<!---->`);
      }
      _push(`</button></li>`);
    });
    _push(`<!--]--></ul></div></label></div><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Project name"))} *</div><input${ssrRenderAttr("value", $data.project.title)} class="rounded border" type="text" required="" aria-required="true" autocomplete="off"></label></div><div class="flex"><label class="flex flex-col w-full"><div>${ssrInterpolate(_ctx.$t("Workspace"))}</div>`);
    _push(ssrRenderComponent(_component_select_input, {
      modelValue: $data.project.workspace_id,
      "onUpdate:modelValue": ($event) => $data.project.workspace_id = $event,
      class: "mr-2 w-full"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<!--[-->`);
          ssrRenderList($data.workspaces, (workspace, wi) => {
            _push2(`<option${ssrRenderAttr("value", workspace.id)}${_scopeId}>${ssrInterpolate(workspace.name)}</option>`);
          });
          _push2(`<!--]-->`);
        } else {
          return [
            (openBlock(true), createBlock(Fragment, null, renderList($data.workspaces, (workspace, wi) => {
              return openBlock(), createBlock("option", {
                key: wi,
                value: workspace.id
              }, toDisplayString(workspace.name), 9, ["value"]);
            }), 128))
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`</label></div><div class="flex"><div class="flex items-center h-5"><input id="helper-checkbox"${ssrIncludeBooleanAttr(ssrLooseEqual($data.project.is_private, "1")) ? " checked" : ""} aria-describedby="helper-checkbox-text" type="checkbox" value="" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded dark:bg-gray-700 dark:border-gray-600"></div><div class="ms-1 text-sm"><label for="helper-checkbox" class="font-medium text-[13px] text-gray-900 dark:text-gray-300">Visible tasks for assigned people <small>(Enabling this the tasks will be visible only for the admin and assigned people)</small></label></div></div><div class="flex"><label class="w-full flex flex-col"><div>${ssrInterpolate(_ctx.$t("Project Details"))} <small>(${ssrInterpolate(_ctx.$t("optional"))})</small></div><textarea class="rounded border" type="text" required="" aria-required="true" autocomplete="off">${ssrInterpolate($data.project.description)}</textarea></label></div><div class="flex"><button class="bg-indigo-600 w-full text-white p-[9px] rounded disabled:opacity-50"${ssrIncludeBooleanAttr(!$data.project.title) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("Create"))}</button></div></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup$5 = _sfc_main$5.setup;
_sfc_main$5.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Modals/CreateProject.vue");
  return _sfc_setup$5 ? _sfc_setup$5(props, ctx) : void 0;
};
const CreateProject = /* @__PURE__ */ _export_sfc(_sfc_main$5, [["ssrRender", _sfc_ssrRender$5]]);
const _sfc_main$4 = {
  name: "create-workspace",
  props: {
    top: {
      required: false,
      default: "50px"
    },
    left: {
      required: false,
      default: "390px"
    }
  },
  components: { SelectInput, Icon },
  emits: {
    createWorkspace: null
  },
  data() {
    return {
      workspace: {},
      loading: false,
      workspaces: [],
      backgrounds: [],
      types: []
      // types: ['Operation', 'Education', 'Marketing', 'Engineering-IT', 'Small Business', 'Other'],
    };
  },
  methods: {
    createWorkspace() {
      const workspace = { ...this.workspace };
      axios.post(this.route("json.workspace.create"), workspace).then((response) => {
        if (response.data) {
          window.location = this.route("workspace.view", response.data.slug || response.data.id);
        }
      });
    },
    getWorkspaceTypes() {
      axios.post(this.route("json.workspace.types.get")).then((response) => {
        if (response.data) {
          this.types = response.data.types;
        }
      });
    }
  },
  created() {
    this.getWorkspaceTypes();
  }
};
function _sfc_ssrRender$4(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_icon = resolveComponent("icon");
  const _component_select_input = resolveComponent("select-input");
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: "fixed top-[52px] w-[260px] left-[30%] z-[200] rounded-[8px] bg-white shadow overflow-hidden create__project",
    style: { top: $props.top, left: $props.left }
  }, _attrs))}>`);
  if (!$data.loading) {
    _push(`<div class="flex gap-3 flex-col py-3 px-5"><div class="flex items-center justify-between gap-1"><div class="flex"></div><div class="flex text-center">${ssrInterpolate(_ctx.$t("Create Workspace"))}</div><div class="flex hover:bg-gray-200 cursor-pointer rounded w-7 h-7 justify-center items-center">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4",
      name: "close"
    }, null, _parent));
    _push(`</div></div><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Workspace name"))} *</div><input${ssrRenderAttr("value", $data.workspace.name)} class="rounded border" type="text" required="" aria-required="true" autocomplete="off"></label></div><div class="flex"><label class="flex flex-col w-full text-left"><div>${ssrInterpolate(_ctx.$t("Workspace Type"))}</div>`);
    _push(ssrRenderComponent(_component_select_input, {
      modelValue: $data.workspace.type_id,
      "onUpdate:modelValue": ($event) => $data.workspace.type_id = $event,
      class: "mr-2 w-full"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<!--[-->`);
          ssrRenderList($data.types, (type, ti) => {
            _push2(`<option${ssrRenderAttr("value", type.id)}${_scopeId}>${ssrInterpolate(type.name)}</option>`);
          });
          _push2(`<!--]-->`);
        } else {
          return [
            (openBlock(true), createBlock(Fragment, null, renderList($data.types, (type, ti) => {
              return openBlock(), createBlock("option", {
                key: ti,
                value: type.id
              }, toDisplayString(type.name), 9, ["value"]);
            }), 128))
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`</label></div><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Website"))} <small>(${ssrInterpolate(_ctx.$t("optional"))})</small></div><input${ssrRenderAttr("value", $data.workspace.website)} class="rounded border" type="text" autocomplete="off"></label></div><div class="flex"><label class="w-full flex flex-col text-left"><div>${ssrInterpolate(_ctx.$t("Workspace Description"))} <small>(${ssrInterpolate(_ctx.$t("optional"))})</small></div><textarea class="rounded border" autocomplete="off">${ssrInterpolate($data.workspace.description)}</textarea></label></div><div class="flex"><button class="bg-indigo-600 w-full text-white p-[9px] rounded disabled:opacity-50"${ssrIncludeBooleanAttr(!$data.workspace.name) ? " disabled" : ""}>${ssrInterpolate(_ctx.$t("Create"))}</button></div></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup$4 = _sfc_main$4.setup;
_sfc_main$4.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Modals/CreateWorkspace.vue");
  return _sfc_setup$4 ? _sfc_setup$4(props, ctx) : void 0;
};
const CreateWorkspace = /* @__PURE__ */ _export_sfc(_sfc_main$4, [["ssrRender", _sfc_ssrRender$4]]);
const _sfc_main$3 = {
  name: "top-workspace-menu",
  components: { Link, Icon },
  data() {
    return {
      loading: true,
      your_workspaces: [],
      guest_workspaces: [],
      workspaces: []
    };
  },
  methods: {
    getWorkspaces() {
      axios.get(this.route("json.workspaces.all")).then((response) => {
        if (response.data) {
          this.workspaces = response.data;
          this.loading = false;
        }
      });
    }
  },
  created() {
    this.getWorkspaces();
  }
};
function _sfc_ssrRender$3(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Link = resolveComponent("Link");
  _push(`<section${ssrRenderAttrs(mergeProps({ class: "top_project_menu" }, _attrs))}><div tabindex="-1" class="menu__wrapper"><ul role="menu" class="list"><!--[-->`);
  ssrRenderList($data.workspaces, (workspace, p_index) => {
    _push(`<li class="item group"><div class="content">`);
    _push(ssrRenderComponent(_component_Link, {
      class: "flex",
      href: _ctx.route("workspace.view", workspace.slug || workspace.id)
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(`<div class="p-2 flex gap-2 items-center"${_scopeId}>`);
          if (workspace.logo) {
            _push2(`<div class="logo has_bg flex justify-center items-center w-9 h-9 rounded-full text-white text-lg" style="${ssrRenderStyle({ "background-image": "url(" + workspace.logo + ")" })}"${_scopeId}></div>`);
          } else {
            _push2(`<div class="logo flex justify-center items-center w-9 h-9 rounded-full bg-indigo-600 text-white text-lg"${_scopeId}>${ssrInterpolate(workspace.name.charAt(0))}</div>`);
          }
          _push2(`<div class="name"${_scopeId}>${ssrInterpolate(workspace.name)}</div></div>`);
        } else {
          return [
            createVNode("div", { class: "p-2 flex gap-2 items-center" }, [
              workspace.logo ? (openBlock(), createBlock("div", {
                key: 0,
                class: "logo has_bg flex justify-center items-center w-9 h-9 rounded-full text-white text-lg",
                style: { "background-image": "url(" + workspace.logo + ")" }
              }, null, 4)) : (openBlock(), createBlock("div", {
                key: 1,
                class: "logo flex justify-center items-center w-9 h-9 rounded-full bg-indigo-600 text-white text-lg"
              }, toDisplayString(workspace.name.charAt(0)), 1)),
              createVNode("div", { class: "name" }, toDisplayString(workspace.name), 1)
            ])
          ];
        }
      }),
      _: 2
    }, _parent));
    _push(`</div></li>`);
  });
  _push(`<!--]-->`);
  if (!$data.workspaces.length) {
    _push(`<li class="flex"><div class="flex px-2 py-2">${ssrInterpolate(_ctx.$t("No item found!"))}</div></li>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</ul></div></section>`);
}
const _sfc_setup$3 = _sfc_main$3.setup;
_sfc_main$3.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/TopWorkspaceMenu.vue");
  return _sfc_setup$3 ? _sfc_setup$3(props, ctx) : void 0;
};
const TopWorkspaceMenu = /* @__PURE__ */ _export_sfc(_sfc_main$3, [["ssrRender", _sfc_ssrRender$3]]);
const _sfc_main$2 = {
  name: "invite-workspace-member",
  props: {
    top: {
      required: false,
      default: "132px"
    },
    left: {
      required: false,
      default: "390px"
    },
    right: {
      required: false,
      default: "inherit"
    },
    workspace: Object
  },
  components: { SelectInput, Icon },
  data() {
    return {
      project: {},
      loading: true,
      user_search: "",
      role: "",
      workspaces: [],
      users: [],
      workspace_users: [],
      backgrounds: []
    };
  },
  methods: {
    inviteMember(checked, id, role) {
      axios.post(this.route("json.workspace.member.add"), { workspace_id: this.workspace.id, user_id: id, role }).then((response) => {
        if (response.data) {
          if (checked) {
            this.workspace_users.push(id);
            if (response.data.id && response.data.user && response.data.user.id) {
              axios.post(this.route("send.mail.workspace_user_added", { id: response.data.id, user_id: response.data.user.id })).catch((error) => {
                console.log(error);
              });
            }
          } else {
            const findIndex = this.workspace_users.findIndex((a) => a === id);
            if (findIndex > -1) {
              this.workspace_users.splice(findIndex, 1);
            }
          }
        }
      }).catch((error) => {
        console.log(error);
      });
    },
    searchUser(input) {
      return this.users.filter((u) => u.name.toLowerCase().indexOf(input) > -1);
    },
    team__members() {
      return this.workspace_users.map((item) => item.id);
    },
    async getData() {
      const dataResponse = await axios.get(this.route("json.workspaces.users.other", this.workspace.id));
      const data = dataResponse.data;
      this.users = data.users;
      this.workspace_users = data.workspace_users;
      this.loading = false;
    }
  },
  created() {
    this.getData();
  }
};
function _sfc_ssrRender$2(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_icon = resolveComponent("icon");
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: "absolute top-[52px] w-[260px] left-[30%] z-[200] rounded-[8px] bg-white shadow overflow-hidden",
    style: { top: $props.top, left: $props.left, right: $props.right }
  }, _attrs))}>`);
  if (!$data.loading) {
    _push(`<div class="flex gap-3 flex-col py-3 px-3"><div class="flex items-center justify-between gap-1"><div class="flex"></div><div class="flex text-center">${ssrInterpolate(_ctx.$t("Invite Workspace"))}</div><div class="flex hover:bg-gray-200 cursor-pointer rounded w-7 h-7 justify-center items-center">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4",
      name: "close"
    }, null, _parent));
    _push(`</div></div><input id="i_w_m_s_u" name="user_search"${ssrRenderAttr("value", $data.user_search)} class="border-[2px] px-2 py-1 border-gray-400 rounded-[3px]"${ssrRenderAttr("placeholder", _ctx.$t("Search User"))}><ul class="flex flex-col gap-1 h-48 max-h-48 overflow-y-auto"><!--[-->`);
    ssrRenderList($options.searchUser($data.user_search), (userObject, user_index) => {
      _push(`<li><label${ssrRenderAttr("for", "uid_" + user_index)} class="flex p-2 cursor-pointer hover:bg-gray-200 rounded"><input${ssrRenderAttr("id", "uid_" + user_index)} class="w-5 ml-1 mr-2" type="checkbox"${ssrIncludeBooleanAttr($data.workspace_users.includes(userObject.id)) ? " checked" : ""}>`);
      if (userObject.photo_path) {
        _push(`<img${ssrRenderAttr("aria-label", userObject.name)}${ssrRenderAttr("alt", userObject.name)} class="w-6 h-6 rounded-full"${ssrRenderAttr("src", userObject.photo_path)}>`);
      } else {
        _push(`<img${ssrRenderAttr("aria-label", userObject.name)}${ssrRenderAttr("alt", userObject.name)} class="w-6 h-6 rounded-full" src="/images/user.svg">`);
      }
      _push(`<span data-a="" class="p-1" type="button"${ssrRenderAttr("tabindex", user_index)}>${ssrInterpolate(userObject.name)}</span></label></li>`);
    });
    _push(`<!--]--></ul></div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup$2 = _sfc_main$2.setup;
_sfc_main$2.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Modals/InviteWorkspaceMember.vue");
  return _sfc_setup$2 ? _sfc_setup$2(props, ctx) : void 0;
};
const InviteWorkspaceMember = /* @__PURE__ */ _export_sfc(_sfc_main$2, [["ssrRender", _sfc_ssrRender$2]]);
const _sfc_main$1 = {
  name: "workspace-menu",
  components: {
    InviteWorkspaceMember,
    Icon,
    Link,
    CreateProject
  },
  emits: {
    enableSidebar: null
  },
  data() {
    return {
      projects: [],
      favorites: [],
      workspace: null,
      loading: true,
      hide_projects: false,
      hide_starred: false,
      invite_workspace: false,
      loading_items: [1, 2, 3, 4, 5],
      visible: { project_create: false },
      user: null,
      menu_items: [
        { "name": "Dashboard", "route": "dashboard", "url": "dashboard", "icon": "dashboard" },
        { "name": "Projects", "route": "projects.index", "url": "projects", "icon": "project" }
      ],
      enable_option: {}
    };
  },
  watch: {
    "$page.props.project": {
      handler() {
        if (this.$page.props.project) {
          if (this.$page.props.project.workspace.id !== this.workspace.id) {
            this.loading = true;
            this.workspace = this.$page.props.project.workspace;
            this.projects = [];
            this.getProjects();
          } else {
            const projectIndex = this.projects.findIndex((p) => p.id === this.$page.props.project.id);
            this.projects[projectIndex] = this.$page.props.project;
          }
          this.getStarredProjects();
        }
      },
      deep: true
    },
    "$page.props.workspace.id": {
      handler() {
        if (this.$page.props.workspace) {
          this.loading = true;
          this.workspace = this.$page.props.workspace;
          this.projects = [];
          this.getProjects();
        }
      },
      deep: true
    }
  },
  methods: {
    checkActiveClass(type, name) {
      if (type === "filter" && this.$page.props.filters && parseInt(this.$page.props.filters.user, 10) === this.$page.props.auth.user.id) {
        return "active";
      } else if (type === "component" && this.$page.component && this.$page.component.replace("/", "_") === name) {
        return "active";
      }
    },
    closeInviteMember() {
      this.invite_workspace = false;
      window.location.href = this.route("workspace.members", this.workspace.slug || this.workspace.id);
    },
    saveProject(e, project) {
      e.preventDefault();
      axios.post(this.route("json.p.starred.save", project.id)).then((resp) => {
        this.getProjects();
        this.getStarredProjects();
      });
    },
    getProjects() {
      axios.get(this.route("json.projects.all", this.workspace.id)).then((response) => {
        if (response.data) {
          this.projects = response.data;
        }
        this.loading = false;
      });
    },
    getStarredProjects() {
      axios.get(this.route("json.projects.star", this.workspace.id)).then((response) => {
        if (response.data) {
          this.favorites = response.data.data;
        }
        this.loading = false;
      });
    }
  },
  created() {
    this.workspace = this.$page.props.project ? this.$page.props.project.workspace : this.$page.props.workspace;
    this.getProjects();
    this.getStarredProjects();
  }
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Link = resolveComponent("Link");
  const _component_icon = resolveComponent("icon");
  const _component_create_project = resolveComponent("create-project");
  const _component_invite_workspace_member = resolveComponent("invite-workspace-member");
  if ($data.workspace) {
    _push(`<div${ssrRenderAttrs(mergeProps({ class: "sidebar_wrapper" }, _attrs))}>`);
    _push(ssrRenderComponent(_component_Link, {
      href: _ctx.route("workspace.view", $data.workspace.slug || $data.workspace.id),
      class: "p-3 flex flex-wrap gap-2 items-center relative"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          if ($data.workspace.logo) {
            _push2(`<div class="logo has_bg flex justify-center items-center w-9 h-9 rounded-full text-white text-lg" style="${ssrRenderStyle({ "background-image": "url(" + $data.workspace.logo + ")" })}"${_scopeId}></div>`);
          } else {
            _push2(`<div class="logo flex justify-center items-center w-9 h-9 rounded-full bg-indigo-600 text-white text-lg"${_scopeId}>${ssrInterpolate($data.workspace.name.charAt(0))}</div>`);
          }
          _push2(`<div class="name flex flex-wrap w-[140px] text-ellipsis leading-5 cursor-pointer"${_scopeId}>${ssrInterpolate($data.workspace.name)}</div><div class="arrow right-2 absolute w-7 h-7 flex items-center hover:bg-[#a6c5e229] justify-center rounded cursor-pointer"${_scopeId}>`);
          _push2(ssrRenderComponent(_component_icon, {
            class: "w-4 h-4",
            name: "arrow-left"
          }, null, _parent2, _scopeId));
          _push2(`</div>`);
        } else {
          return [
            $data.workspace.logo ? (openBlock(), createBlock("div", {
              key: 0,
              class: "logo has_bg flex justify-center items-center w-9 h-9 rounded-full text-white text-lg",
              style: { "background-image": "url(" + $data.workspace.logo + ")" }
            }, null, 4)) : (openBlock(), createBlock("div", {
              key: 1,
              class: "logo flex justify-center items-center w-9 h-9 rounded-full bg-indigo-600 text-white text-lg"
            }, toDisplayString($data.workspace.name.charAt(0)), 1)),
            createVNode("div", { class: "name flex flex-wrap w-[140px] text-ellipsis leading-5 cursor-pointer" }, toDisplayString($data.workspace.name), 1),
            createVNode("div", {
              onClick: ($event) => _ctx.$emit("enableSidebar"),
              class: "arrow right-2 absolute w-7 h-7 flex items-center hover:bg-[#a6c5e229] justify-center rounded cursor-pointer"
            }, [
              createVNode(_component_icon, {
                class: "w-4 h-4",
                name: "arrow-left"
              })
            ], 8, ["onClick"])
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`<ul class="font-medium text-sm items">`);
    if ($data.workspace.member.role === "admin") {
      _push(`<li>`);
      _push(ssrRenderComponent(_component_Link, {
        href: _ctx.route("workspace.tables", $data.workspace.slug || $data.workspace.id),
        class: ["flex items-center px-3 py-2 dark:text-white hover:bg-gray-200 dark:hover:bg-gray-700 group", { "active": $options.checkActiveClass("component", "Workspaces_Table") && !(_ctx.$page.props.filters && _ctx.$page.props.filters.user) }]
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_icon, {
              class: "w-4 h-4",
              name: "table"
            }, null, _parent2, _scopeId));
            _push2(`<span class="ml-3"${_scopeId}>${ssrInterpolate(_ctx.$t("Workspace Tasks"))}</span>`);
          } else {
            return [
              createVNode(_component_icon, {
                class: "w-4 h-4",
                name: "table"
              }),
              createVNode("span", { class: "ml-3" }, toDisplayString(_ctx.$t("Workspace Tasks")), 1)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li>`);
    } else {
      _push(`<!---->`);
    }
    _push(`<li>`);
    _push(ssrRenderComponent(_component_Link, {
      href: _ctx.route("workspace.tables", { "uid": $data.workspace.slug || $data.workspace.id, "user": _ctx.$page.props.auth.user.id }),
      class: ["flex items-center px-3 py-2 dark:text-white hover:bg-gray-200 dark:hover:bg-gray-700 group", { "active": $options.checkActiveClass("filter") }]
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(ssrRenderComponent(_component_icon, {
            class: "w-4 h-4",
            name: "list"
          }, null, _parent2, _scopeId));
          _push2(`<span class="ml-3"${_scopeId}>${ssrInterpolate(_ctx.$t("My Tasks"))}</span>`);
        } else {
          return [
            createVNode(_component_icon, {
              class: "w-4 h-4",
              name: "list"
            }),
            createVNode("span", { class: "ml-3" }, toDisplayString(_ctx.$t("My Tasks")), 1)
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`</li>`);
    if ($data.workspace.member.role === "admin") {
      _push(`<li class="relative">`);
      _push(ssrRenderComponent(_component_Link, {
        class: ["flex items-center px-3 p-2 group workspace_members", { "active": $options.checkActiveClass("component", "Workspaces_Members") }],
        href: _ctx.route("workspace.members", $data.workspace.id)
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(ssrRenderComponent(_component_icon, {
              class: "w-4 h-4",
              name: "user"
            }, null, _parent2, _scopeId));
            _push2(`<span class="flex-1 ml-3 whitespace-nowrap"${_scopeId}>${ssrInterpolate(_ctx.$t("Team Members"))}</span>`);
            if ($data.workspace.member.role === "admin") {
              _push2(`<button class="flex w-5 h-5 rounded justify-center items-center add__plus"${_scopeId}>`);
              _push2(ssrRenderComponent(_component_icon, {
                class: "w-4 h-4",
                name: "plus"
              }, null, _parent2, _scopeId));
              _push2(`</button>`);
            } else {
              _push2(`<!---->`);
            }
          } else {
            return [
              createVNode(_component_icon, {
                class: "w-4 h-4",
                name: "user"
              }),
              createVNode("span", { class: "flex-1 ml-3 whitespace-nowrap" }, toDisplayString(_ctx.$t("Team Members")), 1),
              $data.workspace.member.role === "admin" ? (openBlock(), createBlock("button", {
                key: 0,
                onClick: ($event) => {
                  $event.preventDefault();
                  $data.invite_workspace = true;
                },
                class: "flex w-5 h-5 rounded justify-center items-center add__plus"
              }, [
                createVNode(_component_icon, {
                  class: "w-4 h-4",
                  name: "plus"
                })
              ], 8, ["onClick"])) : createCommentVNode("", true)
            ];
          }
        }),
        _: 1
      }, _parent));
      _push(`</li>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</ul><div class="flex cursor-pointer select-none text-[13px] text items-center justify-start gap-3 mt-4 font-bold px-2 pt-2 border-t border-[#ffffff29]">`);
    if (!$data.hide_starred) {
      _push(ssrRenderComponent(_component_icon, {
        name: "arrow-down",
        class: "w-4 h-4"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    if ($data.hide_starred) {
      _push(ssrRenderComponent(_component_icon, {
        name: "arrow-right",
        class: "w-4 h-4"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    _push(`<div class="flex uppercase font-semibold">${ssrInterpolate(_ctx.$t("Favorites"))}</div></div><ul class="pt-1 text-sm side_p_list font-medium border-gray-200 dark:border-gray-700 max-h-[calc(100%-350px)] overflow-y-auto" style="${ssrRenderStyle(!$data.hide_starred && $data.favorites.length ? null : { display: "none" })}"><!--[-->`);
    ssrRenderList($data.favorites, (project, p_index) => {
      _push(`<li class="flex group">`);
      _push(ssrRenderComponent(_component_Link, {
        href: _ctx.route("projects.view.board", project.slug || project.id),
        class: ["p-2 relative block w-full item", { "active": project.id === (_ctx.$page.props.project ? _ctx.$page.props.project.id : "") }]
      }, {
        default: withCtx((_, _push2, _parent2, _scopeId) => {
          if (_push2) {
            _push2(`<div class="flex h-5 relative"${_scopeId}>`);
            if (project.background) {
              _push2(`<div style="${ssrRenderStyle({ "background-image": "url(" + project.background + ")" })}" class="flex bg-cover rounded-full w-5 h-5 border"${_scopeId}></div>`);
            } else {
              _push2(`<!---->`);
            }
            _push2(`<div class="flex w-full flex-1 justify-center flex-col pl-2 overflow-hidden text-ellipsis whitespace-nowrap"${_scopeId}><div class="font-medium text-[13px] leading-[18px]"${_scopeId}>${ssrInterpolate(project.title)}</div></div><button class="flex w-7 items-center justify-center"${_scopeId}>`);
            if (!!project.star) {
              _push2(ssrRenderComponent(_component_icon, {
                name: "star",
                class: "w-4 h-4 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
              }, null, _parent2, _scopeId));
            } else {
              _push2(ssrRenderComponent(_component_icon, {
                name: "star",
                class: "w-4 h-4 opacity-0 group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
              }, null, _parent2, _scopeId));
            }
            _push2(`</button></div>`);
          } else {
            return [
              createVNode("div", { class: "flex h-5 relative" }, [
                project.background ? (openBlock(), createBlock("div", {
                  key: 0,
                  style: { "background-image": "url(" + project.background + ")" },
                  class: "flex bg-cover rounded-full w-5 h-5 border"
                }, null, 4)) : createCommentVNode("", true),
                createVNode("div", { class: "flex w-full flex-1 justify-center flex-col pl-2 overflow-hidden text-ellipsis whitespace-nowrap" }, [
                  createVNode("div", { class: "font-medium text-[13px] leading-[18px]" }, toDisplayString(project.title), 1)
                ]),
                createVNode("button", {
                  class: "flex w-7 items-center justify-center",
                  onClick: ($event) => $options.saveProject($event, project)
                }, [
                  !!project.star ? (openBlock(), createBlock(_component_icon, {
                    key: 0,
                    name: "star",
                    class: "w-4 h-4 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
                  })) : (openBlock(), createBlock(_component_icon, {
                    key: 1,
                    name: "star",
                    class: "w-4 h-4 opacity-0 group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
                  }))
                ], 8, ["onClick"])
              ])
            ];
          }
        }),
        _: 2
      }, _parent));
      _push(`</li>`);
    });
    _push(`<!--]--></ul><div class="flex text-[13px] text items-center justify-between mt-4 font-bold px-2 pt-2 border-t border-[#ffffff29]"><div class="flex justify-start select-none gap-3">`);
    if (!$data.hide_projects) {
      _push(ssrRenderComponent(_component_icon, {
        name: "arrow-down",
        class: "w-4 h-4"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    if ($data.hide_projects) {
      _push(ssrRenderComponent(_component_icon, {
        name: "arrow-right",
        class: "w-4 h-4"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    _push(`<div class="flex cursor-pointer uppercase font-semibold">${ssrInterpolate(_ctx.$t("Projects"))}</div></div><div class="flex">`);
    _push(ssrRenderComponent(_component_Link, {
      href: _ctx.route("workspace.view", $data.workspace.id),
      class: "flex w-7 h-7 cursor-pointer rounded justify-center items-center add__plus"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(ssrRenderComponent(_component_icon, {
            class: "w-4 h-4",
            name: "project"
          }, null, _parent2, _scopeId));
        } else {
          return [
            createVNode(_component_icon, {
              class: "w-4 h-4",
              name: "project"
            })
          ];
        }
      }),
      _: 1
    }, _parent));
    if ($data.workspace.member.role === "admin") {
      _push(`<div class="flex w-7 h-7 cursor-pointer rounded justify-center items-center add__plus">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4",
        name: "plus"
      }, null, _parent));
      _push(`</div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div></div>`);
    if ($data.visible.project_create) {
      _push(ssrRenderComponent(_component_create_project, {
        onCreateProject: ($event) => $data.visible.project_create = false,
        top: "30%",
        left: "240px"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    if ($data.invite_workspace) {
      _push(ssrRenderComponent(_component_invite_workspace_member, {
        workspace: $data.workspace,
        onInviteMember: ($event) => $options.closeInviteMember(),
        top: "100px",
        left: "90px"
      }, null, _parent));
    } else {
      _push(`<!---->`);
    }
    if (!$data.hide_projects && !$data.loading && $data.projects.length) {
      _push(`<ul class="pt-1 text-sm side_p_list font-medium border-gray-200 dark:border-gray-700 max-h-[calc(100%-350px)] overflow-y-auto"><!--[-->`);
      ssrRenderList($data.projects, (project, p_index) => {
        _push(`<li class="flex group">`);
        _push(ssrRenderComponent(_component_Link, {
          href: _ctx.route("projects.view.board", project.slug || project.id),
          class: ["p-2 relative block w-full item", { "active": project.id === (_ctx.$page.props.project ? _ctx.$page.props.project.id : "") }]
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`<div class="flex h-5 relative"${_scopeId}>`);
              if (project.background) {
                _push2(`<div style="${ssrRenderStyle([project.background && project.background.image ? { backgroundImage: "url(" + project.background.image + ")", backgroundSize: "cover" } : {}])}" class="flex bg-cover rounded-full w-5 h-5 border"${_scopeId}></div>`);
              } else {
                _push2(`<!---->`);
              }
              _push2(`<div class="flex w-full flex-1 justify-center flex-col pl-2 overflow-hidden text-ellipsis whitespace-nowrap"${_scopeId}><div class="font-medium text-[13px] leading-[18px]"${_scopeId}>${ssrInterpolate(project.title)}</div></div><button class="flex w-7 items-center justify-center"${_scopeId}>`);
              if (!!project.star) {
                _push2(ssrRenderComponent(_component_icon, {
                  name: "star",
                  class: "w-4 h-4 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
                }, null, _parent2, _scopeId));
              } else {
                _push2(ssrRenderComponent(_component_icon, {
                  name: "star",
                  class: "w-4 h-4 opacity-0 group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
                }, null, _parent2, _scopeId));
              }
              _push2(`</button></div>`);
            } else {
              return [
                createVNode("div", { class: "flex h-5 relative" }, [
                  project.background ? (openBlock(), createBlock("div", {
                    key: 0,
                    style: [project.background && project.background.image ? { backgroundImage: "url(" + project.background.image + ")", backgroundSize: "cover" } : {}],
                    class: "flex bg-cover rounded-full w-5 h-5 border"
                  }, null, 4)) : createCommentVNode("", true),
                  createVNode("div", { class: "flex w-full flex-1 justify-center flex-col pl-2 overflow-hidden text-ellipsis whitespace-nowrap" }, [
                    createVNode("div", { class: "font-medium text-[13px] leading-[18px]" }, toDisplayString(project.title), 1)
                  ]),
                  createVNode("button", {
                    class: "flex w-7 items-center justify-center",
                    onClick: ($event) => $options.saveProject($event, project)
                  }, [
                    !!project.star ? (openBlock(), createBlock(_component_icon, {
                      key: 0,
                      name: "star",
                      class: "w-4 h-4 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
                    })) : (openBlock(), createBlock(_component_icon, {
                      key: 1,
                      name: "star",
                      class: "w-4 h-4 opacity-0 group-hover:opacity-100 hover:text-yellow-500 hover:scale-125"
                    }))
                  ], 8, ["onClick"])
                ])
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul>`);
    } else {
      _push(`<!---->`);
    }
    if (!$data.loading && !$data.projects.length) {
      _push(`<div class="p-3 font-light text-center text-sm">${ssrInterpolate("No project!")}</div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/WorkspaceMenu.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const WorkspaceMenu = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main = {
  components: {
    WorkspaceMenu,
    TopWorkspaceMenu,
    CreateWorkspace,
    Dropdown,
    FlashMessages,
    Icon,
    Logo,
    Link,
    MainMenu,
    TopProjectMenu,
    CreateProject
  },
  props: {
    title: String,
    auth: Object
  },
  data() {
    return {
      creations: [
        { name: "Project", visible: "project_create", icon: "project", condition: !!this.$page.props.auth.user.role.create_project, details: "After creating project, you will be able to manage your tasks on board." },
        { name: "Workspace", visible: "create_workspace", condition: !!this.$page.props.auth.user.role.create_workspace, icon: "workspace", details: "After creating project, you will be able to manage your tasks on board." }
      ],
      time: "",
      search_timer: null,
      search_loading: false,
      search_result: { tasks: [], projects: [] },
      enable_sidebar: true,
      show__menu__list: false,
      current_mode: "light",
      modes: ["dark", "light"],
      visible: { project_create: false, create_workspace: false, menu_workspace: false, menu_recent: false, menu_star: false, menu_create: false },
      edit_route: "",
      current_page: "dashboard",
      activeTimerString: "",
      counter: { seconds: 0, timer: this.auth.timer, duration: 0 },
      locale: this.$page.props.auth.user.locale,
      dir: ["sa", "he", "ur"].includes(this.$page.props.auth.user.locale) ? "rtl" : "ltr"
    };
  },
  computed: {},
  // $page.props.counter
  watch: {
    "$page.props.tracker": {
      handler() {
        if (this.$page.props.tracker) {
          if (!!this.$page.props.tracker.started && this.$page.props.counter) {
            this.startExistingTimer(this.$page.props.counter);
          } else if (!this.$page.props.tracker.started && this.$page.props.counter) {
            this.stopTracker();
          }
        }
      },
      deep: true
    }
  },
  methods: {
    startExistingTimer(counter) {
      Object.assign(this.counter, counter);
      let seconds = this.counter.timer.duration;
      this.counter.ticker = setInterval(() => {
        this.counter.seconds = ++seconds;
        this.activeTimerString = this.moment.utc(moment.duration(this.counter.seconds + parseInt(this.counter.duration), "seconds").as("milliseconds")).format("H:mm:ss");
      }, 1e3);
    },
    goToLink(link) {
      window.location.href = link;
    },
    startTimer() {
      let started = this.counter.timer.started_at ? this.moment.utc(this.counter.timer.started_at) : this.moment();
      let seconds = parseInt(this.moment.duration(this.moment().diff(started)).asSeconds());
      seconds = this.counter.timer.duration + seconds;
      this.counter.ticker = setInterval(() => {
        this.counter.seconds = ++seconds;
        this.activeTimerString = this.moment.utc(moment.duration(this.counter.seconds + parseInt(this.counter.duration), "seconds").as("milliseconds")).format("H:mm:ss");
      }, 1e3);
    },
    stopTracker() {
      axios.post(this.route("task.timer.stop"), { duration: this.counter.seconds, id: this.counter.timer.id }).then((response) => {
        this.counter.duration = response.data;
        this.stopTimer();
      });
    },
    stopTimer() {
      clearInterval(this.counter.ticker);
      this.activeTimerString = "";
      if (this.$page.props.lists) {
        const task = this.counter.timer.task;
        const listIndex = this.$page.props.lists.findIndex((l) => l.id === task.list_id);
        if (listIndex > -1) {
          const taskIndex = this.$page.props.lists[listIndex].tasks.findIndex((t) => t.id === task.id);
          if (taskIndex > -1)
            this.$page.props.lists[listIndex].tasks[taskIndex].timer = null;
        }
      }
    },
    doSearch(e) {
      const search = e.target.value;
      const vm = this;
      if (search.length > 2) {
        vm.search_loading = true;
        clearTimeout(vm.search_timer);
        vm.search_timer = setTimeout(function() {
          axios.post(this.route("json.task.search", { q: search })).then((response) => {
            vm.search_result = response.data;
            vm.search_loading = false;
          });
        }, 1500);
      } else {
        vm.clearSearch();
      }
    },
    clearSearch() {
      console.log("cleared!");
      const vm = this;
      vm.search_result.projects = [];
      vm.search_result.tasks = [];
      vm.search_loading = false;
      clearTimeout(vm.search_timer);
    },
    switchMode() {
      this.current_mode = this.current_mode === "light" ? "dark" : "light";
      localStorage.setItem("current_mode", this.current_mode);
    },
    async getDuration(task_id) {
      const response = await axios.get(this.route("task.timer.duration", task_id));
      this.counter.duration = response.data;
      this.startTimer(this.counter.timer.started_at);
    }
  },
  created() {
    this.moment = moment;
    if (localStorage.getItem("current_mode")) {
      this.current_mode = localStorage.getItem("current_mode");
    }
    if (this.counter.timer && this.counter.timer.started_at && !this.counter.timer.stopped_at) {
      this.getDuration(this.counter.timer.task_id);
    }
    if (getActiveLanguage() !== this.locale) {
      loadLanguageAsync(this.locale);
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_Link = resolveComponent("Link");
  const _component_logo = resolveComponent("logo");
  const _component_icon = resolveComponent("icon");
  const _component_top_project_menu = resolveComponent("top-project-menu");
  const _component_top_workspace_menu = resolveComponent("top-workspace-menu");
  const _component_dropdown = resolveComponent("dropdown");
  const _component_workspace_menu = resolveComponent("workspace-menu");
  const _component_main_menu = resolveComponent("main-menu");
  const _component_flash_messages = resolveComponent("flash-messages");
  const _component_create_project = resolveComponent("create-project");
  const _component_create_workspace = resolveComponent("create-workspace");
  const _directive_click_outside = resolveDirective("click-outside");
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: ["layout-app", [$data.current_mode, _ctx.$page.props.project ? "project" : "main", _ctx.$page.component.replace("/", "_")]],
    dir: $data.dir,
    style: [_ctx.$page.props.project && _ctx.$page.props.project.background ? { backgroundColor: _ctx.$page.props.project.background.bg, backgroundImage: "url(" + _ctx.$page.props.project.background.image + ")", backgroundSize: "cover" } : {}]
  }, _attrs))}><div id="dropdown"></div><div class="md:flex md:flex-col"><div class="md:h-screen md:flex md:flex-col"><div class="md:flex md:shrink-0"><div class="bg-white w-full p-4 md:py-2 md:pr-12 md:pl-8 text-sm flex justify-first items-center top_bar" style="${ssrRenderStyle([_ctx.$page.props.project && _ctx.$page.props.project.background ? { backgroundColor: _ctx.$page.props.project.background.top } : {}])}"><div class="placement-top-left w-full"><div class="flex w-full lg:flex-row flex-col"><div class="flex gap-3 select-none top_bar__menu">`);
  _push(ssrRenderComponent(_component_Link, {
    class: "mr-2",
    href: "/"
  }, {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(ssrRenderComponent(_component_logo, {
          class: "site-logo white",
          name: "white"
        }, null, _parent2, _scopeId));
        _push2(ssrRenderComponent(_component_logo, { class: "site-logo color" }, null, _parent2, _scopeId));
      } else {
        return [
          createVNode(_component_logo, {
            class: "site-logo white",
            name: "white"
          }),
          createVNode(_component_logo, { class: "site-logo color" })
        ];
      }
    }),
    _: 1
  }, _parent));
  _push(`<div class="t__l__wrapper"><div class="mobile__menu__top bg-[#a6c5e229]"><span class="text-white">More</span> `);
  _push(ssrRenderComponent(_component_icon, {
    class: "ml-2 w-4 h-4 text-white",
    name: "arrow-down"
  }, null, _parent));
  _push(`</div><div class="${ssrRenderClass([{ "mobile": $data.show__menu__list }, "tl_menu_list hidden"])}"><div${ssrRenderAttrs(mergeProps({ class: "flex t__menu relative items-center cursor-pointer rounded py-1 px-3 hover:bg-[#a6c5e229]" }, ssrGetDirectiveProps(_ctx, _directive_click_outside, () => {
    $data.visible.menu_recent = false;
  })))}><span class="text-white">${ssrInterpolate(_ctx.$t("Recently Viewed"))}</span> `);
  _push(ssrRenderComponent(_component_icon, {
    class: "ml-2 w-4 h-4 text-white",
    name: "arrow-down"
  }, null, _parent));
  if ($data.visible.menu_recent) {
    _push(ssrRenderComponent(_component_top_project_menu, {
      filter: "recent",
      tabindex: "-1"
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`</div><div${ssrRenderAttrs(mergeProps({ class: "flex t__menu relative items-center cursor-pointer rounded py-1 px-3 hover:bg-[#a6c5e229]" }, ssrGetDirectiveProps(_ctx, _directive_click_outside, () => {
    $data.visible.menu_workspace = false;
  })))}><span class="text-white">${ssrInterpolate(_ctx.$t("My Workspaces"))}</span> `);
  _push(ssrRenderComponent(_component_icon, {
    class: "ml-2 w-4 h-4 text-white",
    name: "arrow-down"
  }, null, _parent));
  if ($data.visible.menu_workspace) {
    _push(ssrRenderComponent(_component_top_workspace_menu, { tabindex: "-1" }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div>`);
  if (this.$page.props.auth.user.role.create_project || this.$page.props.auth.user.role.create_workspace) {
    _push(`<div${ssrRenderAttrs(mergeProps({ class: "__creation" }, ssrGetDirectiveProps(_ctx, _directive_click_outside, () => {
      $data.visible.menu_create = false;
    })))}>${ssrInterpolate(_ctx.$t("Create"))} `);
    if ($data.visible.menu_create) {
      _push(`<section class="m__create"><div tabindex="-1" class="m__area"><ul role="menu" class=""><!--[-->`);
      ssrRenderList($data.creations, (create) => {
        _push(`<li class="group">`);
        if (create.condition) {
          _push(`<div class="c__1"><div class="c__2"><div class="c__3">`);
          _push(ssrRenderComponent(_component_icon, {
            name: create.icon,
            class: "w-4 h-4"
          }, null, _parent));
          _push(`<div>${ssrInterpolate(create.name)}</div></div><div class="font-normal text-xs">${ssrInterpolate(create.details)}</div></div></div>`);
        } else {
          _push(`<!---->`);
        }
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div></section>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div></div></div><div class="placement-top-right gap-2"><div class="relative"><div class="absolute inset-y-0 start-0 flex items-center ps-2 pointer-events-none"><svg class="w-4 h-4 text-gray-500 dark:text-gray-400" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 20 20"><path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m19 19-4-4m0-7A7 7 0 1 1 1 8a7 7 0 0 1 14 0Z"></path></svg></div><input type="search" id="default-search" class="block w-auto p-2 ps-7 text-sm text-gray-900 rounded-lg bg-gray-50 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"${ssrRenderAttr("placeholder", _ctx.$t("Find tasks or projects"))} required></div><div class="search_result w-48 absolute top-9 bg-gray-50 dark:bg-gray-700 text-gray-900 dark:text-white">`);
  if ($data.search_loading) {
    _push(`<div class="bg-white flex justify-center items-center p-2 border border-gray-100 w-full mt-2"><svg aria-hidden="true" class="inline w-4 h-4 text-gray-200 animate-spin dark:text-gray-600 fill-blue-600" viewBox="0 0 100 101" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M100 50.5908C100 78.2051 77.6142 100.591 50 100.591C22.3858 100.591 0 78.2051 0 50.5908C0 22.9766 22.3858 0.59082 50 0.59082C77.6142 0.59082 100 22.9766 100 50.5908ZM9.08144 50.5908C9.08144 73.1895 27.4013 91.5094 50 91.5094C72.5987 91.5094 90.9186 73.1895 90.9186 50.5908C90.9186 27.9921 72.5987 9.67226 50 9.67226C27.4013 9.67226 9.08144 27.9921 9.08144 50.5908Z" fill="currentColor"></path><path d="M93.9676 39.0409C96.393 38.4038 97.8624 35.9116 97.0079 33.5539C95.2932 28.8227 92.871 24.3692 89.8167 20.348C85.8452 15.1192 80.8826 10.7238 75.2124 7.41289C69.5422 4.10194 63.2754 1.94025 56.7698 1.05124C51.7666 0.367541 46.6976 0.446843 41.7345 1.27873C39.2613 1.69328 37.813 4.19778 38.4501 6.62326C39.0873 9.04874 41.5694 10.4717 44.0505 10.1071C47.8511 9.54855 51.7191 9.52689 55.5402 10.0491C60.8642 10.7766 65.9928 12.5457 70.6331 15.2552C75.2735 17.9648 79.3347 21.5619 82.5849 25.841C84.9175 28.9121 86.7997 32.2913 88.1811 35.8758C89.083 38.2158 91.5421 39.6781 93.9676 39.0409Z" fill="currentFill"></path></svg></div>`);
  } else {
    _push(`<!---->`);
  }
  if (!$data.search_loading && ($data.search_result.projects.length || $data.search_result.tasks.length)) {
    _push(`<div class="search__result z-10 bg-white divide-y divide-gray-100 rounded-lg shadow dark:bg-gray-700 dark:divide-gray-600">`);
    if ($data.search_result.projects.length) {
      _push(`<div class="sr__projects"><h4 class="sr__title px-3 py-2 font-bold border-b">Projects</h4><ul class="py-2 text-sm text-gray-700 dark:text-gray-200 max-h-48 overflow-y-auto"><!--[-->`);
      ssrRenderList($data.search_result.projects, (s_i, i) => {
        _push(`<li class="">`);
        _push(ssrRenderComponent(_component_Link, {
          class: "block px-3 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white",
          href: this.route("projects.view.board", s_i.id)
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(s_i.title.length < 20 ? s_i.title : s_i.title.substring(0, 20) + "...")}`);
            } else {
              return [
                createTextVNode(toDisplayString(s_i.title.length < 20 ? s_i.title : s_i.title.substring(0, 20) + "..."), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.search_result.tasks.length) {
      _push(`<div class="sr__tasks"><h4 class="sr__title px-3 py-2 font-bold border-b">Tasks</h4><ul class="py-2 text-sm text-gray-700 dark:text-gray-200 max-h-48 overflow-y-auto"><!--[-->`);
      ssrRenderList($data.search_result.tasks, (s_i, i) => {
        _push(`<li class="">`);
        _push(ssrRenderComponent(_component_Link, {
          class: "block px-3 py-2 hover:bg-gray-100 dark:hover:bg-gray-600 dark:hover:text-white",
          href: this.route("projects.board.with.task", { projectUid: s_i.project_id, taskUid: s_i.id })
        }, {
          default: withCtx((_, _push2, _parent2, _scopeId) => {
            if (_push2) {
              _push2(`${ssrInterpolate(s_i.title.length < 20 ? s_i.title : s_i.title.substring(0, 20) + "...")}`);
            } else {
              return [
                createTextVNode(toDisplayString(s_i.title.length < 20 ? s_i.title : s_i.title.substring(0, 20) + "..."), 1)
              ];
            }
          }),
          _: 2
        }, _parent));
        _push(`</li>`);
      });
      _push(`<!--]--></ul></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
  if (this.counter.timer && this.activeTimerString) {
    _push(`<div class="tracker"><p class="show">${ssrInterpolate($data.activeTimerString)}</p>`);
    if (!!this.activeTimerString) {
      _push(`<button>STOP</button>`);
    } else {
      _push(`<!---->`);
    }
    _push(ssrRenderComponent(_component_Link, {
      href: this.route("projects.view.board", { uid: this.counter.timer.task.project_id, task: this.counter.timer.task.slug || this.counter.timer.task.id }),
      "aria-label": "Task details"
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(ssrRenderComponent(_component_icon, {
            class: "",
            name: "info"
          }, null, _parent2, _scopeId));
        } else {
          return [
            createVNode(_component_icon, {
              class: "",
              name: "info"
            })
          ];
        }
      }),
      _: 1
    }, _parent));
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`<button class="theme-toggle ml-3 mr-3" id="theme-toggle" title="Toggles light &amp; dark"${ssrRenderAttr("aria-label", $data.current_mode)} aria-live="polite"><svg class="sun-and-moon" aria-hidden="true" width="24" height="24" viewBox="0 0 24 24"><mask class="moon" id="moon-mask"><rect x="0" y="0" width="100%" height="100%" fill="white"></rect><circle cx="24" cy="10" r="6" fill="black"></circle></mask><circle class="sun" cx="12" cy="12" r="6" mask="url(#moon-mask)" fill="currentColor"></circle><g class="sun-beams" stroke="currentColor"><line x1="12" y1="1" x2="12" y2="3"></line><line x1="12" y1="21" x2="12" y2="23"></line><line x1="4.22" y1="4.22" x2="5.64" y2="5.64"></line><line x1="18.36" y1="18.36" x2="19.78" y2="19.78"></line><line x1="1" y1="12" x2="3" y2="12"></line><line x1="21" y1="12" x2="23" y2="12"></line><line x1="4.22" y1="19.78" x2="5.64" y2="18.36"></line><line x1="18.36" y1="5.64" x2="19.78" y2="4.22"></line></g></svg></button>`);
  _push(ssrRenderComponent(_component_dropdown, {
    class: "select_user",
    placement: "bottom-end"
  }, {
    default: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<div class="flex items-center cursor-pointer group"${_scopeId}><div class="mr-1 whitespace-nowrap"${_scopeId}>`);
        if (_ctx.$page.props.auth.user.photo) {
          _push2(`<img class="user_photo"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.first_name)}${ssrRenderAttr("src", _ctx.$page.props.auth.user.photo)}${_scopeId}>`);
        } else {
          _push2(`<img src="/images/svg/profile.svg" class="w-5 h-5" alt="user profile"${_scopeId}>`);
        }
        _push2(`</div>`);
        _push2(ssrRenderComponent(_component_icon, {
          class: "w-5 h-5 drop-down-caret-icon fill-white",
          name: "cheveron-down"
        }, null, _parent2, _scopeId));
        _push2(`</div>`);
      } else {
        return [
          createVNode("div", { class: "flex items-center cursor-pointer group" }, [
            createVNode("div", { class: "mr-1 whitespace-nowrap" }, [
              _ctx.$page.props.auth.user.photo ? (openBlock(), createBlock("img", {
                key: 0,
                class: "user_photo",
                alt: _ctx.$page.props.auth.user.first_name,
                src: _ctx.$page.props.auth.user.photo
              }, null, 8, ["alt", "src"])) : (openBlock(), createBlock("img", {
                key: 1,
                src: "/images/svg/profile.svg",
                class: "w-5 h-5",
                alt: "user profile"
              }))
            ]),
            createVNode(_component_icon, {
              class: "w-5 h-5 drop-down-caret-icon fill-white",
              name: "cheveron-down"
            })
          ])
        ];
      }
    }),
    dropdown: withCtx((_, _push2, _parent2, _scopeId) => {
      if (_push2) {
        _push2(`<div class="shadow-xl bg-white rounded text-sm"${_scopeId}><div class="flex px-4 flex-col py-3"${_scopeId}><div class="uppercase mb-2 font-bold"${_scopeId}>Account</div><div class="flex gap-1 items-center"${_scopeId}><div class="flex"${_scopeId}>`);
        if (_ctx.$page.props.auth.user.photo) {
          _push2(`<img class="user_photo w-10 h-10"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.first_name)}${ssrRenderAttr("src", _ctx.$page.props.auth.user.photo)}${_scopeId}>`);
        } else {
          _push2(`<img src="/images/svg/profile.svg" class="w-10 h-10" alt="user profile"${_scopeId}>`);
        }
        _push2(`</div><div class="flex flex-col gap-[1px]"${_scopeId}><span${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.user.first_name + " " + _ctx.$page.props.auth.user.last_name)}</span><small${_scopeId}>${ssrInterpolate(_ctx.$page.props.auth.user.email)}</small></div></div></div>`);
        _push2(ssrRenderComponent(_component_Link, {
          class: "flex px-6 py-2 items-center hover:bg-indigo-500 hover:text-white hover:fill-white",
          href: _ctx.route("users.edit.profile")
        }, {
          default: withCtx((_2, _push3, _parent3, _scopeId2) => {
            if (_push3) {
              _push3(ssrRenderComponent(_component_icon, {
                class: "w-4 h-4 mr-2",
                name: "user_edit"
              }, null, _parent3, _scopeId2));
              _push3(` ${ssrInterpolate(_ctx.$t("Edit Profile"))}`);
            } else {
              return [
                createVNode(_component_icon, {
                  class: "w-4 h-4 mr-2",
                  name: "user_edit"
                }),
                createTextVNode(" " + toDisplayString(_ctx.$t("Edit Profile")), 1)
              ];
            }
          }),
          _: 1
        }, _parent2, _scopeId));
        if (_ctx.$page.props.auth.user.role.slug === "admin") {
          _push2(ssrRenderComponent(_component_Link, {
            class: "flex px-6 py-2 items-center hover:bg-indigo-500 hover:text-white hover:fill-white",
            href: _ctx.route("global")
          }, {
            default: withCtx((_2, _push3, _parent3, _scopeId2) => {
              if (_push3) {
                _push3(ssrRenderComponent(_component_icon, {
                  class: "w-4 h-4 mr-2",
                  name: "settings"
                }, null, _parent3, _scopeId2));
                _push3(` ${ssrInterpolate(_ctx.$t("Global Settings"))}`);
              } else {
                return [
                  createVNode(_component_icon, {
                    class: "w-4 h-4 mr-2",
                    name: "settings"
                  }),
                  createTextVNode(" " + toDisplayString(_ctx.$t("Global Settings")), 1)
                ];
              }
            }),
            _: 1
          }, _parent2, _scopeId));
        } else {
          _push2(`<!---->`);
        }
        _push2(ssrRenderComponent(_component_Link, {
          class: "flex items-center px-6 py-2 hover:bg-indigo-500 hover:text-white hover:fill-white w-full",
          href: _ctx.route("logout"),
          method: "delete",
          as: "button"
        }, {
          default: withCtx((_2, _push3, _parent3, _scopeId2) => {
            if (_push3) {
              _push3(ssrRenderComponent(_component_icon, {
                class: "w-4 h-4 mr-2",
                name: "logout"
              }, null, _parent3, _scopeId2));
              _push3(`${ssrInterpolate(_ctx.$t("Logout"))}`);
            } else {
              return [
                createVNode(_component_icon, {
                  class: "w-4 h-4 mr-2",
                  name: "logout"
                }),
                createTextVNode(toDisplayString(_ctx.$t("Logout")), 1)
              ];
            }
          }),
          _: 1
        }, _parent2, _scopeId));
        _push2(`</div>`);
      } else {
        return [
          createVNode("div", { class: "shadow-xl bg-white rounded text-sm" }, [
            createVNode("div", { class: "flex px-4 flex-col py-3" }, [
              createVNode("div", { class: "uppercase mb-2 font-bold" }, "Account"),
              createVNode("div", { class: "flex gap-1 items-center" }, [
                createVNode("div", { class: "flex" }, [
                  _ctx.$page.props.auth.user.photo ? (openBlock(), createBlock("img", {
                    key: 0,
                    class: "user_photo w-10 h-10",
                    alt: _ctx.$page.props.auth.user.first_name,
                    src: _ctx.$page.props.auth.user.photo
                  }, null, 8, ["alt", "src"])) : (openBlock(), createBlock("img", {
                    key: 1,
                    src: "/images/svg/profile.svg",
                    class: "w-10 h-10",
                    alt: "user profile"
                  }))
                ]),
                createVNode("div", { class: "flex flex-col gap-[1px]" }, [
                  createVNode("span", null, toDisplayString(_ctx.$page.props.auth.user.first_name + " " + _ctx.$page.props.auth.user.last_name), 1),
                  createVNode("small", null, toDisplayString(_ctx.$page.props.auth.user.email), 1)
                ])
              ])
            ]),
            createVNode(_component_Link, {
              class: "flex px-6 py-2 items-center hover:bg-indigo-500 hover:text-white hover:fill-white",
              href: _ctx.route("users.edit.profile")
            }, {
              default: withCtx(() => [
                createVNode(_component_icon, {
                  class: "w-4 h-4 mr-2",
                  name: "user_edit"
                }),
                createTextVNode(" " + toDisplayString(_ctx.$t("Edit Profile")), 1)
              ]),
              _: 1
            }, 8, ["href"]),
            _ctx.$page.props.auth.user.role.slug === "admin" ? (openBlock(), createBlock(_component_Link, {
              key: 0,
              class: "flex px-6 py-2 items-center hover:bg-indigo-500 hover:text-white hover:fill-white",
              href: _ctx.route("global")
            }, {
              default: withCtx(() => [
                createVNode(_component_icon, {
                  class: "w-4 h-4 mr-2",
                  name: "settings"
                }),
                createTextVNode(" " + toDisplayString(_ctx.$t("Global Settings")), 1)
              ]),
              _: 1
            }, 8, ["href"])) : createCommentVNode("", true),
            createVNode(_component_Link, {
              class: "flex items-center px-6 py-2 hover:bg-indigo-500 hover:text-white hover:fill-white w-full",
              href: _ctx.route("logout"),
              method: "delete",
              as: "button"
            }, {
              default: withCtx(() => [
                createVNode(_component_icon, {
                  class: "w-4 h-4 mr-2",
                  name: "logout"
                }),
                createTextVNode(toDisplayString(_ctx.$t("Logout")), 1)
              ]),
              _: 1
            }, 8, ["href"])
          ])
        ];
      }
    }),
    _: 1
  }, _parent));
  _push(`</div></div></div><div class="md:flex md:flex-grow md:overflow-hidden">`);
  if (!$data.enable_sidebar) {
    _push(`<div class="top-0 left-0 w-4 h-full left__bar"><div class="w-4 h-4 arr">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4",
      name: "arrow-right"
    }, null, _parent));
    _push(`</div></div>`);
  } else {
    _push(`<!---->`);
  }
  if (_ctx.$page.props.project || _ctx.$page.props.workspace) {
    _push(ssrRenderComponent(_component_workspace_menu, {
      class: ["sidebar shrink-0 md:w-60 overflow-y-auto", { "__hide": !$data.enable_sidebar }],
      onEnableSidebar: ($event) => $data.enable_sidebar = false,
      style: [_ctx.$page.props.project && _ctx.$page.props.project.background ? { backgroundColor: _ctx.$page.props.project.background.side } : {}]
    }, null, _parent));
  } else if (_ctx.$page.props.auth.user.role.slug === "admin") {
    _push(ssrRenderComponent(_component_main_menu, { class: "hidden md:block sidebar shrink-0 md:w-60 overflow-y-auto" }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`<div class="md:flex-1 md:overflow-y-auto" scroll-region>`);
  _push(ssrRenderComponent(_component_flash_messages, null, null, _parent));
  ssrRenderSlot(_ctx.$slots, "default", {}, null, _push, _parent);
  _push(`</div></div>`);
  if ($data.visible.project_create) {
    _push(ssrRenderComponent(_component_create_project, {
      onCreateProject: ($event) => $data.visible.project_create = false
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  if ($data.visible.create_workspace) {
    _push(ssrRenderComponent(_component_create_workspace, {
      onCreateWorkspace: ($event) => $data.visible.create_workspace = false
    }, null, _parent));
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/Layout.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const Layout = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  CreateWorkspace as C,
  Dropdown as D,
  Icon as I,
  Layout as L,
  SelectInput as S,
  InviteWorkspaceMember as a,
  CreateProject as b
};
