import { I as Icon } from "./Layout-p-cBGERf.js";
import { Link } from "@inertiajs/vue3";
import axios from "axios";
import { resolveComponent, mergeProps, useSSRContext, withCtx, createVNode, createTextVNode, toDisplayString } from "vue";
import { ssrRenderAttrs, ssrInterpolate, ssrRenderComponent, ssrIncludeBooleanAttr, ssrRenderAttr, ssrRenderList, ssrRenderStyle, ssrRenderClass } from "vue/server-renderer";
import { _ as _export_sfc } from "./_plugin-vue_export-helper-1tPrXgE0.js";
const _sfc_main$1 = {
  name: "board-filter",
  props: {
    project: Object,
    filters: { required: false },
    options: { required: false },
    top: { required: false, default: "95px" },
    left: { required: false, default: "inherit" },
    right: { required: false, default: "20px" }
  },
  components: { Icon, Link },
  emits: {
    doFilter: null,
    boardFilter: null
  },
  data() {
    return {
      open_filter: false,
      user_search: "",
      loading: true,
      users: [],
      filter_options: [],
      filtered_user: [],
      labels: [],
      selected_labels: [],
      enable_options: [],
      form: {
        user: this.filters.user,
        due: this.filters.due,
        label: this.filters.label
      }
    };
  },
  methods: {
    filterOptions(type, value) {
      if (this.filters[type]) {
        const filters = this.filters[type].split(",");
        return filters.includes(String(value));
      }
    },
    doFilter(bool, type, val) {
      this.addOrRemove(type, val);
    },
    addOrRemove(el, val) {
      val = String(val);
      if (!!this.form[el]) {
        const arr = String(this.form[el]).split(",");
        if (!arr.includes(val)) {
          arr.push(val);
        } else {
          const findIndex = arr.findIndex((u) => u === val);
          arr.splice(findIndex, 1);
        }
        this.form[el] = arr.join();
      } else {
        this.form[el] = val;
      }
      this.$emit("doFilter", this.form);
    },
    searchLabel(input) {
      return this.labels.filter((lab) => lab.name.toLowerCase().indexOf(input) > -1);
    },
    filterTask(bool, user_id, type) {
      if (type === "user")
        ;
      else {
        this.filter_options.push(type);
      }
    },
    getData() {
      axios.get(this.route("json.project.filter.data", this.project.id)).then((response) => {
        const data = response.data;
        this.users = data.assignees.map((user) => {
          return { name: user.user.name, id: user.user_id };
        });
        this.labels = data.labels;
        this.loading = false;
      });
    }
  },
  created() {
    this.getData();
    this.enable_options = this.options.split(",");
  }
};
function _sfc_ssrRender$1(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_icon = resolveComponent("icon");
  _push(`<div${ssrRenderAttrs(mergeProps({
    class: "absolute w-[250px] z-[200] rounded-[8px] text-sm bg-white shadow overflow-hidden",
    style: { top: $props.top, left: $props.left, right: $props.right }
  }, _attrs))}>`);
  if (!$data.loading) {
    _push(`<div class="flex gap-3 flex-col py-3 px-3"><div class="flex items-center justify-between gap-1"><div class="flex"></div><div class="flex text-center">${ssrInterpolate(_ctx.$t("Filter"))}</div><div class="flex hover:bg-gray-200 cursor-pointer rounded w-7 h-7 justify-center items-center">`);
    _push(ssrRenderComponent(_component_icon, {
      class: "w-4 h-4",
      name: "close"
    }, null, _parent));
    _push(`</div></div>`);
    if ($data.enable_options.includes("user")) {
      _push(`<div><div class="name my-2 font-medium">${ssrInterpolate(_ctx.$t("Members"))}</div><ul class="flex flex-col gap-3 h-auto max-h-40 overflow-y-auto"><li><label class="flex items-center cursor-pointer" for="filter__user__no"><input id="filter__user__no" class="w-4 h-4 mr-1" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("user", "null")) ? " checked" : ""}>`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-4 h-4 mr-1",
        name: "user"
      }, null, _parent));
      _push(`<span class="flex" type="button">${ssrInterpolate(_ctx.$t("No members"))}</span></label></li><li><label class="flex items-center cursor-pointer" for="filter__user__me"><input id="filter__user__me" class="w-4 h-4 mr-1" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("user", _ctx.$page.props.auth.user.id)) ? " checked" : ""}>`);
      if (_ctx.$page.props.auth.user.photo) {
        _push(`<img class="w-4 h-4 mr-1"${ssrRenderAttr("alt", _ctx.$page.props.auth.user.first_name)}${ssrRenderAttr("src", _ctx.$page.props.auth.user.photo)}>`);
      } else {
        _push(`<img src="/images/svg/profile.svg" class="w-4 h-4 mr-1" alt="user profile">`);
      }
      _push(`<span class="flex">${ssrInterpolate(_ctx.$t("Tasks assigned to me"))}</span></label></li><!--[-->`);
      ssrRenderList($data.users, (userObject, user_index) => {
        _push(`<li><label${ssrRenderAttr("for", "uid_" + user_index)} class="flex items-center cursor-pointer"><input${ssrRenderAttr("id", "uid_" + user_index)} class="w-4 h-4 mr-1" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("user", userObject.id)) ? " checked" : ""}>`);
        if (userObject.photo_path) {
          _push(`<img${ssrRenderAttr("aria-label", userObject.name)}${ssrRenderAttr("alt", userObject.name)} class="w-4 h-4 mr-1 rounded-full"${ssrRenderAttr("src", userObject.photo_path)}>`);
        } else {
          _push(`<img${ssrRenderAttr("aria-label", userObject.name)}${ssrRenderAttr("alt", userObject.name)} class="w-4 h-4 mr-1 rounded-full" src="/images/user.svg">`);
        }
        _push(`<span data-a="" class="" type="button"${ssrRenderAttr("tabindex", user_index)}>${ssrInterpolate(userObject.name)}</span></label></li>`);
      });
      _push(`<!--]--></ul></div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.enable_options.includes("due")) {
      _push(`<div><div class="name my-2">${ssrInterpolate(_ctx.$t("Due Date"))}</div><ul class="flex flex-col gap-3"><li><label class="flex gap-1 items-center" for="filter__due__no"><input id="filter__due__no" class="w-4 h-4 mr-1 cursor-pointer" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("due", "null")) ? " checked" : ""}><span class="flex items-center" type="button"><span class="bg-gray-100 mr-1 p-1 rounded-full">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-3 h-3 text-[#ffffff]",
        name: "calendar"
      }, null, _parent));
      _push(`</span> ${ssrInterpolate(_ctx.$t("No dates"))}</span></label></li><li><label class="flex gap-1 items-center" for="filter__due__over"><input id="filter__due__over" class="w-4 h-4 mr-1 cursor-pointer" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("due", "over")) ? " checked" : ""}><span class="flex items-center" type="button"><span class="bg-[#c9372c] mr-1 p-1 rounded-full">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-3 h-3 text-[#ffffff]",
        name: "clock"
      }, null, _parent));
      _push(`</span> ${ssrInterpolate(_ctx.$t("Overdue"))}</span></label></li><li><label class="flex gap-1 items-center" for="filter__due__next_day"><input id="filter__due__next_day" class="w-4 h-4 mr-1 cursor-pointer" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("due", "next_day")) ? " checked" : ""}><span class="flex items-center" type="button"><span class="bg-[#e56910] mr-1 p-1 rounded-full">`);
      _push(ssrRenderComponent(_component_icon, {
        class: "w-3 h-3 text-[#ffffff]",
        name: "clock"
      }, null, _parent));
      _push(`</span> ${ssrInterpolate(_ctx.$t("Due in the next day"))}</span></label></li></ul></div>`);
    } else {
      _push(`<!---->`);
    }
    if ($data.enable_options.includes("label")) {
      _push(`<div><div class="name my-2">${ssrInterpolate(_ctx.$t("Labels"))}</div><ul class="flex flex-col gap-3 max-h-40 overflow-y-auto"><!--[-->`);
      ssrRenderList($data.labels, (lab, lab_index) => {
        _push(`<li><label class="flex items-center gap-1"${ssrRenderAttr("for", "f_l_" + lab_index)}><input${ssrRenderAttr("id", "f_l_" + lab_index)} class="w-4 h-4 mr-1 cursor-pointer" type="checkbox"${ssrIncludeBooleanAttr($options.filterOptions("label", lab.id)) ? " checked" : ""}><span class="w-full px-2 py-1 rounded cursor-pointer hover:opacity-80" style="${ssrRenderStyle({ background: lab.color })}"${ssrRenderAttr("tabindex", lab_index)} data-color="orange">${ssrInterpolate(lab.name)}</span></label></li>`);
      });
      _push(`<!--]--></ul></div>`);
    } else {
      _push(`<!---->`);
    }
    _push(`</div>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div>`);
}
const _sfc_setup$1 = _sfc_main$1.setup;
_sfc_main$1.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/BoardFilter.vue");
  return _sfc_setup$1 ? _sfc_setup$1(props, ctx) : void 0;
};
const BoardFilter = /* @__PURE__ */ _export_sfc(_sfc_main$1, [["ssrRender", _sfc_ssrRender$1]]);
const _sfc_main = {
  name: "board-view-menu",
  props: {
    project: Object,
    filters: { required: false },
    view: {
      required: false
    }
  },
  components: { BoardFilter, Icon, Link },
  data() {
    return {
      icons: ["board", "table", "dashboard", "calendar", "time"],
      options: [
        { name: "Board", slug: "board" },
        { name: "List", slug: "table" },
        { name: "Report", slug: "dashboard" },
        { name: "Calendar", slug: "calendar" },
        { name: "Time Logs", slug: "time_logs" }
      ],
      position: { top: 0, left: 0, right: "inherit" }
    };
  },
  methods: {
    clearFilter(e) {
      e.preventDefault();
      e.stopPropagation();
      this.$emit("fClear", true);
    },
    findFilters() {
      const filters = Object.keys(this.filters);
      return filters.some((r) => ["due", "label", "user"].includes(r));
    },
    saveListTitle(e, id) {
      if (e.keyCode === 13 || e.type === "blur") {
        e.preventDefault();
        e.target.blur();
        if (e.target.innerText) {
          const title = e.target.innerText;
          axios.post(this.route("project.update", id), { title }).then((response) => {
            if (response.data) {
              this.project.title = response.data.title;
              if (this.project.slug !== response.data.slug) {
                window.location.href = this.route("projects.view.board", response.data.slug || response.data.id);
              }
            }
          });
        }
      }
    },
    starProject(e, id) {
      e.preventDefault();
      axios.post(this.route("json.p.starred.save", id));
      this.project.star = !this.project.star;
    }
  }
};
function _sfc_ssrRender(_ctx, _push, _parent, _attrs, $props, $setup, $data, $options) {
  const _component_icon = resolveComponent("icon");
  const _component_Link = resolveComponent("Link");
  _push(`<div${ssrRenderAttrs(mergeProps({ class: "project__view__menu w-full p-2 text-sm flex justify-first items-center" }, _attrs))}><div class="inline-flex w-full flex-wrap items-center"><div class="view__menus flex items-center flex-start gap-1 flex-wrap md:flex-nowrap"><h2${ssrRenderAttr("title", _ctx.$t("Click to rename project"))} class="text-lg font-bold hover:bg-[#a6c5e229] rounded px-3 mr-1 py-1" contenteditable="true">${ssrInterpolate($props.project.title)}</h2><div class="flex p-2 items-center cursor-pointer rounded hover:bg-[#a6c5e229]">`);
  if (!!$props.project.star) {
    _push(ssrRenderComponent(_component_icon, {
      name: "star",
      class: "w-5 h-5 fill-yellow-500 text-yellow-500 hover:fill-none hover:scale-125"
    }, null, _parent));
  } else {
    _push(ssrRenderComponent(_component_icon, {
      name: "star",
      class: "w-5 h-5 text-white hover:text-yellow-500 hover:scale-125"
    }, null, _parent));
  }
  _push(`</div><!--[-->`);
  ssrRenderList($data.options, (option, option_index) => {
    _push(ssrRenderComponent(_component_Link, {
      class: ["flex py-2 px-3 items-center cursor-pointer capitalize rounded", { "active": $props.view === option.slug }],
      href: _ctx.route("projects.view." + option.slug, $props.project.slug || $props.project.id)
    }, {
      default: withCtx((_, _push2, _parent2, _scopeId) => {
        if (_push2) {
          _push2(ssrRenderComponent(_component_icon, {
            name: $data.icons[option_index],
            class: "w-4 fill-[#ffffff] h-4 mr-[5px]"
          }, null, _parent2, _scopeId));
          _push2(` ${ssrInterpolate(_ctx.$t(option.name))}`);
        } else {
          return [
            createVNode(_component_icon, {
              name: $data.icons[option_index],
              class: "w-4 fill-[#ffffff] h-4 mr-[5px]"
            }, null, 8, ["name"]),
            createTextVNode(" " + toDisplayString(_ctx.$t(option.name)), 1)
          ];
        }
      }),
      _: 2
    }, _parent));
  });
  _push(`<!--]--></div><div class="flex items-center flex-start gap-1 ml-auto view__menus">`);
  if (["board", "table", "time_logs"].includes($props.view)) {
    _push(`<button class="${ssrRenderClass([{ "active": $options.findFilters() }, "flex pl-4 pr-2 items-center __filter cursor-pointer capitalize rounded hover:bg-[#a6c5e229]"])}">`);
    _push(ssrRenderComponent(_component_icon, {
      name: "filter",
      class: "w-4 fill-[#ffffff] h-4 mr-[5px]"
    }, null, _parent));
    _push(`<span>${ssrInterpolate(_ctx.$t("Filter"))}</span><span class="filter_clear">${ssrInterpolate(_ctx.$t("Clear All"))} `);
    _push(ssrRenderComponent(_component_icon, {
      name: "close",
      class: "w-4 h-4"
    }, null, _parent));
    _push(`</span></button>`);
  } else {
    _push(`<!---->`);
  }
  if (["board", "table"].includes($props.view)) {
    _push(`<button class="flex px-2 h-8 items-center cursor-pointer capitalize rounded hover:bg-[#a6c5e229]">`);
    _push(ssrRenderComponent(_component_icon, {
      name: "more-h",
      class: "w-6 fill-[#ffffff] h-6"
    }, null, _parent));
    _push(`</button>`);
  } else {
    _push(`<!---->`);
  }
  _push(`</div></div></div>`);
}
const _sfc_setup = _sfc_main.setup;
_sfc_main.setup = (props, ctx) => {
  const ssrContext = useSSRContext();
  (ssrContext.modules || (ssrContext.modules = /* @__PURE__ */ new Set())).add("resources/js/Shared/BoardViewMenu.vue");
  return _sfc_setup ? _sfc_setup(props, ctx) : void 0;
};
const BoardViewMenu = /* @__PURE__ */ _export_sfc(_sfc_main, [["ssrRender", _sfc_ssrRender]]);
export {
  BoardViewMenu as B,
  BoardFilter as a
};
